{-------------------------------------------------------------------------------

        Copyright:              Bernie Pope 2004

        Module:                 GhcInternals 

        Description:            Haskell interface to the GHC heap inspection
                                code, called through the FFI.

        Primary Authors:        Bernie Pope

-------------------------------------------------------------------------------}

{-
    This file is part of buddha.

    buddha is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    buddha is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with buddha; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

-}

module GhcInternals 
   ( reEval )  
   where

import Foreign 
   ( StablePtr
   , newStablePtr
   , freeStablePtr
   )

--------------------------------------------------------------------------------


foreign import ccall "reEvalC"
               reEvalC :: 
                          StablePtr f  -- the function to apply an encoded funtion and run it 
                       -> StablePtr a  -- the value of the original computation 
                       -> StablePtr b  -- the new computation to re-evaluate 
                       -> IO () 
-- the types are different because the compiler doesn't know that
-- they are in fact always the same value
reEval :: runApp -> a -> b -> IO () 
reEval runApp old new
   = do 
        runAppSPtr <- newStablePtr runApp
        oldStablePtr <- newStablePtr old
        newSPtr <- newStablePtr new
        reEvalC runAppSPtr oldStablePtr newSPtr
        freeStablePtr runAppSPtr 
        freeStablePtr oldStablePtr
        freeStablePtr newSPtr 
