{-------------------------------------------------------------------------------

        Copyright:              Bernie Pope 2004

        Module:                 IOUtils 

        Description:            Handy utilities for IO 

        Primary Authors:        Bernie Pope

-------------------------------------------------------------------------------}

{- 
    This file is part of buddha.

    buddha is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    buddha is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with buddha; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

-}

module IOUtils 
   ( tab
   , tabIO
   , tabsize
   , newline
   , space
   , dashline 
   , safeReadNat 
   , ljustify
   ) where

import Char 

--------------------------------------------------------------------------------

tabsize :: Int
tabsize = 8

tab :: IO ()
tab = putStr $ replicate tabsize ' '

tabIO :: IO a -> IO a 
tabIO action = tab >> action

newline :: IO ()
newline = putChar '\n'

space :: IO ()
space = putChar ' '

dashline :: Int -> IO ()
dashline n = putStr $ replicate n '-' 

-- this does not really belong here

safeReadNat :: String -> Maybe Int -> Maybe Int -> Maybe Int
safeReadNat str lo hi
   | length str > 0 && all isDigit str 
        = checkBounds ((read str)::Int) lo hi
   | otherwise = Nothing
   where
   checkBounds :: Int -> Maybe Int -> Maybe Int -> Maybe Int
   checkBounds i Nothing Nothing = Just i
   checkBounds i (Just low) Nothing 
      = if i >= low then Just i else Nothing
   checkBounds i Nothing (Just high)  
      = if i <= high then Just i else Nothing
   checkBounds i (Just low) (Just high)  
      = if i <= low && i >= high then Just i else Nothing

ljustify :: Int -> String -> String
ljustify n s = take n $ s ++ repeat ' '
