{-------------------------------------------------------------------------------

        Copyright:              Bernie Pope 2003

        Module:                 IsException

        Description:            call a foreign function to see if a heap value 
                                represents an Exception.

        Primary Authors:        Bernie Pope

-------------------------------------------------------------------------------}

{-
    This file is part of buddha.

    buddha is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    buddha is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with buddha; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

-}

module IsException
   ( isException )  
   where

import Foreign 
   ( StablePtr
   , newStablePtr
   , freeStablePtr
   )

--------------------------------------------------------------------------------

-- the foreign signature for the C interface 
foreign import ccall "isExceptionC"
               isExceptionC :: StablePtr a  -- the value to be inspected
                            -> IO Bool      -- true if the value encodes an IO action

isException :: a -> IO Bool 
isException obj
   = do objSPtr <- newStablePtr obj
        val     <- isExceptionC objSPtr
        freeStablePtr  objSPtr
        return val
