#include "Rts.h"
#include "Internals.h"
#include <stdio.h>

HaskellObj reifyC_ ( GraphNode* node
                   , StgClosure *AppNode
                   , StgClosure *CharNode
                   , StgClosure *IntNode
                   , StgClosure *IntegerNode
                   , StgClosure *FloatNode
                   , StgClosure *DoubleNode
                   , StgClosure *NullNode
                   , StgClosure *Nil
                   , StgClosure *Cons );


StgStablePtr reifyC ( StgStablePtr ptrObj
                    , StgStablePtr ptrAppNode
                    , StgStablePtr ptrCharNode
                    , StgStablePtr ptrIntNode
                    , StgStablePtr ptrIntegerNode
                    , StgStablePtr ptrFloatNode
                    , StgStablePtr ptrDoubleNode
                    , StgStablePtr ptrNullNode
                    , StgStablePtr ptrNil
                    , StgStablePtr ptrCons )
{
   HaskellObj obj;
   HaskellObj AppNode;
   HaskellObj CharNode;
   HaskellObj IntNode;
   HaskellObj IntegerNode;
   HaskellObj FloatNode;
   HaskellObj DoubleNode;
   HaskellObj NullNode;
   HaskellObj Nil;
   HaskellObj Cons;

   HaskellObj graph; 

   StgPtr sptrGraph;

   GraphNode *heapGraph;

   heapGraph = makeHeapGraph (ptrObj);

   /* it is important to do the stable pointer dereferencing AFTER the
    * call to makeHeapGraph */

   AppNode     = (HaskellObj) deRefStablePtr (ptrAppNode);
   CharNode    = (HaskellObj) deRefStablePtr (ptrCharNode);
   IntNode     = (HaskellObj) deRefStablePtr (ptrIntNode);
   IntegerNode = (HaskellObj) deRefStablePtr (ptrIntegerNode);
   FloatNode   = (HaskellObj) deRefStablePtr (ptrFloatNode);
   DoubleNode  = (HaskellObj) deRefStablePtr (ptrDoubleNode);
   NullNode    = (HaskellObj) deRefStablePtr (ptrNullNode);
   Nil         = (HaskellObj) deRefStablePtr (ptrNil);
   Cons        = (HaskellObj) deRefStablePtr (ptrCons);

   graph = reifyC_ ( heapGraph 
                   , AppNode
                   , CharNode
                   , IntNode
                   , IntegerNode
                   , FloatNode
                   , DoubleNode
                   , NullNode
                   , Nil
                   , Cons );

   freeGraph (heapGraph);
   sptrGraph = (getStablePtr ((StgPtr) graph));

   return (sptrGraph);
}

HaskellObj reifyC_ ( GraphNode* node
                   , StgClosure *AppNode
                   , StgClosure *CharNode
                   , StgClosure *IntNode
                   , StgClosure *IntegerNode
                   , StgClosure *FloatNode
                   , StgClosure *DoubleNode
                   , StgClosure *NullNode
                   , StgClosure *Nil
                   , StgClosure *Cons )
{

   switch (node->tag)
   {
      case Node:
      {
         int i;
         HaskellObj list;
         HaskellObj child;

         /* nullary constructors */
         if (node->numChildren == 0)
         {
            return (app6 ( AppNode
                         , rts_mkWord (node->unique)
                         , rts_mkString (node->val.descriptor)
                         , rts_mkInt (node->tag)
                         , rts_mkInt (0)
                         , Nil 
                         ));
         } 
         /* non-nullary constructors */
         else
         {
            list = Nil;
            
            /* XXX probably should optimise the tail recursion */
            for (i = node->numChildren - 1; i >= 0; i--)
            {
               child = reifyC_ ( node->children[i] 
                               , AppNode
                               , CharNode
                               , IntNode
                               , IntegerNode
                               , FloatNode
                               , DoubleNode
                               , NullNode
                               , Nil
                               , Cons );

               list = app3 (Cons, child, list);
            }
            return (app6 ( AppNode
                         , rts_mkWord (node->unique)
                         , rts_mkString (node->val.descriptor)
                         , rts_mkInt (node->tag)
                         , rts_mkInt (node->numChildren)
                         , list
                         ));
         } 
         break;
      }

      /*
      case EncodedFunctionAsTerm:
      {
         HaskellObj child;

         child = reifyC_ ( node->children[0]
                         , AppNode
                         , CharNode
                         , IntNode
                         , IntegerNode
                         , FloatNode
                         , DoubleNode
                         , NullNode
                         , Nil
                         , Cons );

         return (app6 ( AppNode
                      , rts_mkWord (node->unique) 
                      , rts_mkString ("")
                      , rts_mkInt (node->tag)
                      , rts_mkInt (1)
                      , app3 (Cons, child, Nil)
                      )) ;
         break;
      }

      case EncodedFunctionAsMap:
      {
         HaskellObj child;

         child = reifyC_ ( node->children[0]
                         , AppNode
                         , CharNode
                         , IntNode
                         , IntegerNode
                         , FloatNode
                         , DoubleNode
                         , NullNode
                         , Nil
                         , Cons );

         return (app6 ( AppNode
                      , rts_mkWord (node->unique) 
                      , rts_mkString ("")
                      , rts_mkInt (node->tag)
                      , rts_mkInt (1)
                      , app3 (Cons, child, Nil)
                      )) ;
         break;
      }
      */
      case Thunk:
      {
         return (app6 ( AppNode
                      , rts_mkWord (node->unique)
                      , rts_mkString ("")
                      , rts_mkInt (node->tag)
                      , rts_mkInt (0)
                      , Nil
                      )); 
         break;
      }

      case Cycle:
      {
         return (app6 ( AppNode
                      , rts_mkWord (node->unique) 
                      , rts_mkString ("")
                      , rts_mkInt (node->tag)
                      , rts_mkInt (0)
                      , Nil
                      )); 
         break;
      }

      case Async:
      {
         return (app6 ( AppNode
                      , rts_mkWord (node->unique)
                      , rts_mkString ("")
                      , rts_mkInt (node->tag)
                      , rts_mkInt (0)
                      , Nil
                      )); 
         break;
      }

      case Exception:
      {
         HaskellObj child;

         child = reifyC_ ( node->children[0]
                         , AppNode
                         , CharNode
                         , IntNode
                         , IntegerNode
                         , FloatNode
                         , DoubleNode
                         , NullNode
                         , Nil
                         , Cons );

         return (app6 ( AppNode
                      , rts_mkWord (node->unique)
                      , rts_mkString ("")
                      , rts_mkInt (node->tag)
                      , rts_mkInt (1)
                      , app3 (Cons, child, Nil)
                      )) ;
         break;

      }

      case Fun:
      {
         return (app6 ( AppNode
                      , rts_mkWord (node->unique)
                      , rts_mkString ("")
                      , rts_mkInt (node->tag)
                      , rts_mkInt (0)
                      , Nil
                      )); 
         break;
      }

      
      case Int:
      {
         return (app3 ( IntNode 
                      , rts_mkWord (node->unique)
                      , rts_mkInt (node->val.machineInt)
                      ));
         break;
      }

      case SmallInteger:
      {
         return (app3 ( IntNode
                      , rts_mkWord (node->unique)
                      , rts_mkInt (node->val.machineInt)
                      ));
         break;
      }

      case LargeInteger:
      {
         HaskellObj integerValue;
         integerValue = (HaskellObj) deRefStablePtr (node->val.largeIntegerSPtr);
         return (app3 ( IntegerNode
                      , rts_mkWord (node->unique)
                      , integerValue
                      ));
         break;
      }

      case Char:
      {
         return (app3 ( CharNode
                      , rts_mkWord (node->unique)
                      , rts_mkChar (node->val.character)
                      ));
         break;
      }

      case Float:
      {
         return (app3 ( FloatNode
                      , rts_mkWord (node->unique)
                      , rts_mkFloat (node->val.machineFloat)
                      ));
         break;
      }

      case Double:
      {
         return (app3 ( DoubleNode
                      , rts_mkWord (node->unique)
                      , rts_mkDouble (node->val.machineDouble)
                      ));
         break;
      }
      
      default:
      {
         /* fprintf (stderr, "null: %d\n", node->tag); */
         return (NullNode);
         break;
      }
   }
}
