{-------------------------------------------------------------------------------

        Copyright:              Bernie Pope 2004 

        Module:                 ReifyHs 

        Description:            Turn haskell values into meta representations 

                                reify :: a -> IO Graph

                                The Graph type captures cycles, thunks and
                                all data types, but not functions. 

        Primary Authors:        Bernie Pope

        Notes:                  Relies on GHC and ReifyC.c, GhcInternalsC.c

-------------------------------------------------------------------------------}

{-
    This file is part of buddha.

    buddha is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    buddha is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with buddha; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

-}

module ReifyHs 
   ( reify 
   , reifyVal )
   where

import Graph
   ( Graph (..) )

import Foreign 
   ( StablePtr
   , newStablePtr 
   , deRefStablePtr 
   , freeStablePtr 
   )

import System.IO.Unsafe 
   ( unsafePerformIO )

import Data.Word
   ( Word )

import Meta (Val (V))

--------------------------------------------------------------------------------

type AppNodeType = Word -> String -> Int -> Int -> [Graph] -> Graph

foreign import ccall "reifyC"
               reifyC :: StablePtr a                             -- the value to be inspected
                      -> StablePtr AppNodeType                   -- AppNode
                      -> StablePtr (Word -> Char -> Graph)       -- Char
                      -> StablePtr (Word -> Int -> Graph)        -- Int 
                      -> StablePtr (Word -> Integer -> Graph)    -- Integer
                      -> StablePtr (Word -> Float -> Graph)      -- Float 
                      -> StablePtr (Word -> Double -> Graph)     -- Double 
                      -> StablePtr Graph                         -- Null 
                      -> StablePtr [Graph]                       -- Nil 
                      -> StablePtr (Graph -> [Graph] -> [Graph]) -- Cons 
                      -> IO (StablePtr Graph)                    -- result

{-# NOINLINE sptrAppNode #-}
sptrAppNode :: StablePtr AppNodeType
sptrAppNode = unsafePerformIO $ newStablePtr AppNode 

{-# NOINLINE sptrChar #-}
sptrChar :: StablePtr (Word -> Char -> Graph) 
sptrChar = unsafePerformIO $ newStablePtr CharNode

{-# NOINLINE sptrInt #-}
sptrInt :: StablePtr (Word -> Int -> Graph)
sptrInt = unsafePerformIO $ newStablePtr IntNode

{-# NOINLINE sptrInteger #-}
sptrInteger :: StablePtr (Word -> Integer -> Graph)
sptrInteger = unsafePerformIO $ newStablePtr IntegerNode
 
{-# NOINLINE sptrFloat #-}
sptrFloat :: StablePtr (Word -> Float -> Graph)
sptrFloat = unsafePerformIO $ newStablePtr FloatNode

{-# NOINLINE sptrDouble #-}
sptrDouble :: StablePtr (Word -> Double -> Graph)
sptrDouble = unsafePerformIO $ newStablePtr DoubleNode
 
{-# NOINLINE sptrNull #-}
sptrNull :: StablePtr Graph
sptrNull = unsafePerformIO $ newStablePtr NullNode

{-# NOINLINE sptrNil #-}
sptrNil :: StablePtr [Graph]
sptrNil = unsafePerformIO $ newStablePtr ([] :: [Graph])

{-# NOINLINE sptrCons #-}
sptrCons :: StablePtr (Graph -> [Graph] -> [Graph]) 
sptrCons = unsafePerformIO $ newStablePtr ((:) :: Graph -> [Graph] -> [Graph])

-- package up the whole thing in a nice Haskell interface
reify :: a -> IO Graph
reify x
   = do sptrObj <- newStablePtr x
        sptrGraph <- reifyC sptrObj
                            sptrAppNode
                            sptrChar
                            sptrInt 
                            sptrInteger 
                            sptrFloat
                            sptrDouble
                            sptrNull 
                            sptrNil
                            sptrCons
        graph <- deRefStablePtr sptrGraph
        freeStablePtr sptrGraph 
        freeStablePtr sptrObj 
        return graph 

reifyVal :: Val -> IO Graph
reifyVal (V x) = reify x
