{-------------------------------------------------------------------------------

        Copyright:              Bernie Pope 2004

        Module:                 Tables 

        Description:            Tables for recording function calls and
                                applications for higher-order arguments. 

        Primary Authors:        Bernie Pope

        Notes:                  Note very carefully that this code uses
                                unsafePerformIO extensively to implement
                                global mutable variables.

                                To stop the compiler for doing the wrong
                                optimisations we must turn them off.

                                Tread very carefully in this module.

                                Also note that the code in this module is
                                likely to be called many times in the execution
                                of a debugging program - so please make it 
                                frugal. Careless extra cycles or bytes could
                                end up costing a lot.

-------------------------------------------------------------------------------}

{-
    This file is part of buddha.

    buddha is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    buddha is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with buddha; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

-}

module Tables 
   ( initialCallCount
   , getFunCount
   , updateFunTable
   , node
   , callTable 
   , funTable
   , Record (..)
   , FunRecord (..)
   , con
   , ref
   ) where

import Data.PackedString
   ( PackedString )

import Data 
   ( Record (..)
   , FunRecord (..)
   )

import Meta
   ( Val )

import TablesUnsafe

--------------------------------------------------------------------------------

-- does nothing
initialCallCount :: IO Int
initialCallCount = return 0

getCount :: Int -> (Int -> a) -> a
getCount parent f 
   = let nextCount = inc parent in seq nextCount (f nextCount) 

{- the NOINLINE here is important. Without this GHC can execute the
   counter updates for partial applications. But we don't want this
   to happen
-} 
{-# NOINLINE node #-}
node :: PackedString -> [Val] -> Int -> Int -> PackedString -> (Int -> a) -> a
node name args parent line modName body
   = getCount parent (\c -> update parent c name args line modName (body c))
