{-------------------------------------------------------------------------------

        Copyright:              Bernie Pope 2004

        Module:                 Terminal 

        Description:            Setting up the terminal for input 

        Primary Authors:        Bernie Pope

        Notes:                  Relies upon C code in SetReadLineStreams.c to
                                set the input and output streams used by 
                                readline.

                                Also, it resets stdin and stdout to point to
                                the current terminal device. This is because
                                buddha cannot rely on those handles having
                                the desired semantics - the debugged program
                                might close them, or they might not even
                                be connected to a terminal in the case of
                                a re-direction being set up by the shell.

-------------------------------------------------------------------------------}

{- 
    This file is part of buddha.

    buddha is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    buddha is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with buddha; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

-}

module Terminal
   ( initTerminal
   , endTerminal
   ) 
   where

import System.Console.Readline as Readline
   ( initialize
   , resetTerminal
   ) 

import GHC.Handle
   ( hDuplicateTo )

import IO
   ( stdin
   , stdout
   , openFile
   , IOMode (..)
   )

import Foreign.Marshal.Utils
   ( toBool )

import Foreign.C.String
   ( CString
   , withCString )

--------------------------------------------------------------------------------

foreign import ccall "setReadLineInOutStream" 
                     setReadLineInOutStream :: CString -> IO Int

initTerminal :: FilePath -> IO Bool 
initTerminal file 
   = do hin <- openFile file ReadMode
        hDuplicateTo hin stdin
        hout <- openFile file WriteMode
        hDuplicateTo hout stdout
        success <- withCString file setReadLineInOutStream 
        if (toBool success)
           then do Readline.initialize
                   return True
           else return False 

endTerminal :: IO ()
endTerminal = Readline.resetTerminal Nothing
