module Char_B
       (isAlpha, isAlphaNum, isAscii, isControl, isDigit, isHexDigit,
	isLatin1, isLower, isOctDigit, isPrint, isSpace, isUpper, toLower,
	toUpper, ord, chr, digitToInt, intToDigit, readLitChar,
	showLitChar, lexLitChar)
       where
import qualified Buddha as B
import Prelude_B
import Prims_B (primReadLitChar, primShowLitChar, primLexLitChar)
v0 = B.ps "Char"
 
isAlpha :: B.D (Char -> Bool)
isAlpha v1 c = ((||) v1 ((isUpper v1 c)) ((isLower v1 c)))
 
isAlphaNum :: B.D (Char -> Bool)
isAlphaNum v2 c = ((||) v2 ((isAlpha v2 c)) ((isDigit v2 c)))
 
isAscii :: B.D (Char -> Bool)
isAscii v3 c = ((<) v3 ((fromEnum v3 c)) 128)
 
isControl :: B.D (Char -> Bool)
isControl v4 c
  = ((||) v4 (((<) v4 c ' '))
       (((&&) v4 (((>=) v4 c '\DEL')) (((<=) v4 c '\159')))))
 
isDigit :: B.D (Char -> Bool)
isDigit v5 c = ((&&) v5 (((>=) v5 c '0')) (((<=) v5 c '9')))
 
isHexDigit :: B.D (Char -> Bool)
isHexDigit v6 c
  = ((||) v6 (((&&) v6 (((>=) v6 c '0')) (((<=) v6 c '9'))))
       (((||) v6 (((&&) v6 (((>=) v6 c 'A')) (((<=) v6 c 'F'))))
	   (((&&) v6 (((>=) v6 c 'a')) (((<=) v6 c 'f')))))))
 
isLatin1 :: B.D (Char -> Bool)
isLatin1 v7 c = ((<) v7 c '\255')
 
isLower :: B.D (Char -> Bool)
isLower v8 c
  = ((||) v8 (((&&) v8 (((>=) v8 c 'a')) (((<=) v8 c 'z'))))
       (((||) v8 (((&&) v8 (((>=) v8 c '\223')) (((<=) v8 c '\246'))))
	   (((&&) v8 (((>=) v8 c '\248')) (((<=) v8 c '\255')))))))
 
isOctDigit :: B.D (Char -> Bool)
isOctDigit v9 c = ((&&) v9 (((>=) v9 c '0')) (((<=) v9 c '7')))
 
isPrint :: B.D (Char -> Bool)
isPrint v10 c = (not v10 ((isControl v10 c)))
 
isSpace :: B.D (Char -> Bool)
isSpace v11 c = (elem v11 c " \t\n\r\f\v\160")
 
isUpper :: B.D (Char -> Bool)
isUpper v12 c
  = ((||) v12 (((&&) v12 (((>=) v12 c 'A')) (((<=) v12 c 'Z'))))
       (((||) v12 (((&&) v12 (((>=) v12 c '\192')) (((<=) v12 c '\214'))))
	   (((&&) v12 (((>=) v12 c '\216')) (((<=) v12 c '\222')))))))
 
toLower :: B.D (Char -> Char)
toLower v13 c
  = case (isUpper v13 c) of
       True -> (toEnum v13
		  (((+) v13 (((-) v13 ((fromEnum v13 c)) ((fromEnum v13 'A'))))
		      ((fromEnum v13 'a')))))
       False -> case (otherwise v13) of
		   True -> c
 
toUpper :: B.D (Char -> Char)
toUpper v14 c
  = case (isLower v14 c) of
       True -> (toEnum v14
		  (((+) v14 (((-) v14 ((fromEnum v14 c)) ((fromEnum v14 'a'))))
		      ((fromEnum v14 'A')))))
       False -> case (otherwise v14) of
		   True -> c
 
ord :: B.D (Char -> Int)
ord v16 v15 = (fromEnum v16 v15)
 
chr :: B.D (Int -> Char)
chr v18 v17 = (toEnum v18 v17)
 
digitToInt :: B.D (Char -> Int)
digitToInt v19 c
  = case (isDigit v19 c) of
       True -> ((-) v19 ((ord v19 c)) ((ord v19 '0')))
       False -> case ((&&) v19 (((>=) v19 c 'a')) (((<=) v19 c 'f'))) of
		   True -> ((+) v19 (((-) v19 ((ord v19 c)) ((ord v19 'a')))) 10)
		   False -> case ((&&) v19 (((>=) v19 c 'A')) (((<=) v19 c 'F'))) of
			       True -> ((+) v19 (((-) v19 ((ord v19 c)) ((ord v19 'A')))) 10)
			       False -> case (otherwise v19) of
					   True -> (error v19 "Char.digitToInt: not a digit")
 
intToDigit :: B.D (Int -> Char)
intToDigit v20 i
  = case ((&&) v20 (((>=) v20 i 0)) (((<=) v20 i 9))) of
       True -> (chr v20 (((+) v20 ((ord v20 '0')) i)))
       False -> case ((&&) v20 (((>=) v20 i 10)) (((<=) v20 i 15))) of
		   True -> (chr v20 (((-) v20 (((+) v20 ((ord v20 'a')) i)) 10)))
		   False -> case (otherwise v20) of
			       True -> (error v20 "Char.intToDigit: not a digit")
 
readLitChar :: B.D ([Char] -> [(Char, [Char])])
readLitChar v21 x = (primReadLitChar v21 x)
 
showLitChar :: B.D (Char -> [Char] -> [Char])
showLitChar v22 c s = (primShowLitChar v22 c s)
 
lexLitChar :: B.D ([Char] -> [([Char], [Char])])
lexLitChar v23 x = (primLexLitChar v23 x)