module Complex_B
       (Complex((:+)), realPart, imagPart, conjugate, mkPolar, cis, polar,
	magnitude, phase)
       where
import qualified Buddha as B
import Prelude_B
v0 = B.ps "Complex"
 
infix 6 :+
 
default ()
 
data (RealFloat a) => Complex a = !a :+ !a
 
realPart, imagPart :: (RealFloat a) => B.D (Complex a -> a)
realPart v35 v1
  = case v1 of
       (x :+ y) -> x
imagPart v36 v2
  = case v2 of
       (x :+ y) -> y
 
conjugate :: (RealFloat a) => B.D (Complex a -> Complex a)
conjugate v37 v3
  = case v3 of
       (x :+ y) -> (:+) x ((Prelude_B.negate_bUdDhA v37 y))
 
mkPolar :: (RealFloat a) => B.D (a -> a -> Complex a)
mkPolar v38 r theta
  = (:+) (((*) v38 r ((cos v38 theta))))
      (((*) v38 r ((sin v38 theta))))
 
cis :: (RealFloat a) => B.D (a -> Complex a)
cis v39 theta = (:+) ((cos v39 theta)) ((sin v39 theta))
 
polar :: (RealFloat a) => B.D (Complex a -> (a, a))
polar v40 z = ((magnitude v40 z), (phase v40 z))
 
magnitude :: (RealFloat a) => B.D (Complex a -> a)
magnitude v41 v4
  = case v4 of
       (x :+ y) -> let k = \ v42 ->
			     (max v42 ((exponent v42 x)) ((exponent v42 y)))
		       mk = \ v43 -> (Prelude_B.negate_bUdDhA v43 (k v43))
		     in
		     (scaleFloat v41 (k v41)
			((sqrt v41
			    (((+) v41 (((^) v41 ((scaleFloat v41 (mk v41) x)) (2 :: Int)))
				(((^) v41 ((scaleFloat v41 (mk v41) y)) (2 :: Int))))))))
 
phase :: (RealFloat a) => B.D (Complex a -> a)
phase v44 v5
  = case v5 of
       (x :+ y) -> case ((&&) v44 (((==) v44 x 0)) (((==) v44 y 0))) of
		      True -> 0
		      False -> case (otherwise v44) of
				  True -> (atan2 v44 y x)
 
instance (RealFloat a) => Num (Complex a) where
   (v45 + v7) v6
     = case (v7, v6) of
	  ((x :+ y), (x' :+ y')) -> (:+) (((+) v45 x x')) (((+) v45 y y'))
   (v46 - v9) v8
     = case (v9, v8) of
	  ((x :+ y), (x' :+ y')) -> (:+) (((-) v46 x x')) (((-) v46 y y'))
   (v47 * v11) v10
     = case (v11, v10) of
	  ((x :+ y), (x' :+ y')) -> (:+)
				      (((-) v47 (((*) v47 x x')) (((*) v47 y y'))))
				      (((+) v47 (((*) v47 x y')) (((*) v47 y x'))))
   negate_bUdDhA v48 v12
     = case v12 of
	  (x :+ y) -> (:+) ((negate_bUdDhA v48 x)) ((negate_bUdDhA v48 y))
   abs v49 z = (:+) ((magnitude v49 z)) 0
   signum v50 v13
     = let v14
	     = \ v52 ->
		 case v13 of
		    z@(x :+ y) -> let r = \ v53 -> (magnitude v53 z) in
				    (:+) (((/) v52 x (r v52))) (((/) v52 y (r v52)))
		    _ -> (Prelude_B.error v52 "No Match")
	 in
	 case ((Prelude_B.==) v50 v13 0) of
	    True -> 0
	    False -> (v14 v50)
   fromInteger_bUdDhA v54 n = (:+) ((fromInteger_bUdDhA v54 n)) 0
 
instance (RealFloat a) => Fractional (Complex a) where
   (v55 / v16) v15
     = case (v16, v15) of
	  ((x :+ y), (x' :+ y')) -> let x''
					  = \ v56 -> (scaleFloat v56 (k v56) x')
					y'' = \ v57 -> (scaleFloat v57 (k v57) y')
					k = \ v58 ->
					      (Prelude_B.negate_bUdDhA v58
						 (max v58 ((exponent v58 x')) ((exponent v58 y'))))
					d = \ v59 ->
					      ((+) v59 (((*) v59 x' (x'' v59)))
						 (((*) v59 y' (y'' v59))))
				      in
				      (:+)
					(((/) v55
					    (((+) v55 (((*) v55 x (x'' v55)))
						(((*) v55 y (y'' v55)))))
					    (d v55)))
					(((/) v55
					    (((-) v55 (((*) v55 y (x'' v55)))
						(((*) v55 x (y'' v55)))))
					    (d v55)))
   fromRational_bUdDhA v60 a = (:+) ((fromRational_bUdDhA v60 a)) 0
 
instance (RealFloat a) => Floating (Complex a) where
   pi = \ v61 -> (:+) (pi v61) 0
   exp v62 v17
     = case v17 of
	  (x :+ y) -> let expx = \ v63 -> (exp v63 x) in
			(:+) (((*) v62 (expx v62) ((cos v62 y))))
			  (((*) v62 (expx v62) ((sin v62 y))))
   log v64 z = (:+) ((log v64 ((magnitude v64 z)))) ((phase v64 z))
   sqrt v65 v18
     = let v19
	     = \ v67 ->
		 case v18 of
		    z@(x :+ y) -> let v69
					= \ v68 ->
					    case ((<) v68 x 0) of
					       True -> ((v' v68), (u' v68))
					       False -> ((u' v68), (v' v68))
				      u = \ v70 -> (\ (u, v) -> u) (v69 v70)
				      v = \ v71 -> (\ (u, v) -> v) (v69 v71)
				      v' = \ v72 -> ((/) v72 ((abs v72 y)) (((*) v72 (u' v72) 2)))
				      u'
					= \ v73 ->
					    (sqrt v73
					       (((/) v73
						   (((+) v73 ((magnitude v73 z)) ((abs v73 x))))
						   2)))
				    in
				    (:+) (u v67)
				      (case ((<) v67 y 0) of
					  True -> (Prelude_B.negate_bUdDhA v67 (v v67))
					  False -> (v v67))
		    _ -> (Prelude_B.error v67 "No Match")
	 in
	 case ((Prelude_B.==) v65 v18 0) of
	    True -> 0
	    False -> (v19 v65)
   sin v74 v20
     = case v20 of
	  (x :+ y) -> (:+) (((*) v74 ((sin v74 x)) ((cosh v74 y))))
			(((*) v74 ((cos v74 x)) ((sinh v74 y))))
   cos v75 v21
     = case v21 of
	  (x :+ y) -> (:+) (((*) v75 ((cos v75 x)) ((cosh v75 y))))
			(((*) v75 ((Prelude_B.negate_bUdDhA v75 (sin v75 x)))
			    ((sinh v75 y))))
   tan v76 v22
     = case v22 of
	  (x :+ y) -> let sinx = \ v77 -> (sin v77 x)
			  cosx = \ v78 -> (cos v78 x)
			  sinhy = \ v79 -> (sinh v79 y)
			  coshy = \ v80 -> (cosh v80 y)
			in
			((/) v76
			   ((:+) (((*) v76 (sinx v76) (coshy v76)))
			      (((*) v76 (cosx v76) (sinhy v76))))
			   ((:+) (((*) v76 (cosx v76) (coshy v76)))
			      (((*) v76 ((Prelude_B.negate_bUdDhA v76 (sinx v76)))
				  (sinhy v76)))))
   sinh v81 v23
     = case v23 of
	  (x :+ y) -> (:+) (((*) v81 ((cos v81 y)) ((sinh v81 x))))
			(((*) v81 ((sin v81 y)) ((cosh v81 x))))
   cosh v82 v24
     = case v24 of
	  (x :+ y) -> (:+) (((*) v82 ((cos v82 y)) ((cosh v82 x))))
			(((*) v82 ((sin v82 y)) ((sinh v82 x))))
   tanh v83 v25
     = case v25 of
	  (x :+ y) -> let siny = \ v84 -> (sin v84 y)
			  cosy = \ v85 -> (cos v85 y)
			  sinhx = \ v86 -> (sinh v86 x)
			  coshx = \ v87 -> (cosh v87 x)
			in
			((/) v83
			   ((:+) (((*) v83 (cosy v83) (sinhx v83)))
			      (((*) v83 (siny v83) (coshx v83))))
			   ((:+) (((*) v83 (cosy v83) (coshx v83)))
			      (((*) v83 (siny v83) (sinhx v83)))))
   asin v88 v26
     = case v26 of
	  z@(x :+ y) -> let v90
			      = \ v89 ->
				  (log v89
				     (((+) v89 ((:+) ((Prelude_B.negate_bUdDhA v89 y)) x)
					 ((sqrt v89 (((-) v89 1 (((*) v89 z z)))))))))
			    x' = \ v91 -> (\ (x' :+ y') -> x') (v90 v91)
			    y' = \ v92 -> (\ (x' :+ y') -> y') (v90 v92)
			  in (:+) (y' v88) ((Prelude_B.negate_bUdDhA v88 (x' v88)))
   acos v93 v27
     = case v27 of
	  z@(x :+ y) -> let v95
			      = \ v94 ->
				  (log v94
				     (((+) v94 z
					 ((:+) ((Prelude_B.negate_bUdDhA v94 (y' v94))) (x' v94)))))
			    x'' = \ v96 -> (\ (x'' :+ y'') -> x'') (v95 v96)
			    y'' = \ v97 -> (\ (x'' :+ y'') -> y'') (v95 v97)
			    v99 = \ v98 -> (sqrt v98 (((-) v98 1 (((*) v98 z z)))))
			    x' = \ v100 -> (\ (x' :+ y') -> x') (v99 v100)
			    y' = \ v101 -> (\ (x' :+ y') -> y') (v99 v101)
			  in (:+) (y'' v93) ((Prelude_B.negate_bUdDhA v93 (x'' v93)))
   atan v102 v28
     = case v28 of
	  z@(x :+ y) -> let v104
			      = \ v103 ->
				  (log v103
				     (((/) v103 ((:+) (((-) v103 1 y)) x)
					 ((sqrt v103 (((+) v103 1 (((*) v103 z z)))))))))
			    x' = \ v105 -> (\ (x' :+ y') -> x') (v104 v105)
			    y' = \ v106 -> (\ (x' :+ y') -> y') (v104 v106)
			  in (:+) (y' v102) ((Prelude_B.negate_bUdDhA v102 (x' v102)))
   asinh v107 z
     = (log v107
	  (((+) v107 z ((sqrt v107 (((+) v107 1 (((*) v107 z z)))))))))
   acosh v108 z
     = (log v108
	  (((+) v108 z
	      (((*) v108 (((+) v108 z 1))
		  ((sqrt v108 (((/) v108 (((-) v108 z 1)) (((+) v108 z 1)))))))))))
   atanh v109 z
     = (log v109
	  (((/) v109 (((+) v109 1 z))
	      ((sqrt v109 (((-) v109 1 (((*) v109 z z)))))))))
 
instance (Prelude_B.Eq a, RealFloat a) => Prelude_B.Eq (Complex a)
	 where
   (v110 == v30) v29
     = case (v30, v29) of
	  (((:+) x1 x2), ((:+) x3 x4)) -> ((Prelude_B.&&) v110
					     (((Prelude_B.==) v110 x1 x3))
					     (((Prelude_B.==) v110 x2 x4)))
 
instance (Prelude_B.Read a, RealFloat a) => Prelude_B.Read
	 (Complex a) where
   readsPrec v111 d s0
     = (Prelude_B.concat v111
	  [(Prelude_B.readParen v111 (((Prelude_B.>) v111 d 6))
	      ((B.fu1
		  (\ s0 ->
		     ((>>=) v111 ((Prelude_B.readsPrec v111 7 s0))
			((B.fu1
			    (\ v33 ->
			       case v33 of
				  (x1, s1) -> ((>>=) v111 ((Prelude_B.lex v111 s1))
						 ((B.fu1
						     (\ v32 ->
							case v32 of
							   (":+", s2) -> ((>>=) v111
									    ((Prelude_B.readsPrec
										v111
										7
										s2))
									    ((B.fu1
										(\ v31 ->
										   case v31 of
										      (x2,
										       s3) -> (Prelude_B.return
												 v111
												 ((:+)
												    x1
												    x2,
												  s3))
										      _ -> (Prelude_B.fail
											      v111
											      "pattern match error:  (-2,-2)")))))
							   _ -> (Prelude_B.fail v111
								   "pattern match error:  (-2,-2)")))))
				  _ -> (Prelude_B.fail v111 "pattern match error:  (-2,-2)"))))))))
	      s0)])
 
instance (Prelude_B.Show a, RealFloat a) => Prelude_B.Show
	 (Complex a) where
   showsPrec v112 d v34 s
     = case v34 of
	  ((:+) x1 x2) -> (Prelude_B.showApply v112
			     (((Prelude_B.>) v112 d 6))
			     [(Prelude_B.showsPrec' v112 7 x1),
			      (B.fu1 (Prelude_B.showString v112 ":+")),
			      (Prelude_B.showsPrec' v112 7 x2)]
			     s)