module DirectoryPrims_B ( primCreateDirectory,
                          primRemoveDirectory,
                          primRemoveFile,
                          primRenameDirectory,
                          primRenameFile,
                          primGetDirectoryContents,
                          primGetCurrentDirectory,
                          primSetCurrentDirectory,
                          primDoesFileExist,
                          primDoesDirectoryExist,
                          primGetPermissions,
                          primSetPermissions,
                          primGetModificationTime,
                          D.Permissions (Permissions),
                          readable,
                          searchable,
                          writable,
                          executable,
                          primPermissionsEq,
                          primPermissionsLte,
                          primPermissionsShowsPrec,
                          primPermissionsReadsPrec
                        )
                        where

import Prelude
import Buddha as B
import qualified Directory as D
import IOPrims_B 

primCreateDirectory _ f = threadIO $ D.createDirectory f

primRemoveDirectory _ f = threadIO $ D.removeDirectory f

primRemoveFile _ f = threadIO $ D.removeFile f

primRenameDirectory _ f1 f2 = threadIO $ D.renameDirectory f1 f2

primRenameFile _ f1 f2 = threadIO $ D.renameFile f1 f2

primGetDirectoryContents _ f = threadIO $ D.getDirectoryContents f

primGetCurrentDirectory _ = threadIO $ D.getCurrentDirectory

primSetCurrentDirectory _ f = threadIO $ D.setCurrentDirectory f

primDoesFileExist _ f = threadIO $ D.doesFileExist f

primDoesDirectoryExist _ f = threadIO $ D.doesDirectoryExist f

primGetPermissions _ f = threadIO $ D.getPermissions f

primSetPermissions _ f p = threadIO $ D.setPermissions f p

primGetModificationTime _ f = threadIO $ D.getModificationTime f

readable _ p = D.readable p

searchable _ p = D.searchable p

writable _ p = D.writable p

executable _ p = D.executable p

primPermissionsEq :: B.D (D.Permissions -> D.Permissions -> Bool)
primPermissionsEq _ p1 p2 = (p1 == p2)

primPermissionsLte :: B.D (D.Permissions -> D.Permissions -> Bool)
primPermissionsLte _ p1 p2 = (p1 <= p2)

primPermissionsShowsPrec :: B.D (Int -> D.Permissions -> String -> String)
primPermissionsShowsPrec _ i p s = showsPrec i p s 

primPermissionsReadsPrec :: B.D (Int -> String -> [(D.Permissions, String)])
primPermissionsReadsPrec _ i s = readsPrec i s
