module Directory_B
       (Permissions(Permissions), readable, writable, executable,
	searchable, createDirectory, removeDirectory, removeFile,
	renameDirectory, renameFile, getDirectoryContents,
	getCurrentDirectory, setCurrentDirectory, doesFileExist,
	doesDirectoryExist, getPermissions, setPermissions,
	getModificationTime)
       where
import qualified Buddha as B
import Prelude_B
import Time_B (ClockTime)
import DirectoryPrims_B (primCreateDirectory, primRemoveDirectory,
			 primRemoveFile, primRenameDirectory, primRenameFile,
			 primGetDirectoryContents, primGetCurrentDirectory,
			 primSetCurrentDirectory, primDoesFileExist, primDoesDirectoryExist,
			 primGetPermissions, primSetPermissions, primGetModificationTime,
			 Permissions(..), readable, writable, executable, searchable,
			 primPermissionsEq, primPermissionsLte, primPermissionsShowsPrec,
			 primPermissionsReadsPrec)
v0 = B.ps "Directory"
 
instance Eq Permissions where
   (v1 == p1) p2 = (primPermissionsEq v1 p1 p2)
 
instance Ord Permissions where
   (v2 <= p1) p2 = (primPermissionsLte v2 p1 p2)
 
instance Show Permissions where
   showsPrec v3 a b c = (primPermissionsShowsPrec v3 a b c)
 
instance Read Permissions where
   readsPrec v4 a b = (primPermissionsReadsPrec v4 a b)
 
createDirectory :: B.D ([Char] -> IO ())
createDirectory v5 f = (primCreateDirectory v5 f)
 
removeDirectory :: B.D ([Char] -> IO ())
removeDirectory v6 f = (primRemoveDirectory v6 f)
 
removeFile :: B.D ([Char] -> IO ())
removeFile v7 f = (primRemoveFile v7 f)
 
renameDirectory :: B.D ([Char] -> [Char] -> IO ())
renameDirectory v8 f1 f2 = (primRenameDirectory v8 f1 f2)
 
renameFile :: B.D ([Char] -> [Char] -> IO ())
renameFile v9 f1 f2 = (primRenameFile v9 f1 f2)
 
getDirectoryContents :: B.D ([Char] -> IO [[Char]])
getDirectoryContents v10 f = (primGetDirectoryContents v10 f)
 
getCurrentDirectory :: B.D (IO [Char])
getCurrentDirectory = \ v11 -> (primGetCurrentDirectory v11)
 
setCurrentDirectory :: B.D ([Char] -> IO ())
setCurrentDirectory v12 f = (primSetCurrentDirectory v12 f)
 
doesFileExist :: B.D ([Char] -> IO Bool)
doesFileExist v13 f = (primDoesFileExist v13 f)
 
doesDirectoryExist :: B.D ([Char] -> IO Bool)
doesDirectoryExist v14 f = (primDoesDirectoryExist v14 f)
 
getPermissions :: B.D ([Char] -> IO Permissions)
getPermissions v15 f = (primGetPermissions v15 f)
 
setPermissions :: B.D ([Char] -> Permissions -> IO ())
setPermissions v16 f p = (primSetPermissions v16 f p)
 
getModificationTime :: B.D ([Char] -> IO ClockTime)
getModificationTime v17 f = (primGetModificationTime v17 f)