{-# OPTIONS -cpp -fno-cse -Onot #-}
{- a reimplimentation of the IO type and primitives-}

module IOPrims_B
                 ( IOPrims_B.IO (..)
                 , IOError
                 , runIO 
                 , unIO
                 , tryIO
                 , threadIO 
                 , IOPrims_B.getChar 
                 , IOPrims_B.putChar 
                 , IOPrims_B.getLine
                 , IOPrims_B.getContents
                 , IOPrims_B.putStr
                 , IOPrims_B.readFile
                 , IOPrims_B.writeFile
                 , IOPrims_B.appendFile
                 , IOPrims_B.getCPUTime
                 , IOPrims_B.openFile
                 , IOPrims_B.hClose
                 , IOPrims_B.hFileSize
                 , IOPrims_B.hIsEOF
                 , IOPrims_B.hSetBuffering
                 , IOPrims_B.hGetBuffering
                 , IOPrims_B.hFlush
                 , IOPrims_B.hGetPosn
                 , IOPrims_B.hSetPosn
                 , IOPrims_B.hSeek
                 , IOPrims_B.hWaitForInput
                 , IOPrims_B.hGetChar
                 , IOPrims_B.hGetLine
                 , IOPrims_B.hLookAhead
                 , IOPrims_B.hGetContents
                 , IOPrims_B.hPutChar
                 , IOPrims_B.hPutStr
                 , IOPrims_B.hPutStrLn
                 , IOPrims_B.hIsOpen
                 , IOPrims_B.hIsClosed
                 , IOPrims_B.hIsReadable
                 , IOPrims_B.hIsWritable
                 , IOPrims_B.hIsSeekable
                 , IOPrims_B.isAlreadyExistsError
                 , IOPrims_B.isDoesNotExistError
                 , IOPrims_B.isAlreadyInUseError
                 , IOPrims_B.isFullError
                 , IOPrims_B.isEOFError
                 , IOPrims_B.isIllegalOperation
                 , IOPrims_B.isPermissionError
                 , IOPrims_B.isUserError
                 , IOPrims_B.ioError
                 , IOPrims_B.ioeGetErrorString
                 , IOPrims_B.ioeGetHandle
                 , IOPrims_B.ioeGetFileName
                 , IO.Handle
                 , IO.HandlePosn
                 , IOPrims_B.stdin
                 , IOPrims_B.stdout
                 , IOPrims_B.stderr
                 , IO.IOMode (..)
                 , IO.BufferMode (..)
                 , IO.SeekMode (..)
                 , primHandleEq
                 , primHandleShowsPrec
                 , primHandlePosnEq
                 , primHandlePosnShowsPrec
                 , primIOModeEq 
                 , primIOModeLte 
                 , primIOModeIndex 
                 , primIOModeRange
                 , primIOModeInRange 
                 , primIOModeToEnum 
                 , primIOModeFromEnum
                 , primIOModeReadsPrec
                 , primIOModeShowsPrec
                 , primSeekModeEq 
                 , primSeekModeLte 
                 , primSeekModeIndex 
                 , primSeekModeRange
                 , primSeekModeInRange 
                 , primSeekModeToEnum 
                 , primSeekModeFromEnum
                 , primSeekModeReadsPrec
                 , primSeekModeShowsPrec
                 , primBufferModeEq 
                 , primBufferModeLte 
                 , primBufferModeReadsPrec
                 , primBufferModeShowsPrec
                 ) where

import IOExts (unsafePerformIO)
import qualified Buddha as B (D, app, F, fio) 
import qualified Meta  (Exp (Eio))
import qualified CPUTime (getCPUTime)
import Prelude hiding (IOError)
import qualified Prelude (IOError)
import Ix (range, inRange, index)
import qualified Control.Exception as E (try, Exception (..), evaluate)
import qualified IO ( Handle 
                    , HandlePosn
                    , stdin 
                    , stdout
                    , stderr 
                    , HandlePosn
                    , openFile 
                    , IOMode (..)
                    , BufferMode (..)
                    , SeekMode (..)
                    , hClose 
                    , hFileSize
                    , hIsEOF
                    , hSetBuffering 
                    , hGetBuffering 
                    , hFlush 
                    , hGetPosn 
                    , hSetPosn 
                    , hSeek 
                    , IOPrims_B.hWaitForInput  -- XXX why are these qualified? looks wrong
                    , IOPrims_B.hGetChar
                    , IOPrims_B.hGetLine
                    , IOPrims_B.hLookAhead
                    , IOPrims_B.hGetContents
                    , IOPrims_B.hPutChar
                    , IOPrims_B.hPutStr
                    , IOPrims_B.hPutStrLn
                    , IOPrims_B.hIsOpen
                    , IOPrims_B.hIsClosed
                    , IOPrims_B.hIsReadable
                    , IOPrims_B.hIsWritable
                    , IOPrims_B.hIsSeekable
                    , IOPrims_B.isAlreadyExistsError
                    , IOPrims_B.isDoesNotExistError
                    , IOPrims_B.isAlreadyInUseError
                    , IOPrims_B.isFullError
                    , IOPrims_B.isEOFError
                    , IOPrims_B.isIllegalOperation
                    , IOPrims_B.isPermissionError
                    , IOPrims_B.isUserError
                    , IOPrims_B.ioeGetErrorString
                    , IOPrims_B.ioeGetHandle
                    , IOPrims_B.ioeGetFileName
                    ) 

type IOError = E.Exception

{-# NOINLINE myPerformIO #-}
myPerformIO :: s -> Prelude.IO a -> Either E.Exception (s, a)
myPerformIO state io
   = let x = unsafePerformIO (E.try io)
     in case x of
        Left e -> Left e 
        Right v -> Prelude.seq v (Right (state, v))


{-# NOINLINE tryIO #-}
{-
tryIO :: IOPrims_B.IO a -> Buddha.S (IOPrims_B.IO a)
tryIO io
   = Buddha.ret
      ( unsafePerformIO
        ( do r <- E.try (E.evaluate io)
             case r of
                Left e -> return (MkIO (Buddha.makeFT (\s -> Buddha.ret (Left e)) Meta.Eio))
                Right ok@(MkIO f) -> return ok))
-}
tryIO :: B.D (IOPrims_B.IO a -> IOPrims_B.IO a)
tryIO _parent io
   = unsafePerformIO $
        do r <- E.try (E.evaluate io)
           case r of
              Left e -> return (MkIO (B.fio (\s -> Left e)))
              Right ok@(MkIO f) -> return ok

-- newtype IO a = MkIO (Buddha.F IOState (Either E.Exception (IOState, a))) 
newtype IO a = MkIO (B.F IOState (Either E.Exception (IOState, a))) 
data IOState = IOState 

{-
runIO :: IOPrims_B.IO () -> Buddha.S (Either E.Exception ())
runIO io 
   = do theIOConstructor <- tryIO io 
        case theIOConstructor of
           MkIO m -> do res <- Buddha.app m IOState
                        case res of
                           Left e -> Buddha.ret (Left e) 
                           Right (IOState, v) -> Buddha.ret (Right ())
-}
{-
runIO :: IOPrims_B.IO t -> Buddha.S (Either E.Exception ())
runIO io 
   = do theIOConstructor <- tryIO io 
        case theIOConstructor of
           MkIO m -> do res <- Buddha.app m IOState
                        case res of
                           Left e -> Buddha.ret (Left e) 
                           Right (IOState, v) -> Buddha.ret (Right ())
-}
runIO :: B.D (IOPrims_B.IO t -> Either E.Exception ())
runIO parent io 
   = case tryIO parent io of
        MkIO m -> case B.app m IOState of
                     Left e -> Left e 
                     Right (IOState, v) -> Right ()

{-
unIO :: IOPrims_B.IO a -> IOState -> Buddha.S (Either E.Exception (IOState, a))
unIO (MkIO m) s = Buddha.app m s
-}
unIO :: IOPrims_B.IO a -> IOState -> Either E.Exception (IOState, a)
unIO (MkIO m) s = B.app m s

{-
threadIO :: Prelude.IO a -> IOPrims_B.IO a
threadIO io
   = MkIO (Buddha.makeFT (\s -> Buddha.ret (myPerformIO s io)) Meta.Eio)
-}
threadIO :: Prelude.IO a -> IOPrims_B.IO a
threadIO io = MkIO (B.fio (\s -> myPerformIO s io))

getChar :: B.D (IOPrims_B.IO Prelude.Char)
getChar _ = (threadIO Prelude.getChar) 

getLine :: B.D (IOPrims_B.IO Prelude.String)
getLine _ = (threadIO Prelude.getLine) 

putChar :: B.D (Prelude.Char -> (IOPrims_B.IO ()))
putChar _ c = (threadIO (Prelude.putChar c)) 

putStr :: B.D (Prelude.String -> (IOPrims_B.IO ()))
putStr _ s = (threadIO (Prelude.putStr s)) 

getContents :: B.D ((IOPrims_B.IO Prelude.String))
getContents _ = (threadIO Prelude.getContents) 

readFile :: B.D (FilePath -> (IOPrims_B.IO String))
readFile _ file = (threadIO (Prelude.readFile file))

writeFile :: B.D (FilePath -> String -> (IOPrims_B.IO ()))
writeFile _ file s = (threadIO (Prelude.writeFile file s))

appendFile :: B.D (FilePath -> String -> (IOPrims_B.IO ()))
appendFile _ file s = (threadIO (Prelude.appendFile file s))

getCPUTime :: B.D ((IOPrims_B.IO Integer))
getCPUTime _ = (threadIO (CPUTime.getCPUTime))

openFile :: B.D (FilePath -> IO.IOMode -> (IOPrims_B.IO IO.Handle))
openFile _ fp mode
   = (threadIO (IO.openFile fp mode))

hClose :: B.D (IO.Handle -> (IOPrims_B.IO ()))
hClose _ h = (threadIO (IO.hClose h))

hFileSize :: B.D (IO.Handle -> (IOPrims_B.IO Integer))
hFileSize _ h = (threadIO (IO.hFileSize h))

hIsEOF :: B.D (IO.Handle -> (IOPrims_B.IO Bool))
hIsEOF _ h = (threadIO (IO.hIsEOF h))

hSetBuffering :: B.D (IO.Handle  -> IO.BufferMode -> (IOPrims_B.IO ()))
hSetBuffering _ h mode = (threadIO (IO.hSetBuffering h mode))

hGetBuffering :: B.D (IO.Handle -> (IOPrims_B.IO IO.BufferMode))
hGetBuffering _ h = (threadIO (IO.hGetBuffering h))

hFlush :: B.D (IO.Handle -> (IOPrims_B.IO ()))
hFlush _ h = (threadIO (IO.hFlush h))

hGetPosn :: B.D (IO.Handle -> (IOPrims_B.IO IO.HandlePosn))
hGetPosn _ h = (threadIO (IO.hGetPosn h))

hSetPosn :: B.D (IO.HandlePosn -> (IOPrims_B.IO ()))
hSetPosn _ h = (threadIO (IO.hSetPosn h))

hSeek :: B.D (IO.Handle -> IO.SeekMode -> Integer -> (IOPrims_B.IO ()))
hSeek _ h mode i = (threadIO (IO.hSeek h mode i))

hWaitForInput :: B.D (IO.Handle -> Int -> (IOPrims_B.IO Bool))
hWaitForInput _ h i = (threadIO (IO.hWaitForInput h i))

hGetChar :: B.D (IO.Handle -> (IOPrims_B.IO Char))
hGetChar _ h = (threadIO (IO.hGetChar h))

hGetLine :: B.D (IO.Handle -> (IOPrims_B.IO String))
hGetLine _ h = (threadIO (IO.hGetLine h))

hLookAhead :: B.D (IO.Handle -> (IOPrims_B.IO Char))
hLookAhead _ h = (threadIO (IO.hLookAhead h))

hGetContents :: B.D (IO.Handle -> (IOPrims_B.IO String))
hGetContents _ h = (threadIO (IO.hGetContents h))

hPutChar :: B.D (IO.Handle -> Char -> (IOPrims_B.IO ()))
hPutChar _ h c = (threadIO (IO.hPutChar h c))

hPutStr :: B.D (IO.Handle -> String -> (IOPrims_B.IO ()))
hPutStr _ h s = (threadIO (IO.hPutStr h s))

hPutStrLn :: B.D (IO.Handle -> String -> (IOPrims_B.IO ()))
hPutStrLn _ h s = (threadIO (IO.hPutStrLn h s))

hIsOpen :: B.D (IO.Handle -> (IOPrims_B.IO Bool))
hIsOpen _ h = (threadIO (IO.hIsOpen h))

hIsClosed :: B.D (IO.Handle -> (IOPrims_B.IO Bool))
hIsClosed _ h = (threadIO (IO.hIsClosed h))

hIsReadable :: B.D (IO.Handle -> (IOPrims_B.IO Bool))
hIsReadable _ h = (threadIO (IO.hIsReadable h))

hIsWritable :: B.D (IO.Handle -> (IOPrims_B.IO Bool))
hIsWritable _ h = (threadIO (IO.hIsWritable h))

hIsSeekable :: B.D (IO.Handle -> (IOPrims_B.IO Bool))
hIsSeekable _ h = (threadIO (IO.hIsSeekable h))

isAlreadyExistsError :: B.D (IOError -> Bool)
isAlreadyExistsError _ e = (IO.isAlreadyExistsError (toIOError e))

isDoesNotExistError :: B.D (IOError -> Bool)
isDoesNotExistError _ e = (IO.isDoesNotExistError (toIOError e))

isAlreadyInUseError :: B.D (IOError -> Bool)
isAlreadyInUseError _ e = (IO.isAlreadyInUseError (toIOError e))

isFullError :: B.D (IOError -> Bool)
isFullError _ e = (IO.isFullError (toIOError e))

isEOFError :: B.D (IOError -> Bool)
isEOFError _ e = (IO.isEOFError (toIOError e))

isIllegalOperation :: B.D (IOError -> Bool)
isIllegalOperation _ e = (IO.isIllegalOperation (toIOError e))

isPermissionError :: B.D (IOError -> Bool)
isPermissionError _ e = (IO.isPermissionError (toIOError e))

isUserError :: B.D (IOError -> Bool)
isUserError _ e = (IO.isUserError (toIOError e))

ioError :: B.D (IOError -> (IOPrims_B.IO a))
ioError _ e = (threadIO (Prelude.ioError (toIOError e)))

ioeGetErrorString :: B.D (IOError -> String)
ioeGetErrorString _ e = (IO.ioeGetErrorString (toIOError e))

ioeGetHandle :: B.D (IOError -> (Maybe IO.Handle))
ioeGetHandle _ e = (IO.ioeGetHandle (toIOError e))

ioeGetFileName :: B.D (IOError -> (Maybe FilePath))
ioeGetFileName _ e = (IO.ioeGetFileName (toIOError e))

stdin :: B.D ((IO.Handle))
stdin _ = (IO.stdin)

stdout :: B.D ((IO.Handle))
stdout _ = (IO.stdout)

stderr :: B.D ((IO.Handle))
stderr _ = (IO.stderr)

primHandleEq :: B.D (IO.Handle -> IO.Handle -> Bool)
primHandleEq _ h1 h2 = (h1 == h2)

primHandleShowsPrec :: B.D (Int -> IO.Handle -> String -> String)
primHandleShowsPrec _ i h s = (showsPrec i h s)

primHandlePosnEq :: B.D (IO.HandlePosn -> IO.HandlePosn -> Bool)
primHandlePosnEq _ h1 h2 = (h1 == h2)

primHandlePosnShowsPrec :: B.D (Int -> IO.HandlePosn -> String -> String)
primHandlePosnShowsPrec _ i h s = (showsPrec i h s)

primIOModeEq :: B.D (IO.IOMode -> IO.IOMode -> Bool)
primIOModeEq _ m1 m2 = (m1 == m2)

primIOModeLte :: B.D (IO.IOMode -> IO.IOMode -> Bool)
primIOModeLte _ m1 m2 = (m1 <= m2)

primIOModeRange :: B.D ((IO.IOMode, IO.IOMode) -> [IO.IOMode])
primIOModeRange _ ts = (range ts)

primIOModeIndex  :: B.D ((IO.IOMode,IO.IOMode) -> IO.IOMode -> Int)
primIOModeIndex _ ts t = (index ts t)

primIOModeInRange   :: B.D ((IO.IOMode,IO.IOMode) -> IO.IOMode -> Bool)
primIOModeInRange _ ts t = (inRange ts t)

primIOModeFromEnum :: B.D (IO.IOMode -> Int)
primIOModeFromEnum _ t = (fromEnum t)

primIOModeToEnum :: B.D (Int -> IO.IOMode)
primIOModeToEnum _ i = (toEnum i)

primIOModeShowsPrec :: B.D (Int -> IO.IOMode -> String -> String)
primIOModeShowsPrec _ i m s = (showsPrec i m s)

primIOModeReadsPrec :: B.D (Int -> String -> [(IO.IOMode, String)])
primIOModeReadsPrec _ i s = (readsPrec i s)

primSeekModeEq :: B.D (IO.SeekMode -> IO.SeekMode -> Bool)
primSeekModeEq _ m1 m2 = (m1 == m2)

primSeekModeLte :: B.D (IO.SeekMode -> IO.SeekMode -> Bool)
primSeekModeLte _ m1 m2 = (m1 <= m2)

primSeekModeRange :: B.D ((IO.SeekMode, IO.SeekMode) -> [IO.SeekMode])
primSeekModeRange _ ts = (range ts)

primSeekModeIndex  :: B.D ((IO.SeekMode,IO.SeekMode) -> IO.SeekMode -> Int)
primSeekModeIndex _ ts t = (index ts t)

primSeekModeInRange   :: B.D ((IO.SeekMode,IO.SeekMode) -> IO.SeekMode -> Bool)
primSeekModeInRange _ ts t = (inRange ts t)

primSeekModeFromEnum :: B.D (IO.SeekMode -> Int)
primSeekModeFromEnum _ t = (fromEnum t)

primSeekModeToEnum :: B.D (Int -> IO.SeekMode)
primSeekModeToEnum _ i = (toEnum i)

primSeekModeShowsPrec :: B.D (Int -> IO.SeekMode -> String -> String)
primSeekModeShowsPrec _ i m s = (showsPrec i m s)

primSeekModeReadsPrec :: B.D (Int -> String -> [(IO.SeekMode, String)])
primSeekModeReadsPrec _ i s = (readsPrec i s)

primBufferModeEq :: B.D (IO.BufferMode -> IO.BufferMode -> Bool)
primBufferModeEq _ m1 m2 = (m1 == m2)

primBufferModeLte :: B.D (IO.BufferMode -> IO.BufferMode -> Bool)
primBufferModeLte _ m1 m2 = (m1 <= m2)

primBufferModeShowsPrec :: B.D (Int -> IO.BufferMode -> String -> String)
primBufferModeShowsPrec _ i m s = (showsPrec i m s)

primBufferModeReadsPrec :: B.D (Int -> String -> [(IO.BufferMode, String)])
primBufferModeReadsPrec _ i s = (readsPrec i s)

toIOError :: IOPrims_B.IOError -> Prelude.IOError
#if __GLASGOW_HASKELL__ < 600
toIOError e = e
#endif

#if __GLASGOW_HASKELL__ >= 600
toIOError (E.IOException ioError) = ioError
#endif 
