module IO_B
       (Handle, HandlePosn,
	IOMode(ReadMode, WriteMode, AppendMode, ReadWriteMode),
	BufferMode(NoBuffering, LineBuffering, BlockBuffering),
	SeekMode(AbsoluteSeek, RelativeSeek, SeekFromEnd), stdin, stdout,
	stderr, openFile, hClose, hFileSize, hIsEOF, isEOF, hSetBuffering,
	hGetBuffering, hFlush, hGetPosn, hSetPosn, hSeek, hWaitForInput,
	hReady, hGetChar, hGetLine, hLookAhead, hGetContents, hPutChar,
	hPutStr, hPutStrLn, hPrint, hIsOpen, hIsClosed, hIsReadable,
	hIsWritable, hIsSeekable, isAlreadyExistsError,
	isDoesNotExistError, isAlreadyInUseError, isFullError, isEOFError,
	isIllegalOperation, isPermissionError, isUserError,
	ioeGetErrorString, ioeGetHandle, ioeGetFileName, try, bracket,
	bracket_, IO, FilePath, IOError, ioError, userError, catch,
	interact, putChar, putStr, putStrLn, print, getChar, getLine,
	getContents, readFile, writeFile, appendFile, readIO, readLn)
       where
import qualified Buddha as B
import Prelude_B
import IOPrims_B
import Ix_B (Ix, range, inRange, index)
v0 = B.ps "IO"
 
instance Eq Handle where
   (v6 == h1) h2 = (primHandleEq v6 h1 h2)
 
instance Eq HandlePosn where
   (v7 == h1) h2 = (primHandlePosnEq v7 h1 h2)
 
instance Show Handle where
   showsPrec v8 i e s = (primHandleShowsPrec v8 i e s)
 
instance Show HandlePosn where
   showsPrec v9 i e s = (primHandlePosnShowsPrec v9 i e s)
 
instance Eq IOMode where
   (v10 == m1) m2 = (primIOModeEq v10 m1 m2)
 
instance Ord IOMode where
   (v11 <= m1) m2 = (primIOModeLte v11 m1 m2)
 
instance Enum IOMode where
   toEnum v12 i = (primIOModeToEnum v12 i)
   fromEnum v13 i = (primIOModeFromEnum v13 i)
 
instance Ix IOMode where
   range v14 ms = (primIOModeRange v14 ms)
   inRange v15 ms m = (primIOModeInRange v15 ms m)
   index v16 ms m = (primIOModeIndex v16 ms m)
 
instance Read IOMode where
   readsPrec v17 x y = (primIOModeReadsPrec v17 x y)
 
instance Show IOMode where
   showsPrec v19 x y v18 = (primIOModeShowsPrec v19 x y v18)
 
instance Eq SeekMode where
   (v20 == m1) m2 = (primSeekModeEq v20 m1 m2)
 
instance Ord SeekMode where
   (v21 <= m1) m2 = (primSeekModeLte v21 m1 m2)
 
instance Enum SeekMode where
   toEnum v22 i = (primSeekModeToEnum v22 i)
   fromEnum v23 i = (primSeekModeFromEnum v23 i)
 
instance Ix SeekMode where
   range v24 ms = (primSeekModeRange v24 ms)
   inRange v25 ms m = (primSeekModeInRange v25 ms m)
   index v26 ms m = (primSeekModeIndex v26 ms m)
 
instance Read SeekMode where
   readsPrec v27 x y = (primSeekModeReadsPrec v27 x y)
 
instance Show SeekMode where
   showsPrec v29 x y v28 = (primSeekModeShowsPrec v29 x y v28)
 
instance Eq BufferMode where
   (v30 == m1) m2 = (primBufferModeEq v30 m1 m2)
 
instance Ord BufferMode where
   (v31 <= m1) m2 = (primBufferModeLte v31 m1 m2)
 
instance Read BufferMode where
   readsPrec v32 x y = (primBufferModeReadsPrec v32 x y)
 
instance Show BufferMode where
   showsPrec v34 x y v33 = (primBufferModeShowsPrec v34 x y v33)
 
isEOF :: B.D (IO Bool)
isEOF = \ v35 -> (hIsEOF v35 (stdin v35))
 
hReady :: B.D (Handle -> IO Bool)
hReady v36 h = (hWaitForInput v36 h 0)
 
hPrint :: (Show a) => B.D (Handle -> a -> IO ())
hPrint v37 h x
  = (($) v37 ((B.fu1 (hPutStrLn v37 h))) ((show v37 x)))
 
try :: B.D (IO a -> IO (Either IOError a))
try v38 f
  = (catch v38
       (((>>=) v38 f ((B.fu1 (\ r -> (return v38 (Right r)))))))
       ((B.fu1 ((.) v38 (B.fu1 (return v38)) (B.fu1 Left)))))
 
bracket :: B.D (IO a -> B.F a (IO b) -> B.F a (IO c) -> IO c)
bracket v39 before after m
  = ((>>=) v39 before
       ((B.fu1
	   (\ x ->
	      ((>>=) v39 ((try v39 ((B.app m x))))
		 ((B.fu1
		     (\ rs ->
			((>>) v39 ((B.app after x))
			   (case rs of
			       Right r -> (return v39 r)
			       Left e -> (ioError v39 e)))))))))))
 
bracket_ :: B.D (IO a -> B.F a (IO b) -> IO c -> IO c)
bracket_ v40 before after m
  = ((>>=) v40 before
       ((B.fu1
	   (\ x ->
	      ((>>=) v40 ((try v40 m))
		 ((B.fu1
		     (\ rs ->
			((>>) v40 ((B.app after x))
			   (case rs of
			       Right r -> (return v40 r)
			       Left e -> (ioError v40 e)))))))))))