module Ix_B (Ix(range, index, inRange, rangeSize)) where
import qualified Buddha as B
import Prelude_B
v0 = B.ps "Ix"
 
class (Ord a) => Ix a where
    
   range :: B.D ((a, a) -> [a])
    
   index :: B.D ((a, a) -> a -> Int)
    
   inRange :: B.D ((a, a) -> a -> Bool)
    
   rangeSize :: B.D ((a, a) -> Int)
   rangeSize v29 v1
     = case v1 of
	  b@(l, h) -> case (null v29 ((range v29 b))) of
			 True -> 0
			 False -> case (otherwise v29) of
				     True -> ((+) v29 ((index v29 b h)) 1)
 
instance Ix Char where
   range v30 v2
     = case v2 of
	  (m, n) -> (Prelude_B.enumFromTo v30 m n)
   index v31 v3 ci
     = case v3 of
	  b@(c, c') -> case (inRange v31 b ci) of
			  True -> ((-) v31 ((fromEnum v31 ci)) ((fromEnum v31 c)))
			  False -> case (otherwise v31) of
				      True -> (error v31 "Ix.index: Index out of range.")
   inRange v32 v4 i
     = case v4 of
	  (c, c') -> ((&&) v32 (((<=) v32 c i)) (((<=) v32 i c')))
 
instance Ix Int where
   range v33 v5
     = case v5 of
	  (m, n) -> (Prelude_B.enumFromTo v33 m n)
   index v34 v6 i
     = case v6 of
	  b@(m, n) -> case (inRange v34 b i) of
			 True -> ((-) v34 i m)
			 False -> case (otherwise v34) of
				     True -> (error v34 "Ix.index: Index out of range.")
   inRange v35 v7 i
     = case v7 of
	  (m, n) -> ((&&) v35 (((<=) v35 m i)) (((<=) v35 i n)))
 
instance Ix Integer where
   range v36 v8
     = case v8 of
	  (m, n) -> (Prelude_B.enumFromTo v36 m n)
   index v37 v9 i
     = case v9 of
	  b@(m, n) -> case (inRange v37 b i) of
			 True -> (fromInteger_bUdDhA v37 (((-) v37 i m)))
			 False -> case (otherwise v37) of
				     True -> (error v37 "Ix.index: Index out of range.")
   inRange v38 v10 i
     = case v10 of
	  (m, n) -> ((&&) v38 (((<=) v38 m i)) (((<=) v38 i n)))
 
instance (Ix a, Ix b) => Ix (a, b) where
   range v39 v13
     = case v13 of
	  ((l, l'), (u, u')) -> ((>>=) v39 ((range v39 (l, u)))
				   ((B.fu1
				       (\ i ->
					  ((>>=) v39 ((range v39 (l', u')))
					     ((B.fu1 (\ i' -> (Prelude_B.return v39 (i, i'))))))))))
   index v40 v15 v14
     = case (v15, v14) of
	  (((l, l'), (u, u')), (i, i')) -> ((+) v40
					      (((*) v40 ((index v40 (l, u) i))
						  ((rangeSize v40 (l', u')))))
					      ((index v40 (l', u') i')))
   inRange v41 v17 v16
     = case (v17, v16) of
	  (((l, l'), (u, u')), (i, i')) -> ((&&) v41 ((inRange v41 (l, u) i))
					      ((inRange v41 (l', u') i')))
 
instance Ix Bool where
   range v42 v18
     = case v18 of
	  (m, n) -> (Prelude_B.enumFromTo v42 m n)
   index v43 v19 ti
     = case v19 of
	  b@(t, t') -> case (inRange v43 b ti) of
			  True -> ((-) v43 ((fromEnum v43 ti)) ((fromEnum v43 t)))
			  False -> case (otherwise v43) of
				      True -> (error v43 "Ix.index: Index out of range.")
   inRange v44 v20 i
     = case v20 of
	  (t, t') -> ((&&) v44 (((<=) v44 t i)) (((<=) v44 i t')))
 
instance Ix Ordering where
   range v45 v21
     = case v21 of
	  (m, n) -> (Prelude_B.enumFromTo v45 m n)
   index v46 v22 ti
     = case v22 of
	  b@(t, t') -> case (inRange v46 b ti) of
			  True -> ((-) v46 ((fromEnum v46 ti)) ((fromEnum v46 t)))
			  False -> case (otherwise v46) of
				      True -> (error v46 "Ix.index: Index out of range.")
   inRange v47 v23 i
     = case v23 of
	  (t, t') -> ((&&) v47 (((<=) v47 t i)) (((<=) v47 i t')))
 
instance Ix () where
   range v48 v24
     = case v24 of
	  ((), ()) -> [()]
   index v49 v26 v25
     = case (v26, v25) of
	  (((), ()), ()) -> 0
   inRange v50 v28 v27
     = case (v28, v27) of
	  (((), ()), ()) -> True