module List_B
       (elemIndex, elemIndices, find, findIndex, findIndices, nub, nubBy,
	delete, deleteBy, (\\), deleteFirstsBy, union, unionBy, intersect,
	intersectBy, intersperse, transpose, partition, group, groupBy,
	inits, tails, isPrefixOf, isSuffixOf, mapAccumL, mapAccumR, sort,
	sortBy, insert, insertBy, maximumBy, minimumBy, genericLength,
	genericTake, genericDrop, genericSplitAt, genericIndex,
	genericReplicate, zip4, zip5, zip6, zip7, zipWith4, zipWith5,
	zipWith6, zipWith7, unzip4, unzip5, unzip6, unzip7, unfoldr, map,
	(++), concat, filter, head, last, tail, init, null, length, (!!),
	foldl, foldl1, scanl, scanl1, foldr, foldr1, scanr, scanr1,
	iterate, repeat, replicate, cycle, take, drop, splitAt, takeWhile,
	dropWhile, span, break, lines, words, unlines, unwords, reverse,
	and, or, any, all, elem, notElem, lookup, sum, product, maximum,
	minimum, concatMap, zip, zip3, zipWith, zipWith3, unzip, unzip3)
       where
import qualified Buddha as B
import qualified Prelude_B
import Prelude_B (fromInteger, fromRational)
import Prelude_B
import Maybe_B (listToMaybe)
v0 = B.ps "List"
 
infix 5 \\
 
elemIndex :: (Eq a) => B.D (a -> [a] -> Maybe Int)
elemIndex v83 x v82 = (findIndex v83 ((B.fu1 ((==) v83 x))) v82)
 
elemIndices :: (Eq a) => B.D (a -> [a] -> [Int])
elemIndices v85 x v84
  = (findIndices v85 ((B.fu1 ((==) v85 x))) v84)
 
find :: B.D (B.F a Bool -> [a] -> Maybe a)
find v87 p v86
  = ((.) v87 (B.fu1 (listToMaybe v87)) ((B.fu1 (filter v87 p))) v86)
 
findIndex :: B.D (B.F a Bool -> [a] -> Maybe Int)
findIndex v89 p v88
  = ((.) v89 (B.fu1 (listToMaybe v89)) ((B.fu1 (findIndices v89 p)))
       v88)
 
findIndices :: B.D (B.F a Bool -> [a] -> [Int])
findIndices v90 p xs
  = ((>>=) v90 ((zip v90 xs (Prelude_B.enumFrom v90 0)))
       ((B.fu1
	   (\ v3 ->
	      case v3 of
		 (x, i) -> ((>>) v90
			      (case (B.app p x) of
				  True -> [()]
				  False -> [])
			      ((Prelude_B.return v90 i)))
		 _ -> (Prelude_B.fail v90
			 "pattern match error: List.hs (49,40)")))))
 
nub :: (Eq a) => B.D ([a] -> [a])
nub v92 v91 = (nubBy v92 (B.fu2 ((==) v92)) v91)
 
nubBy :: B.D (B.F a (B.F a Bool) -> [a] -> [a])
nubBy v93 v4 v5
  = case (v4, v5) of
       (eq, []) -> []
       (eq, (x : xs)) -> (:) x
			   ((nubBy v93 eq
			       ((filter v93 ((B.fu1 (\ y -> (not v93 ((B.app (B.app eq x) y))))))
				   xs))))
 
delete :: (Eq a) => B.D (a -> [a] -> [a])
delete v96 v94 v95 = (deleteBy v96 (B.fu2 ((==) v96)) v94 v95)
 
deleteBy :: B.D (B.F a (B.F a Bool) -> a -> [a] -> [a])
deleteBy v97 v6 v7 v8
  = case (v6, v7, v8) of
       (eq, x, []) -> []
       (eq, x, (y : ys)) -> case (B.app (B.app eq x) y) of
			       True -> ys
			       False -> (:) y ((deleteBy v97 eq x ys))
 
(\\) :: (Eq a) => B.D ([a] -> [a] -> [a])
(v100 \\ v98) v99
  = (foldl v100 ((B.fu2 (flip v100 (B.fu2 (delete v100))))) v98 v99)
 
deleteFirstsBy :: B.D (B.F a (B.F a Bool) -> [a] -> [a] -> [a])
deleteFirstsBy v103 eq v101 v102
  = (foldl v103 ((B.fu2 (flip v103 ((B.fu2 (deleteBy v103 eq))))))
       v101
       v102)
 
union :: (Eq a) => B.D ([a] -> [a] -> [a])
union v106 v104 v105 = (unionBy v106 (B.fu2 ((==) v106)) v104 v105)
 
unionBy :: B.D (B.F a (B.F a Bool) -> [a] -> [a] -> [a])
unionBy v107 eq xs ys
  = ((++) v107 xs ((deleteFirstsBy v107 eq ((nubBy v107 eq ys)) xs)))
 
intersect :: (Eq a) => B.D ([a] -> [a] -> [a])
intersect v110 v108 v109
  = (intersectBy v110 (B.fu2 ((==) v110)) v108 v109)
 
intersectBy :: B.D (B.F a (B.F a Bool) -> [a] -> [a] -> [a])
intersectBy v111 eq xs ys
  = ((>>=) v111 xs
       ((B.fu1
	   (\ x ->
	      ((>>) v111
		 (case (any v111 ((B.app eq x)) ys) of
		     True -> [()]
		     False -> [])
		 ((Prelude_B.return v111 x)))))))
 
intersperse :: B.D (a -> [a] -> [a])
intersperse v112 v10 v11
  = case (v10, v11) of
       (sep, []) -> []
       (sep, [x]) -> [x]
       (sep, (x : xs)) -> (:) x ((:) sep ((intersperse v112 sep xs)))
 
transpose :: B.D ([[a]] -> [[a]])
transpose v113 v12
  = case v12 of
       [] -> []
       ([] : xss) -> (transpose v113 xss)
       ((x : xs) : xss) -> (:)
			     ((:) x
				(((>>=) v113 xss
				    ((B.fu1
					(\ v13 ->
					   case v13 of
					      (h : t) -> (Prelude_B.return v113 h)
					      _ -> (Prelude_B.fail v113
						      "pattern match error: List.hs (96,44)")))))))
			     ((transpose v113
				 ((:) xs
				    (((>>=) v113 xss
					((B.fu1
					    (\ v14 ->
					       case v14 of
						  (h : t) -> (Prelude_B.return v113 t)
						  _ -> (Prelude_B.fail v113
							  "pattern match error: List.hs (97,55)")))))))))
 
partition :: B.D (B.F a Bool -> [a] -> ([a], [a]))
partition v114 p xs
  = ((filter v114 p xs),
     (filter v114 ((B.fu1 ((.) v114 (B.fu1 (not v114)) p))) xs))
 
group :: (Eq a) => B.D ([a] -> [[a]])
group v116 v115 = (groupBy v116 (B.fu2 ((==) v116)) v115)
 
groupBy :: B.D (B.F a (B.F a Bool) -> [a] -> [[a]])
groupBy v117 v15 v16
  = case (v15, v16) of
       (eq, []) -> []
       (eq, (x : xs)) -> let v119
			       = \ v118 -> (span v118 ((B.app eq x)) xs)
			     ys = \ v120 -> (\ (ys, zs) -> ys) (v119 v120)
			     zs = \ v121 -> (\ (ys, zs) -> zs) (v119 v121)
			   in (:) ((:) x (ys v117)) ((groupBy v117 eq (zs v117)))
 
inits :: B.D ([a] -> [[a]])
inits v122 v17
  = case v17 of
       [] -> [[]]
       (x : xs) -> ((++) v122 [[]]
		      ((map v122 ((B.fu1 ((:) x))) ((inits v122 xs)))))
 
tails :: B.D ([a] -> [[a]])
tails v123 v19
  = case v19 of
       [] -> [[]]
       xxs@(_ : xs) -> (:) xxs ((tails v123 xs))
 
isPrefixOf :: (Eq a) => B.D ([a] -> [a] -> Bool)
isPrefixOf v124 v20 v21
  = case (v20, v21) of
       ([], _) -> True
       (_, []) -> False
       ((x : xs), (y : ys)) -> ((&&) v124 (((==) v124 x y))
				  ((isPrefixOf v124 xs ys)))
 
isSuffixOf :: (Eq a) => B.D ([a] -> [a] -> Bool)
isSuffixOf v125 x y
  = (isPrefixOf v125 ((reverse v125 x)) ((reverse v125 y)))
 
mapAccumL :: B.D (B.F a (B.F b (a, c)) -> a -> [b] -> (a, [c]))
mapAccumL v126 v22 v23 v24
  = case (v22, v23, v24) of
       (f, s, []) -> (s, [])
       (f, s, (x : xs)) -> let v128 = \ v127 -> (B.app (B.app f s) x)
			       s' = \ v129 -> (\ (s', y) -> s') (v128 v129)
			       y = \ v130 -> (\ (s', y) -> y) (v128 v130)
			       v132 = \ v131 -> (mapAccumL v131 f (s' v131) xs)
			       s'' = \ v133 -> (\ (s'', ys) -> s'') (v132 v133)
			       ys = \ v134 -> (\ (s'', ys) -> ys) (v132 v134)
			     in ((s'' v126), (:) (y v126) (ys v126))
 
mapAccumR :: B.D (B.F a (B.F b (a, c)) -> a -> [b] -> (a, [c]))
mapAccumR v135 v25 v26 v27
  = case (v25, v26, v27) of
       (f, s, []) -> (s, [])
       (f, s, (x : xs)) -> let v137
				 = \ v136 -> (B.app (B.app f (s' v136)) x)
			       s'' = \ v138 -> (\ (s'', y) -> s'') (v137 v138)
			       y = \ v139 -> (\ (s'', y) -> y) (v137 v139)
			       v141 = \ v140 -> (mapAccumR v140 f s xs)
			       s' = \ v142 -> (\ (s', ys) -> s') (v141 v142)
			       ys = \ v143 -> (\ (s', ys) -> ys) (v141 v143)
			     in ((s'' v135), (:) (y v135) (ys v135))
 
unfoldr :: B.D (B.F b (Maybe (a, b)) -> b -> [a])
unfoldr v144 f b
  = case (B.app f b) of
       Nothing -> []
       Just (a, b) -> (:) a ((unfoldr v144 f b))
 
sort :: (Ord a) => B.D ([a] -> [a])
sort v146 v145 = (sortBy v146 (B.fu2 (compare v146)) v145)
 
sortBy :: B.D (B.F a (B.F a Ordering) -> [a] -> [a])
sortBy v148 cmp v147
  = (foldr v148 ((B.fu2 (insertBy v148 cmp))) [] v147)
 
insert :: (Ord a) => B.D (a -> [a] -> [a])
insert v151 v149 v150
  = (insertBy v151 (B.fu2 (compare v151)) v149 v150)
 
insertBy :: B.D (B.F a (B.F a Ordering) -> a -> [a] -> [a])
insertBy v152 v28 v29 v30
  = case (v28, v29, v30) of
       (cmp, x, []) -> [x]
       (cmp, x, ys@(y : ys')) -> case (B.app (B.app cmp x) y) of
				    GT -> (:) y ((insertBy v152 cmp x ys'))
				    _ -> (:) x ys
 
maximumBy :: B.D (B.F a (B.F a Ordering) -> [a] -> a)
maximumBy v153 v31 v32
  = case (v31, v32) of
       (cmp, []) -> (error v153 "List.maximumBy: empty list")
       (cmp, xs) -> let max v154 x y
			  = case (B.app (B.app cmp x) y) of
			       GT -> x
			       _ -> y
		      in (foldl1 v153 (B.fu2 (max v153)) xs)
 
minimumBy :: B.D (B.F a (B.F a Ordering) -> [a] -> a)
minimumBy v155 v33 v34
  = case (v33, v34) of
       (cmp, []) -> (error v155 "List.minimumBy: empty list")
       (cmp, xs) -> let min v156 x y
			  = case (B.app (B.app cmp x) y) of
			       GT -> y
			       _ -> x
		      in (foldl1 v155 (B.fu2 (min v155)) xs)
 
genericLength :: (Integral a) => B.D ([b] -> a)
genericLength v157 v35
  = case v35 of
       [] -> 0
       (x : xs) -> ((+) v157 1 ((genericLength v157 xs)))
 
genericTake :: (Integral a) => B.D (a -> [b] -> [b])
genericTake v158 v36 v37
  = let v38 = \ v160 -> (v36, v37) in
      case (v38 v158) of
	 (n, []) -> []
	 _ -> let v39
		    = \ v162 ->
			let v40 = \ v164 -> (Prelude_B.error v164 "No Match") in
			  case (v38 v162) of
			     (n, (x : xs)) -> case ((>) v162 n 0) of
						 True -> (:) x
							   ((genericTake v162 (((-) v162 n 1)) xs))
						 False -> case (otherwise v162) of
							     True -> (error v162
									"List.genericTake: negative argument")
							     False -> (v40 v162)
			     _ -> (v40 v162)
		in
		case (v38 v158) of
		   (n, _) -> case ((==) v158 n 0) of
				True -> []
				False -> (v39 v158)
		   _ -> (v39 v158)
 
genericDrop :: (Integral a) => B.D (a -> [b] -> [b])
genericDrop v165 v41 v42
  = let v43 = \ v167 -> (v41, v42) in
      case (v43 v165) of
	 (_, []) -> []
	 _ -> let v44
		    = \ v169 ->
			let v45 = \ v171 -> (Prelude_B.error v171 "No Match") in
			  case (v43 v169) of
			     (n, (_ : xs)) -> case ((>) v169 n 0) of
						 True -> (genericDrop v169 (((-) v169 n 1)) xs)
						 False -> case (otherwise v169) of
							     True -> (error v169
									"List.genericDrop: negative argument")
							     False -> (v45 v169)
			     _ -> (v45 v169)
		in
		case (v43 v165) of
		   (n, xs) -> case ((==) v165 n 0) of
				 True -> xs
				 False -> (v44 v165)
		   _ -> (v44 v165)
 
genericSplitAt :: (Integral a) => B.D (a -> [b] -> ([b], [b]))
genericSplitAt v172 v46 v47
  = let v48 = \ v174 -> (v46, v47) in
      case (v48 v172) of
	 (_, []) -> ([], [])
	 _ -> let v49
		    = \ v176 ->
			let v50 = \ v178 -> (Prelude_B.error v178 "No Match") in
			  case (v48 v176) of
			     (n, (x : xs)) -> let v180
						    = \ v179 ->
							(genericSplitAt v179 (((-) v179 n 1)) xs)
						  xs' = \ v181 -> (\ (xs', xs'') -> xs') (v180 v181)
						  xs''
						    = \ v182 -> (\ (xs', xs'') -> xs'') (v180 v182)
						in
						case ((>) v176 n 0) of
						   True -> ((:) x (xs' v176), (xs'' v176))
						   False -> case (otherwise v176) of
							       True -> (error v176
									  "List.genericSplitAt: negative argument")
							       False -> (v50 v176)
			     _ -> (v50 v176)
		in
		case (v48 v172) of
		   (n, xs) -> case ((==) v172 n 0) of
				 True -> ([], xs)
				 False -> (v49 v172)
		   _ -> (v49 v172)
 
genericIndex :: (Integral a) => B.D ([b] -> a -> b)
genericIndex v183 v51 v52
  = let v53 = \ v185 -> (v51, v52) in
      let v54
	    = \ v187 ->
		let v55
		      = \ v189 ->
			  case (v53 v189) of
			     (_, _) -> (error v189 "List.genericIndex: index too large")
			     _ -> (Prelude_B.error v189 "No Match")
		  in
		  case (v53 v187) of
		     ((_ : xs), n) -> case ((>) v187 n 0) of
					 True -> (genericIndex v187 xs (((-) v187 n 1)))
					 False -> case (otherwise v187) of
						     True -> (error v187
								"List.genericIndex: negative argument")
						     False -> (v55 v187)
		     _ -> (v55 v187)
	in
	case (v53 v183) of
	   ((x : _), n) -> case ((==) v183 n 0) of
			      True -> x
			      False -> (v54 v183)
	   _ -> (v54 v183)
 
genericReplicate :: (Integral a) => B.D (a -> b -> [b])
genericReplicate v190 n x = (genericTake v190 n ((repeat v190 x)))
 
zip4 :: B.D ([a] -> [b] -> [c] -> [d] -> [(a, b, c, d)])
zip4 v195 v191 v192 v193 v194
  = (zipWith4 v195 (B.fu4 (,,,)) v191 v192 v193 v194)
 
zip5 :: B.D ([a] -> [b] -> [c] -> [d] -> [e] -> [(a, b, c, d, e)])
zip5 v201 v196 v197 v198 v199 v200
  = (zipWith5 v201 (B.fu5 (,,,,)) v196 v197 v198 v199 v200)
 
zip6 ::
       B.D
	 ([a] -> [b] -> [c] -> [d] -> [e] -> [f] -> [(a, b, c, d, e, f)])
zip6 v208 v202 v203 v204 v205 v206 v207
  = (zipWith6 v208 (B.fu6 (,,,,,)) v202 v203 v204 v205 v206 v207)
 
zip7 ::
       B.D
	 ([a] ->
	    [b] -> [c] -> [d] -> [e] -> [f] -> [g] -> [(a, b, c, d, e, f, g)])
zip7 v216 v209 v210 v211 v212 v213 v214 v215
  = (zipWith7 v216 (B.fu7 (,,,,,,)) v209 v210 v211 v212 v213 v214
       v215)
 
zipWith4 ::
	   B.D
	     (B.F a (B.F b (B.F c (B.F d e))) ->
		[a] -> [b] -> [c] -> [d] -> [e])
zipWith4 v217 v56 v57 v58 v59 v60
  = case (v56, v57, v58, v59, v60) of
       (z, (a : as), (b : bs), (c : cs), (d : ds)) -> (:)
							((B.app (B.app (B.app (B.app z a) b) c) d))
							((zipWith4 v217 z as bs cs ds))
       (_, _, _, _, _) -> []
 
zipWith5 ::
	   B.D
	     (B.F a (B.F b (B.F c (B.F d (B.F e f)))) ->
		[a] -> [b] -> [c] -> [d] -> [e] -> [f])
zipWith5 v218 v61 v62 v63 v64 v65 v66
  = case (v61, v62, v63, v64, v65, v66) of
       (z, (a : as), (b : bs), (c : cs), (d : ds), (e : es)) -> (:)
								  ((B.app
								      (B.app
									 (B.app
									    (B.app (B.app z a) b)
									    c)
									 d)
								      e))
								  ((zipWith5 v218 z as bs cs ds es))
       (_, _, _, _, _, _) -> []
 
zipWith6 ::
	   B.D
	     (B.F a (B.F b (B.F c (B.F d (B.F e (B.F f g))))) ->
		[a] -> [b] -> [c] -> [d] -> [e] -> [f] -> [g])
zipWith6 v219 v67 v68 v69 v70 v71 v72 v73
  = case (v67, v68, v69, v70, v71, v72, v73) of
       (z, (a : as), (b : bs), (c : cs), (d : ds), (e : es),
	(f : fs)) -> (:)
		       ((B.app (B.app (B.app (B.app (B.app (B.app z a) b) c) d) e) f))
		       ((zipWith6 v219 z as bs cs ds es fs))
       (_, _, _, _, _, _, _) -> []
 
zipWith7 ::
	   B.D
	     (B.F a (B.F b (B.F c (B.F d (B.F e (B.F f (B.F g h)))))) ->
		[a] -> [b] -> [c] -> [d] -> [e] -> [f] -> [g] -> [h])
zipWith7 v220 v74 v75 v76 v77 v78 v79 v80 v81
  = case (v74, v75, v76, v77, v78, v79, v80, v81) of
       (z, (a : as), (b : bs), (c : cs), (d : ds), (e : es), (f : fs),
	(g : gs)) -> (:)
		       ((B.app
			   (B.app (B.app (B.app (B.app (B.app (B.app z a) b) c) d) e) f)
			   g))
		       ((zipWith7 v220 z as bs cs ds es fs gs))
       (_, _, _, _, _, _, _, _) -> []
 
unzip4 :: B.D ([(a, b, c, d)] -> ([a], [b], [c], [d]))
unzip4 v222 v221
  = (foldr v222
       ((B.fu2
	   (\ v223@(a, b, c, d) v224@(~(as, bs, cs, ds)) ->
	      ((:) a as, (:) b bs, (:) c cs, (:) d ds))))
       ([], [], [], [])
       v221)
 
unzip5 :: B.D ([(a, b, c, d, e)] -> ([a], [b], [c], [d], [e]))
unzip5 v226 v225
  = (foldr v226
       ((B.fu2
	   (\ v227@(a, b, c, d, e) v228@(~(as, bs, cs, ds, es)) ->
	      ((:) a as, (:) b bs, (:) c cs, (:) d ds, (:) e es))))
       ([], [], [], [], [])
       v225)
 
unzip6 ::
	 B.D ([(a, b, c, d, e, f)] -> ([a], [b], [c], [d], [e], [f]))
unzip6 v230 v229
  = (foldr v230
       ((B.fu2
	   (\ v231@(a, b, c, d, e, f) v232@(~(as, bs, cs, ds, es, fs)) ->
	      ((:) a as, (:) b bs, (:) c cs, (:) d ds, (:) e es, (:) f fs))))
       ([], [], [], [], [], [])
       v229)
 
unzip7 ::
	 B.D
	   ([(a, b, c, d, e, f, g)] -> ([a], [b], [c], [d], [e], [f], [g]))
unzip7 v234 v233
  = (foldr v234
       ((B.fu2
	   (\ v235@(a, b, c, d, e, f, g) v236@(~(as, bs, cs, ds, es, fs, gs))
	      ->
	      ((:) a as, (:) b bs, (:) c cs, (:) d ds, (:) e es, (:) f fs,
	       (:) g gs))))
       ([], [], [], [], [], [], [])
       v233)