module LocalePrims_B    ( L.TimeLocale (TimeLocale)
                        , wDays 
                        , months 
                        , intervals
                        , amPm
                        , dateTimeFmt, dateFmt 
                        , timeFmt, time12Fmt 
                        , primTimeLocaleEq 
                        , primTimeLocaleLte
                        , primTimeLocaleShowsPrec 
                        )
                        where

import Prelude
import Buddha as B
import qualified System.Locale as L



wDays :: B.D (L.TimeLocale -> [(String, String)])
wDays _ t = L.wDays t

months :: B.D (L.TimeLocale -> [(String, String)])
months _ t = L.months t

intervals :: B.D (L.TimeLocale -> [(String, String)])
intervals _ t = L.intervals t

amPm :: B.D (L.TimeLocale -> (String, String))
amPm _ t = L.amPm t

dateTimeFmt :: B.D (L.TimeLocale -> String)
dateTimeFmt _ t = L.dateTimeFmt t

dateFmt :: B.D (L.TimeLocale -> String) 
dateFmt _ t = L.dateFmt t

timeFmt :: B.D (L.TimeLocale -> String) 
timeFmt _ t = L.timeFmt t

time12Fmt :: B.D (L.TimeLocale -> String)
time12Fmt _ t = L.time12Fmt t

primTimeLocaleEq :: B.D (L.TimeLocale -> L.TimeLocale -> Bool)
primTimeLocaleEq _ t1 t2 = (t1 == t2)

primTimeLocaleLte :: B.D (L.TimeLocale -> L.TimeLocale -> Bool)
primTimeLocaleLte _ t1 t2 = (t1 <= t2)

primTimeLocaleShowsPrec :: B.D (Int -> L.TimeLocale -> String -> String)
primTimeLocaleShowsPrec _ d t s = showsPrec d t s 
