module Locale_B
       (TimeLocale(..), wDays, months, intervals, amPm, dateTimeFmt,
	dateFmt, timeFmt, time12Fmt, defaultTimeLocale)
       where
import qualified Buddha as B
import Prelude_B
import LocalePrims_B
v0 = B.ps "Locale"
 
instance Eq TimeLocale where
   (v1 == m1) m2 = (primTimeLocaleEq v1 m1 m2)
 
instance Ord TimeLocale where
   (v2 <= m1) m2 = (primTimeLocaleLte v2 m1 m2)
 
instance Show TimeLocale where
   showsPrec v4 x y v3 = (primTimeLocaleShowsPrec v4 x y v3)
 
defaultTimeLocale :: B.D TimeLocale
defaultTimeLocale
  = \ v5 ->
      (TimeLocale
	 [("Sunday", "Sun"), ("Monday", "Mon"), ("Tuesday", "Tue"),
	  ("Wednesday", "Wed"), ("Thursday", "Thu"), ("Friday", "Fri"),
	  ("Saturday", "Sat")]
	 [("January", "Jan"), ("February", "Feb"), ("March", "Mar"),
	  ("April", "Apr"), ("May", "May"), ("June", "Jun"), ("July", "Jul"),
	  ("August", "Aug"), ("September", "Sep"), ("October", "Oct"),
	  ("November", "Nov"), ("December", "Dec")]
	 (Prelude_B.undefined v5)
	 ("AM", "PM")
	 "%a %b %e %H:%M:%S %Z %Y"
	 "%m/%d/%y"
	 "%H:%M:%S"
	 "%I:%M:%S %p")