module Monad_B
       (MonadPlus(mzero, mplus), join, guard, when, unless, ap, msum,
	filterM, mapAndUnzipM, zipWithM, zipWithM_, foldM, liftM, liftM2,
	liftM3, liftM4, liftM5, Monad((>>=), (>>), return, fail),
	Functor(fmap), mapM, mapM_, sequence, sequence_, (=<<))
       where
import qualified Buddha as B
import qualified Prelude_B
import Prelude_B (fromInteger, fromRational)
import Prelude_B
v0 = B.ps "Monad"
 
class (Monad m) => MonadPlus m where
    
   mzero :: B.D (m a)
    
   mplus :: B.D (m a -> m a -> m a)
 
instance MonadPlus Maybe where
   mzero = \ v25 -> Nothing
   mplus v26 v1 v2
     = case (v1, v2) of
	  (Nothing, ys) -> ys
	  (xs, ys) -> xs
 
instance MonadPlus [] where
   mzero = \ v27 -> []
   mplus v30 v28 v29 = ((++) v30 v28 v29)
 
msum :: (MonadPlus m) => B.D ([m a] -> m a)
msum v31 xs = (foldr v31 (B.fu2 (mplus v31)) (mzero v31) xs)
 
join :: (Monad m) => B.D (m (m a) -> m a)
join v32 x = ((>>=) v32 x (B.fu1 (id v32)))
 
when :: (Monad m) => B.D (Bool -> m () -> m ())
when v33 p s
  = case p of
       True -> s
       False -> (return v33 ())
 
unless :: (Monad m) => B.D (Bool -> m () -> m ())
unless v34 p s = (when v34 ((not v34 p)) s)
 
ap :: (Monad m) => B.D (m (B.F a b) -> m a -> m b)
ap v37 v35 v36 = (liftM2 v37 (B.fu2 (($) v37)) v35 v36)
 
guard :: (MonadPlus m) => B.D (Bool -> m ())
guard v38 p
  = case p of
       True -> (return v38 ())
       False -> (mzero v38)
 
mapAndUnzipM ::
	     (Monad m) => B.D (B.F a (m (b, c)) -> [a] -> m ([b], [c]))
mapAndUnzipM v39 f xs
  = ((>>=) v39 ((sequence v39 ((map v39 f xs))))
       ((B.fu1 ((.) v39 (B.fu1 (return v39)) (B.fu1 (unzip v39))))))
 
zipWithM ::
	 (Monad m) => B.D (B.F a (B.F b (m c)) -> [a] -> [b] -> m [c])
zipWithM v40 f xs ys = (sequence v40 ((zipWith v40 f xs ys)))
 
zipWithM_ ::
	  (Monad m) => B.D (B.F a (B.F b (m c)) -> [a] -> [b] -> m ())
zipWithM_ v41 f xs ys = (sequence_ v41 ((zipWith v41 f xs ys)))
 
foldM :: (Monad m) => B.D (B.F a (B.F b (m a)) -> a -> [b] -> m a)
foldM v42 v3 v4 v5
  = case (v3, v4, v5) of
       (f, a, []) -> (return v42 a)
       (f, a, (x : xs)) -> ((>>=) v42 ((B.app (B.app f a) x))
			      ((B.fu1 (\ y -> (foldM v42 f y xs)))))
 
filterM :: (Monad m) => B.D (B.F a (m Bool) -> [a] -> m [a])
filterM v43 v6 v7
  = case (v6, v7) of
       (p, []) -> (return v43 [])
       (p, (x : xs)) -> ((>>=) v43 ((B.app p x))
			   ((B.fu1
			       (\ b ->
				  ((>>=) v43 ((filterM v43 p xs))
				     ((B.fu1
					 (\ ys ->
					    (return v43
					       (case b of
						   True -> ((:) x ys)
						   False -> ys))))))))))
 
liftM :: (Monad m) => B.D (B.F a b -> m a -> m b)
liftM v44 f a
  = ((>>=) v44 a ((B.fu1 (\ a' -> (return v44 ((B.app f a')))))))
 
liftM2 :: (Monad m) => B.D (B.F a (B.F b c) -> m a -> m b -> m c)
liftM2 v45 f a b
  = ((>>=) v45 a
       ((B.fu1
	   (\ a' ->
	      ((>>=) v45 b
		 ((B.fu1 (\ b' -> (return v45 ((B.app (B.app f a') b')))))))))))
 
liftM3 ::
       (Monad m) =>
	 B.D (B.F a (B.F b (B.F c d)) -> m a -> m b -> m c -> m d)
liftM3 v46 f a b c
  = ((>>=) v46 a
       ((B.fu1
	   (\ a' ->
	      ((>>=) v46 b
		 ((B.fu1
		     (\ b' ->
			((>>=) v46 c
			   ((B.fu1
			       (\ c' ->
				  (return v46 ((B.app (B.app (B.app f a') b') c')))))))))))))))
 
liftM4 ::
       (Monad m) =>
	 B.D
	   (B.F a (B.F b (B.F c (B.F d e))) ->
	      m a -> m b -> m c -> m d -> m e)
liftM4 v47 f a b c d
  = ((>>=) v47 a
       ((B.fu1
	   (\ a' ->
	      ((>>=) v47 b
		 ((B.fu1
		     (\ b' ->
			((>>=) v47 c
			   ((B.fu1
			       (\ c' ->
				  ((>>=) v47 d
				     ((B.fu1
					 (\ d' ->
					    (return v47
					       ((B.app (B.app (B.app (B.app f a') b') c')
						   d')))))))))))))))))))
 
liftM5 ::
       (Monad m) =>
	 B.D
	   (B.F a (B.F b (B.F c (B.F d (B.F e f)))) ->
	      m a -> m b -> m c -> m d -> m e -> m f)
liftM5 v48 f a b c d e
  = ((>>=) v48 a
       ((B.fu1
	   (\ a' ->
	      ((>>=) v48 b
		 ((B.fu1
		     (\ b' ->
			((>>=) v48 c
			   ((B.fu1
			       (\ c' ->
				  ((>>=) v48 d
				     ((B.fu1
					 (\ d' ->
					    ((>>=) v48 e
					       ((B.fu1
						   (\ e' ->
						      (return v48
							 ((B.app
							     (B.app
								(B.app (B.app (B.app f a') b') c')
								d')
							     e')))))))))))))))))))))))