module Numeric_B
       (fromRat, showSigned, showIntAtBase, showInt, showOct, showHex,
	readSigned, readInt, readDec, readOct, readHex, floatToDigits,
	showEFloat, showFFloat, showGFloat, showFloat, readFloat,
	lexDigits)
       where
import qualified Buddha as B
import Prelude_B
import Char_B (isDigit, isOctDigit, isHexDigit, digitToInt,
	       intToDigit)
import Ratio_B ((%), numerator, denominator)
import Array_B ((!), Array, array)
v0 = B.ps "Numeric"
 
fromRat :: (RealFloat a) => B.D (Rational -> a)
fromRat v46 x
  = case ((==) v46 x 0) of
       True -> (encodeFloat v46 0 0)
       False -> case ((<) v46 x 0) of
		   True -> (Prelude_B.negate_bUdDhA v46
			      (fromRat' v46 ((Prelude_B.negate_bUdDhA v46 x))))
		   False -> (fromRat' v46 x)
 
fromRat' :: (RealFloat a) => B.D (Rational -> a)
fromRat' v62 x = (r v62)
  where
     b = \ v47 -> (floatRadix v47 (r v47))
     p = \ v48 -> (floatDigits v48 (r v48))
     v50 = \ v49 -> (floatRange v49 (r v49))
     minExp0 = \ v51 -> (\ (minExp0, _) -> minExp0) (v50 v51)
     minExp = \ v52 -> ((-) v52 (minExp0 v52) (p v52))
     xMin
       = \ v53 ->
	   (toRational v53 ((expt v53 (b v53) (((-) v53 (p v53) 1)))))
     xMax = \ v54 -> (toRational v54 ((expt v54 (b v54) (p v54))))
     p0
       = \ v55 ->
	   (max v55
	      (((-) v55
		  (((-) v55 ((integerLogBase v55 (b v55) ((numerator v55 x))))
		      ((integerLogBase v55 (b v55) ((denominator v55 x))))))
		  (p v55)))
	      (minExp v55))
     f = \ v56 ->
	   case ((<) v56 (p0 v56) 0) of
	      True -> ((%) v56 1
			 ((expt v56 (b v56) ((Prelude_B.negate_bUdDhA v56 (p0 v56))))))
	      False -> ((%) v56 ((expt v56 (b v56) (p0 v56))) 1)
     v58
       = \ v57 ->
	   (scaleRat v57 ((toRational v57 (b v57))) (minExp v57) (xMin v57)
	      (xMax v57)
	      (p0 v57)
	      (((/) v57 x (f v57))))
     x' = \ v59 -> (\ (x', p') -> x') (v58 v59)
     p' = \ v60 -> (\ (x', p') -> p') (v58 v60)
     r = \ v61 -> (encodeFloat v61 ((round v61 (x' v61))) (p' v61))
 
scaleRat ::
	   B.D
	     (Rational ->
		Int -> Rational -> Rational -> Int -> Rational -> (Rational, Int))
scaleRat v63 b minExp xMin xMax p x
  = case ((<=) v63 p minExp) of
       True -> (x, p)
       False -> case ((>=) v63 x xMax) of
		   True -> (scaleRat v63 b minExp xMin xMax (((+) v63 p 1))
			      (((/) v63 x b)))
		   False -> case ((<) v63 x xMin) of
			       True -> (scaleRat v63 b minExp xMin xMax (((-) v63 p 1))
					  (((*) v63 x b)))
			       False -> (x, p)
minExpt = \ v64 -> 0 :: Int
maxExpt = \ v65 -> 1100 :: Int
 
expt :: B.D (Integer -> Int -> Integer)
expt v66 base n
  = case
      ((&&) v66 (((==) v66 base 2))
	 (((&&) v66 (((>=) v66 n (minExpt v66)))
	     (((<=) v66 n (maxExpt v66))))))
      of
       True -> ((!) v66 (expts v66) n)
       False -> ((^) v66 base n)
 
expts :: B.D (Array Int Integer)
expts
  = \ v67 ->
      (array v67 ((minExpt v67), (maxExpt v67))
	 ((>>=) v67 ((Prelude_B.enumFromTo v67 (minExpt v67) (maxExpt v67)))
	    ((B.fu1 (\ n -> (Prelude_B.return v67 (n, ((^) v67 2 n))))))))
 
integerLogBase :: B.D (Integer -> Integer -> Int)
integerLogBase v68 b i
  = case ((<) v68 i b) of
       True -> 0
       False -> let l = \ v69 ->
			  ((*) v69 2 ((integerLogBase v69 (((*) v69 b b)) i)))
		     
		    doDiv :: B.D (Integer -> Int -> Int)
		    doDiv v70 i l
		      = case ((<) v70 i b) of
			   True -> l
			   False -> (doDiv v70 ((div v70 i b)) (((+) v70 l 1)))
		  in (doDiv v68 ((div v68 i (((^) v68 b (l v68))))) (l v68))
 
showSigned ::
	   (Real a) =>
	     B.D (B.F a (B.F [Char] [Char]) -> Int -> a -> [Char] -> [Char])
showSigned v72 showPos p x v71
  = case ((<) v72 x 0) of
       True -> (showParen v72 (((>) v72 p 6))
		  ((B.fu1
		      ((.) v72 ((B.fu1 (showChar v72 '-')))
			 ((B.app showPos ((Prelude_B.negate_bUdDhA v72 x)))))))
		  v71)
       False -> case (otherwise v72) of
		   True -> (B.app (B.app showPos x) v71)
 
showInt, showOct, showHex ::
	 (Integral a) => B.D (a -> [Char] -> [Char])
showOct v75 v73 v74
  = (showIntAtBase v75 8 (B.fu1 (intToDigit v75)) v73 v74)
showInt v78 v76 v77
  = (showIntAtBase v78 10 (B.fu1 (intToDigit v78)) v76 v77)
showHex v81 v79 v80
  = (showIntAtBase v81 16 (B.fu1 (intToDigit v81)) v79 v80)
 
showIntAtBase ::
	      (Integral a) => B.D (a -> B.F Int Char -> a -> [Char] -> [Char])
showIntAtBase v87 base intToDig n rest
  = case ((<) v87 n 0) of
       True -> (error v87
		  "Numeric.showIntAtBase: can't show negative numbers")
       False -> case ((==) v87 (n' v87) 0) of
		   True -> (rest' v87)
		   False -> case (otherwise v87) of
			       True -> (showIntAtBase v87 base intToDig (n' v87) (rest' v87))
  where
     v83 = \ v82 -> (quotRem v82 n base)
     n' = \ v84 -> (\ (n', d) -> n') (v83 v84)
     d = \ v85 -> (\ (n', d) -> d) (v83 v85)
     rest'
       = \ v86 -> (:) ((B.app intToDig ((fromIntegral v86 (d v86))))) rest
 
readSigned ::
	   (Real a) =>
	     B.D (B.F [Char] [(a, [Char])] -> [Char] -> [(a, [Char])])
readSigned v91 readPos v88
  = (readParen v91 False (B.fu1 (read' v91)) v88)
  where
     read' v89 r
       = ((++) v89 ((read'' v89 r))
	    (((>>=) v89 ((lex v89 r))
		((B.fu1
		    (\ v3 ->
		       case v3 of
			  ("-", s) -> ((>>=) v89 ((read'' v89 s))
					 ((B.fu1
					     (\ v2 ->
						case v2 of
						   (x, t) -> (Prelude_B.return v89
								((Prelude_B.negate_bUdDhA v89 x),
								 t))
						   _ -> (Prelude_B.fail v89
							   "pattern match error: Numeric.hs (118,57)")))))
			  _ -> (Prelude_B.fail v89
				  "pattern match error: Numeric.hs (117,57)")))))))
     read'' v90 r
       = ((>>=) v90 ((lex v90 r))
	    ((B.fu1
		(\ v5 ->
		   case v5 of
		      (str, s) -> ((>>=) v90 ((B.app readPos str))
				     ((B.fu1
					 (\ v4 ->
					    case v4 of
					       (n, "") -> (Prelude_B.return v90 (n, s))
					       _ -> (Prelude_B.fail v90
						       "pattern match error: Numeric.hs (120,57)")))))
		      _ -> (Prelude_B.fail v90
			      "pattern match error: Numeric.hs (119,57)")))))
 
readInt ::
	(Integral a) =>
	  B.D (a -> B.F Char Bool -> B.F Char Int -> [Char] -> [(a, [Char])])
readInt v92 radix isDig digToInt s
  = ((>>=) v92 ((nonnull v92 isDig s))
       ((B.fu1
	   (\ v6 ->
	      case v6 of
		 (ds, r) -> (Prelude_B.return v92
			       ((foldl1 v92 ((B.fu2 (\ n d -> ((+) v92 (((*) v92 n radix)) d))))
				   ((map v92 ((B.fu1 ((.) v92 (B.fu1 (fromIntegral v92)) digToInt)))
				       ds))),
				r))
		 _ -> (Prelude_B.fail v92
			 "pattern match error: Numeric.hs (129,20)")))))
 
readDec, readOct, readHex ::
	 (Integral a) => B.D ([Char] -> [(a, [Char])])
readDec v94 v93
  = (readInt v94 10 (B.fu1 (isDigit v94)) (B.fu1 (digitToInt v94))
       v93)
readOct v96 v95
  = (readInt v96 8 (B.fu1 (isOctDigit v96)) (B.fu1 (digitToInt v96))
       v95)
readHex v98 v97
  = (readInt v98 16 (B.fu1 (isHexDigit v98)) (B.fu1 (digitToInt v98))
       v97)
 
showEFloat ::
	   (RealFloat a) => B.D (Maybe Int -> a -> [Char] -> [Char])
 
showFFloat ::
	   (RealFloat a) => B.D (Maybe Int -> a -> [Char] -> [Char])
 
showGFloat ::
	   (RealFloat a) => B.D (Maybe Int -> a -> [Char] -> [Char])
 
showFloat :: (RealFloat a) => B.D (a -> [Char] -> [Char])
showEFloat v100 d x v99
  = (showString v100 ((formatRealFloat v100 FFExponent d x)) v99)
showFFloat v102 d x v101
  = (showString v102 ((formatRealFloat v102 FFFixed d x)) v101)
showGFloat v104 d x v103
  = (showString v104 ((formatRealFloat v104 FFGeneric d x)) v103)
showFloat v107 v105 v106 = (showGFloat v107 Nothing v105 v106)
 
data FFFormat = FFExponent
	      | FFFixed
	      | FFGeneric
 
formatRealFloat ::
		(RealFloat a) => B.D (FFFormat -> Maybe Int -> a -> [Char])
formatRealFloat v146 fmt decs x = (s v146)
  where
     base = \ v108 -> 10
     s = \ v109 ->
	   case (isNaN v109 x) of
	      True -> "NaN"
	      False -> case (isInfinite v109 x) of
			  True -> case ((<) v109 x 0) of
				     True -> "-Infinity"
				     False -> "Infinity"
			  False -> case
				     ((||) v109 (((<) v109 x 0)) ((isNegativeZero v109 x))) of
				      True -> (:) '-'
						((doFmt v109 fmt
						    ((floatToDigits v109
							((toInteger v109 (base v109)))
							((Prelude_B.negate_bUdDhA v109 x))))))
				      False -> (doFmt v109 fmt
						  ((floatToDigits v109
						      ((toInteger v109 (base v109)))
						      x)))
     doFmt v110 fmt v12
       = case v12 of
	    (is, e) -> let ds
			     = \ v111 -> (map v111 (B.fu1 (intToDigit v111)) is)
			 in
			 case fmt of
			    FFGeneric -> (doFmt v110
					    (case ((||) v110 (((<) v110 e 0)) (((>) v110 e 7))) of
						True -> FFExponent
						False -> FFFixed)
					    (is, e))
			    FFExponent -> case decs of
					     Nothing -> case (ds v110) of
							   [] -> "0.0e0"
							   [d] -> (:) d
								    (((++) v110 ".0e"
									((show v110
									    (((-) v110 e 1))))))
							   d : ds -> (:) d
								       ((:) '.'
									  (((++) v110 ds
									      ((:) 'e'
										 ((show v110
										     (((-) v110 e
											 1))))))))
					     Just dec -> let dec' = \ v112 -> (max v112 dec 1) in
							   case is of
							      [] -> (:) '0'
								      ((:) '.'
									 (((++) v110
									     ((take v110 (dec' v110)
										 ((repeat v110
										     '0'))))
									     "e0")))
							      _ -> let v114
									 = \ v113 ->
									     (roundTo v113
										(base v113)
										(((+) v113
										    (dec' v113)
										    1))
										is)
								       ei
									 = \ v115 ->
									     (\ (ei, is') -> ei)
									       (v114 v115)
								       is'
									 = \ v116 ->
									     (\ (ei, is') -> is')
									       (v114 v116)
								       v118
									 = \ v117 ->
									     (map v117
										(B.fu1
										   (intToDigit
										      v117))
										(case
										   ((>) v117
										      (ei v117)
										      0)
										   of
										    True -> (init
											       v117
											       (is'
												  v117))
										    False -> (is'
												v117)))
								       d = \ v119 ->
									     (\ (d : ds) -> d)
									       (v118 v119)
								       ds
									 = \ v120 ->
									     (\ (d : ds) -> ds)
									       (v118 v120)
								     in
								     (:) (d v110)
								       ((:) '.'
									  (((++) v110 (ds v110)
									      (((++) v110 "e"
										  ((show v110
										      (((+) v110
											  (((-) v110
											      e
											      1))
											  (ei
											     v110))))))))))
			    FFFixed -> let mk0 v121 v8
					     = let v9
						     = \ v123 ->
							 case v8 of
							    s -> s
							    _ -> (Prelude_B.error v123 "No Match")
						 in
						 case ((Prelude_B.==) v121 v8 "") of
						    True -> "0"
						    False -> (v9 v121)
					   mkdot0 v124 v10
					     = let v11
						     = \ v126 ->
							 case v10 of
							    s -> (:) '.' s
							    _ -> (Prelude_B.error v126 "No Match")
						 in
						 case ((Prelude_B.==) v124 v10 "") of
						    True -> ""
						    False -> (v11 v124)
					 in
					 let v7
					       = \ v128 ->
						   case decs of
						      Just dec -> let dec'
									= \ v129 -> (max v129 dec 0)
								    in
								    case ((>=) v128 e 0) of
								       True -> let v131
										     = \ v130 ->
											 (roundTo
											    v130
											    (base
											       v130)
											    (((+)
												v130
												(dec'
												   v130)
												e))
											    is)
										   ei
										     = \ v132 ->
											 (\ (ei,
											     is')
											    -> ei)
											   (v131
											      v132)
										   is'
										     = \ v133 ->
											 (\ (ei,
											     is')
											    -> is')
											   (v131
											      v133)
										   v135
										     = \ v134 ->
											 (splitAt
											    v134
											    (((+)
												v134
												e
												(ei
												   v134)))
											    ((map
												v134
												(B.fu1
												   (intToDigit
												      v134))
												(is'
												   v134))))
										   ls
										     = \ v136 ->
											 (\ (ls, rs)
											    -> ls)
											   (v135
											      v136)
										   rs
										     = \ v137 ->
											 (\ (ls, rs)
											    -> rs)
											   (v135
											      v137)
										 in
										 ((++) v128
										    ((mk0 v128
											(ls v128)))
										    ((mkdot0 v128
											(rs v128))))
								       False -> let v139
										      = \ v138 ->
											  (roundTo
											     v138
											     (base
												v138)
											     (dec'
												v138)
											     (((++)
												 v138
												 ((replicate
												     v138
												     ((Prelude_B.negate_bUdDhA
													 v138
													 e))
												     0))
												 is)))
										    ei
										      = \ v140 ->
											  (\ (ei,
											      is')
											     -> ei)
											    (v139
											       v140)
										    is'
										      = \ v141 ->
											  (\ (ei,
											      is')
											     -> is')
											    (v139
											       v141)
										    v143
										      = \ v142 ->
											  (map v142
											     (B.fu1
												(intToDigit
												   v142))
											     (case
												((>)
												   v142
												   (ei
												      v142)
												   0)
												of
												 True -> (is'
													    v142)
												 False -> (:)
													    0
													    (is'
													       v142)))
										    d = \ v144 ->
											  (\ (d :
												ds)
											     -> d)
											    (v143
											       v144)
										    ds
										      = \ v145 ->
											  (\ (d :
												ds)
											     -> ds)
											    (v143
											       v145)
										  in
										  (:) (d v128)
										    ((mkdot0 v128
											(ds v128)))
						      _ -> (Prelude_B.error v128 "No Match")
					   in
					   case decs of
					      Nothing -> case ((>) v110 e 0) of
							    True -> ((++) v110
								       ((take v110 e
									   (((++) v110 (ds v110)
									       ((repeat v110
										   '0'))))))
								       ((:) '.'
									  ((mk0 v110
									      ((drop v110 e
										  (ds v110)))))))
							    False -> case (otherwise v110) of
									True -> ((++) v110 "0."
										   ((mk0 v110
										       (((++) v110
											   ((replicate
											       v110
											       ((Prelude_B.negate_bUdDhA
												   v110
												   e))
											       '0'))
											   (ds
											      v110))))))
									False -> (v7 v110)
					      _ -> (v7 v110)
 
roundTo :: B.D (Int -> Int -> [Int] -> (Int, [Int]))
roundTo v158 base d is
  = let v13 = \ v160 -> (f v160 d is) in
      let v14
	    = \ v162 ->
		let v15 = \ v164 -> (Prelude_B.error v164 "No Match") in
		  case (v13 v162) of
		     (v16, is) -> case ((Prelude_B.==) v162 v16 1) of
				     True -> (1, (:) 1 is)
				     False -> (v15 v162)
		     _ -> (v15 v162)
	in
	case (v13 v158) of
	   (v17, is) -> case ((Prelude_B.==) v158 v17 0) of
			   True -> (0, is)
			   False -> (v14 v158)
	   _ -> (v14 v158)
  where
     b2 = \ v147 -> (div v147 base 2)
     f v148 v18 v19
       = let v20 = \ v150 -> (v18, v19) in
	   case (v20 v148) of
	      (n, []) -> (0, (replicate v148 n 0))
	      _ -> let v21
			 = \ v152 ->
			     case (v20 v152) of
				(d, (i : is)) -> let v154 = \ v153 -> (f v153 (((-) v153 d 1)) is)
						     c = \ v155 -> (\ (c, ds) -> c) (v154 v155)
						     ds = \ v156 -> (\ (c, ds) -> ds) (v154 v156)
						     i' = \ v157 -> ((+) v157 (c v157) i)
						   in
						   case ((==) v152 (i' v152) base) of
						      True -> (1, (:) 0 (ds v152))
						      False -> (0, (:) (i' v152) (ds v152))
				_ -> (Prelude_B.error v152 "No Match")
		     in
		     case (v20 v148) of
			(v22, (i : _)) -> case ((Prelude_B.==) v148 v22 0) of
					     True -> (case ((>=) v148 i (b2 v148)) of
							 True -> 1
							 False -> 0,
						      [])
					     False -> (v21 v148)
			_ -> (v21 v148)
 
floatToDigits ::
	      (RealFloat a) => B.D (Integer -> a -> ([Int], Int))
floatToDigits v165 v23 v24
  = let v25 = \ v167 -> (v23, v24) in
      let v26
	    = \ v169 ->
		case (v25 v169) of
		   (base, x) -> let v171 = \ v170 -> (decodeFloat v170 x)
				    f0 = \ v172 -> (\ (f0, e0) -> f0) (v171 v172)
				    e0 = \ v173 -> (\ (f0, e0) -> e0) (v171 v173)
				    v175 = \ v174 -> (floatRange v174 x)
				    minExp0 = \ v176 -> (\ (minExp0, _) -> minExp0) (v175 v176)
				    p = \ v177 -> (floatDigits v177 x)
				    b = \ v178 -> (floatRadix v178 x)
				    minExp = \ v179 -> ((-) v179 (minExp0 v179) (p v179))
				     
				    f :: B.D Integer
				     
				    e :: B.D Int
				    v182
				      = \ v180 ->
					  let n = \ v181 -> ((-) v181 (minExp v181) (e0 v181)) in
					    case ((>) v180 (n v180) 0) of
					       True -> ((div v180 (f0 v180)
							   (((^) v180 (b v180) (n v180)))),
							((+) v180 (e0 v180) (n v180)))
					       False -> ((f0 v180), (e0 v180))
				    f = \ v183 -> (\ (f, e) -> f) (v182 v183)
				    e = \ v184 -> (\ (f, e) -> e) (v182 v184)
				    v187
				      = \ v185 ->
					  case ((>=) v185 (e v185) 0) of
					     True -> let be = \ v186 -> ((^) v186 (b v186) (e v186))
						       in
						       case
							 ((==) v185 (f v185)
							    (((^) v185 (b v185)
								(((-) v185 (p v185) 1)))))
							 of
							  True -> (((*) v185
								      (((*) v185
									  (((*) v185 (f v185)
									      (be v185)))
									  (b v185)))
								      2),
								   ((*) v185 2 (b v185)),
								   ((*) v185 (be v185) (b v185)),
								   (b v185))
							  False -> (((*) v185
								       (((*) v185 (f v185)
									   (be v185)))
								       2),
								    2, (be v185), (be v185))
					     False -> case
							((&&) v185
							   (((>) v185 (e v185) (minExp v185)))
							   (((==) v185 (f v185)
							       (((^) v185 (b v185)
								   (((-) v185 (p v185) 1)))))))
							of
							 True -> (((*) v185
								     (((*) v185 (f v185) (b v185)))
								     2),
								  ((*) v185
								     (((^) v185 (b v185)
									 (((+) v185
									     ((Prelude_B.negate_bUdDhA
										 v185
										 (e v185)))
									     1))))
								     2),
								  (b v185), 1)
							 False -> (((*) v185 (f v185) 2),
								   ((*) v185
								      (((^) v185 (b v185)
									  ((Prelude_B.negate_bUdDhA
									      v185
									      (e v185)))))
								      2),
								   1, 1)
				    r = \ v188 -> (\ (r, s, mUp, mDn) -> r) (v187 v188)
				    s = \ v189 -> (\ (r, s, mUp, mDn) -> s) (v187 v189)
				    mUp = \ v190 -> (\ (r, s, mUp, mDn) -> mUp) (v187 v190)
				    mDn = \ v191 -> (\ (r, s, mUp, mDn) -> mDn) (v187 v191)
				    k = \ v192 ->
					  let k0
						= \ v193 ->
						    case
						      ((&&) v193 (((==) v193 (b v193) 2))
							 (((==) v193 base 10)))
						      of
						       True -> (div v193
								  (((*) v193
								      (((+) v193
									  (((-) v193 (p v193) 1))
									  (e0 v193)))
								      3))
								  10)
						       False -> (ceiling v193
								   ((((/) v193
									(((+) v193
									    ((log v193
										((fromInteger_bUdDhA
										    v193
										    (((+) v193
											(f v193)
											1))))))
									    (((*) v193
										((fromIntegral v193
										    (e v193)))
										((log v193
										    ((fromInteger_bUdDhA
											v193
											(b v193)))))))))
									((log v193
									    ((fromInteger_bUdDhA
										v193
										base))))))
								      :: Double))
					      fixup v194 n
						= case ((>=) v194 n 0) of
						     True -> case
							       ((<=) v194
								  (((+) v194 (r v194) (mUp v194)))
								  (((*) v194 ((expt v194 base n))
								      (s v194))))
							       of
								True -> n
								False -> (fixup v194
									    (((+) v194 n 1)))
						     False -> case
								((<=) v194
								   (((*) v194
								       ((expt v194 base
									   ((Prelude_B.negate_bUdDhA
									       v194
									       n))))
								       (((+) v194 (r v194)
									   (mUp v194)))))
								   (s v194))
								of
								 True -> n
								 False -> (fixup v194
									     (((+) v194 n 1)))
					    in (fixup v192 (k0 v192))
				    gen v195 ds rn sN mUpN mDnN
				      = let v197 = \ v196 -> (divMod v196 (((*) v196 rn base)) sN)
					    dn = \ v198 -> (\ (dn, rn') -> dn) (v197 v198)
					    rn' = \ v199 -> (\ (dn, rn') -> rn') (v197 v199)
					    mUpN' = \ v200 -> ((*) v200 mUpN base)
					    mDnN' = \ v201 -> ((*) v201 mDnN base)
					  in
					  case
					    (((<) v195 (rn' v195) (mDnN' v195)),
					     ((>) v195 (((+) v195 (rn' v195) (mUpN' v195))) sN))
					    of
					     (True, False) -> (:) (dn v195) ds
					     (False, True) -> (:) (((+) v195 (dn v195) 1)) ds
					     (True, True) -> case
							       ((<) v195 (((*) v195 (rn' v195) 2))
								  sN)
							       of
								True -> (:) (dn v195) ds
								False -> (:)
									   (((+) v195 (dn v195) 1))
									   ds
					     (False, False) -> (gen v195 ((:) (dn v195) ds)
								  (rn' v195)
								  sN
								  (mUpN' v195)
								  (mDnN' v195))
				    rds
				      = \ v202 ->
					  case ((>=) v202 (k v202) 0) of
					     True -> (gen v202 [] (r v202)
							(((*) v202 (s v202)
							    ((expt v202 base (k v202)))))
							(mUp v202)
							(mDn v202))
					     False -> let bk
							    = \ v203 ->
								(expt v203 base
								   ((Prelude_B.negate_bUdDhA v203
								       (k v203))))
							in
							(gen v202 [] (((*) v202 (r v202) (bk v202)))
							   (s v202)
							   (((*) v202 (mUp v202) (bk v202)))
							   (((*) v202 (mDn v202) (bk v202))))
				  in
				  ((map v169 (B.fu1 (fromIntegral v169))
				      ((reverse v169 (rds v169)))),
				   (k v169))
		   _ -> (Prelude_B.error v169 "No Match")
	in
	case (v25 v165) of
	   (_, v27) -> case ((Prelude_B.==) v165 v27 0) of
			  True -> ([], 0)
			  False -> (v26 v165)
	   _ -> (v26 v165)
 
readFloat :: (RealFrac a) => B.D ([Char] -> [(a, [Char])])
readFloat v216 r
  = ((++) v216
       (((>>=) v216 ((readFix v216 r))
	   ((B.fu1
	       (\ v29 ->
		  case v29 of
		     (n, d, s) -> ((>>=) v216 ((readExp v216 s))
				     ((B.fu1
					 (\ v28 ->
					    case v28 of
					       (k, t) -> (Prelude_B.return v216
							    ((fromRational_bUdDhA v216
								(((*) v216 (((%) v216 n 1))
								    (((^^) v216 10
									(((-) v216 k d))))))),
							     t))
					       _ -> (Prelude_B.fail v216
						       "pattern match error: Numeric.hs (302,64)")))))
		     _ -> (Prelude_B.fail v216
			     "pattern match error: Numeric.hs (301,64)"))))))
       (((++) v216
	   (((>>=) v216 ((lex v216 r))
	       ((B.fu1
		   (\ v30 ->
		      case v30 of
			 ("NaN", t) -> (Prelude_B.return v216 (((/) v216 0 0), t))
			 _ -> (Prelude_B.fail v216
				 "pattern match error: Numeric.hs (303,46)"))))))
	   (((>>=) v216 ((lex v216 r))
	       ((B.fu1
		   (\ v31 ->
		      case v31 of
			 ("Infinity", t) -> (Prelude_B.return v216 (((/) v216 1 0), t))
			 _ -> (Prelude_B.fail v216
				 "pattern match error: Numeric.hs (304,46)")))))))))
  where
     readFix v204 r
       = ((>>=) v204 ((lexDigits v204 r))
	    ((B.fu1
		(\ v33 ->
		   case v33 of
		      (ds, d) -> ((>>=) v204 ((lexFrac v204 d))
				    ((B.fu1
					(\ v32 ->
					   case v32 of
					      (ds', t) -> (Prelude_B.return v204
							     ((read v204 (((++) v204 ds ds'))),
							      (length v204 ds'), t))
					      _ -> (Prelude_B.fail v204
						      "pattern match error: Numeric.hs (308,40)")))))
		      _ -> (Prelude_B.fail v204
			      "pattern match error: Numeric.hs (307,39)")))))
     lexFrac v205 v34
       = let v35
	       = \ v207 ->
		   case v34 of
		      s -> [("", s)]
		      _ -> (Prelude_B.error v207 "No Match")
	   in
	   case v34 of
	      (v36 : ds) -> case ((Prelude_B.==) v205 v36 '.') of
			       True -> (lexDigits v205 ds)
			       False -> (v35 v205)
	      _ -> (v35 v205)
     readExp v208 v37
       = let v38
	       = \ v210 ->
		   case v37 of
		      s -> [(0, s)]
		      _ -> (Prelude_B.error v210 "No Match")
	   in
	   case v37 of
	      (e : s) -> case (elem v208 e "eE") of
			    True -> (readExp' v208 s)
			    False -> (v38 v208)
	      _ -> (v38 v208)
     readExp' v211 v39
       = let v40
	       = \ v213 ->
		   let v41
			 = \ v215 ->
			     case v39 of
				s -> (readDec v215 s)
				_ -> (Prelude_B.error v215 "No Match")
		     in
		     case v39 of
			(v42 : s) -> case ((Prelude_B.==) v213 v42 '+') of
					True -> (readDec v213 s)
					False -> (v41 v213)
			_ -> (v41 v213)
	   in
	   case v39 of
	      (v43 : s) -> case ((Prelude_B.==) v211 v43 '-') of
			      True -> ((>>=) v211 ((readDec v211 s))
					 ((B.fu1
					     (\ v44 ->
						case v44 of
						   (k, t) -> (Prelude_B.return v211
								((Prelude_B.negate_bUdDhA v211 k),
								 t))
						   _ -> (Prelude_B.fail v211
							   "pattern match error: Numeric.hs (316,53)")))))
			      False -> (v40 v211)
	      _ -> (v40 v211)
 
lexDigits :: B.D ([Char] -> [([Char], [Char])])
lexDigits v218 v217 = (nonnull v218 (B.fu1 (isDigit v218)) v217)
 
nonnull :: B.D (B.F Char Bool -> [Char] -> [([Char], [Char])])
nonnull v219 p s
  = ((>>=) v219 [(span v219 p s)]
       ((B.fu1
	   (\ v45 ->
	      case v45 of
		 (cs@(_ : _), t) -> (Prelude_B.return v219 (cs, t))
		 _ -> (Prelude_B.fail v219
			 "pattern match error: Numeric.hs (324,44)")))))