{- This is an interface file for Buddha, a declarative debugger
   for Haskell 98. Please do not modify this file -}


{- The ident info for all constructors and top level identifiers -}

idents = [(EQ, Con, 0),
 (False, Con, 0),
 (GT, Con, 0),
 (Just, Con, 1),
 (LT, Con, 0),
 (Left, Con, 1),
 (Nothing, Con, 0),
 (Right, Con, 1),
 (True, Con, 0),
 (abs, LetFun, 1),
 (acos, LetFun, 1),
 (acosh, LetFun, 1),
 (all, LetFun, 2),
 (and, LetFun, 1),
 (any, LetFun, 2),
 (appendFile, LetFun, 2),
 (asTypeOf, LetFun, 2),
 (asin, LetFun, 1),
 (asinh, LetFun, 1),
 (atan, LetFun, 1),
 (atan2, LetFun, 2),
 (atanh, LetFun, 1),
 (break, LetFun, 2),
 (catch, LetFun, 2),
 (ceiling, LetFun, 1),
 (compare, LetFun, 2),
 (concat, LetFun, 1),
 (concatMap, LetFun, 2),
 (const, LetFun, 2),
 (cos, LetFun, 1),
 (cosh, LetFun, 1),
 (curry, LetFun, 3),
 (cycle, LetFun, 1),
 (decodeFloat, LetFun, 1),
 (div, LetFun, 2),
 (divMod, LetFun, 2),
 (drop, LetFun, 2),
 (dropWhile, LetFun, 2),
 (either, LetFun, 3),
 (elem, LetFun, 2),
 (encodeFloat, LetFun, 2),
 (enumFrom, LetFun, 1),
 (enumFromThen, LetFun, 2),
 (enumFromThenTo, LetFun, 3),
 (enumFromTo, LetFun, 2),
 (error, LetFun, 1),
 (even, LetFun, 1),
 (exp, LetFun, 1),
 (exponent, LetFun, 1),
 (fail, LetFun, 1),
 (filter, LetFun, 2),
 (flip, LetFun, 3),
 (floatDigits, LetFun, 1),
 (floatRadix, LetFun, 1),
 (floatRange, LetFun, 1),
 (floor, LetFun, 1),
 (fmap, LetFun, 2),
 (foldl, LetFun, 3),
 (foldl1, LetFun, 2),
 (foldr, LetFun, 3),
 (foldr1, LetFun, 2),
 (fromEnum, LetFun, 1),
 (fromInteger_bUdDhA, LetFun, 1),
 (fromIntegral, LetFun, 1),
 (fromRational_bUdDhA, LetFun, 1),
 (fst, LetFun, 1),
 (gcd, LetFun, 2),
 (getChar, LetConst, 0),
 (getContents, LetConst, 0),
 (getLine, LetConst, 0),
 (head, LetFun, 1),
 (id, LetFun, 1),
 (init, LetFun, 1),
 (interact, LetFun, 1),
 (ioError, LetFun, 1),
 (isDenormalized, LetFun, 1),
 (isIEEE, LetFun, 1),
 (isInfinite, LetFun, 1),
 (isNaN, LetFun, 1),
 (isNegativeZero, LetFun, 1),
 (iterate, LetFun, 2),
 (last, LetFun, 1),
 (lcm, LetFun, 2),
 (length, LetFun, 1),
 (lex, LetFun, 1),
 (lines, LetFun, 1),
 (log, LetFun, 1),
 (logBase, LetFun, 2),
 (lookup, LetFun, 2),
 (map, LetFun, 2),
 (mapM, LetFun, 2),
 (mapM_, LetFun, 2),
 (max, LetFun, 2),
 (maxBound, LetConstOL, 0),
 (maximum, LetFun, 1),
 (maybe, LetFun, 3),
 (min, LetFun, 2),
 (minBound, LetConstOL, 0),
 (minimum, LetFun, 1),
 (mod, LetFun, 2),
 (negate_bUdDhA, LetFun, 1),
 (not, LetFun, 1),
 (notElem, LetFun, 2),
 (null, LetFun, 1),
 (odd, LetFun, 1),
 (or, LetFun, 1),
 (otherwise, LetConst, 0),
 (pi, LetConstOL, 0),
 (pred, LetFun, 1),
 (print, LetFun, 1),
 (product, LetFun, 1),
 (properFraction, LetFun, 1),
 (putChar, LetFun, 1),
 (putStr, LetFun, 1),
 (putStrLn, LetFun, 1),
 (quot, LetFun, 2),
 (quotRem, LetFun, 2),
 (read, LetFun, 1),
 (readFile, LetFun, 1),
 (readIO, LetFun, 1),
 (readList, LetFun, 1),
 (readLn, LetConstOL, 0),
 (readParen, LetFun, 3),
 (reads, LetFun, 1),
 (readsPrec, LetFun, 2),
 (realToFrac, LetFun, 1),
 (recip, LetFun, 1),
 (rem, LetFun, 2),
 (repeat, LetFun, 1),
 (replicate, LetFun, 2),
 (return, LetFun, 1),
 (reverse, LetFun, 1),
 (round, LetFun, 1),
 (scaleFloat, LetFun, 2),
 (scanl, LetFun, 3),
 (scanl1, LetFun, 2),
 (scanr, LetFun, 3),
 (scanr1, LetFun, 2),
 (seq, LetFun, 2),
 (sequence, LetFun, 1),
 (sequence_, LetFun, 1),
 (show, LetFun, 1),
 (showApply, LetFun, 3),
 (showChar, LetFun, 2),
 (showList, LetFun, 2),
 (showParen, LetFun, 3),
 (showString, LetFun, 2),
 (shows, LetFun, 2),
 (showsPrec, LetFun, 3),
 (showsPrec', LetFun, 2),
 (significand, LetFun, 1),
 (signum, LetFun, 1),
 (sin, LetFun, 1),
 (sinh, LetFun, 1),
 (snd, LetFun, 1),
 (span, LetFun, 2),
 (splitAt, LetFun, 2),
 (sqrt, LetFun, 1),
 (subtract, LetFun, 2),
 (succ, LetFun, 1),
 (sum, LetFun, 1),
 (tail, LetFun, 1),
 (take, LetFun, 2),
 (takeWhile, LetFun, 2),
 (tan, LetFun, 1),
 (tanh, LetFun, 1),
 (toEnum, LetFun, 1),
 (toInteger, LetFun, 1),
 (toRational, LetFun, 1),
 (truncate, LetFun, 1),
 (uncurry, LetFun, 2),
 (undefined, LetConst, 0),
 (unlines, LetFun, 1),
 (until, LetFun, 3),
 (unwords, LetFun, 1),
 (unzip, LetFun, 1),
 (unzip3, LetFun, 1),
 (userError, LetFun, 1),
 (words, LetFun, 1),
 (writeFile, LetFun, 2),
 (zip, LetFun, 2),
 (zip3, LetFun, 3),
 (zipWith, LetFun, 3),
 (zipWith3, LetFun, 4),
 ((!!), LetFun, 2),
 (($), LetFun, 2),
 (($!), LetFun, 2),
 ((&&), LetFun, 2),
 ((*), LetFun, 2),
 ((**), LetFun, 2),
 ((+), LetFun, 2),
 ((++), LetFun, 2),
 ((-), LetFun, 2),
 ((.), LetFun, 3),
 ((/), LetFun, 2),
 ((/=), LetFun, 2),
 ((<), LetFun, 2),
 ((<=), LetFun, 2),
 ((=<<), LetFun, 2),
 ((==), LetFun, 2),
 ((>), LetFun, 2),
 ((>=), LetFun, 2),
 ((>>), LetFun, 2),
 ((>>=), LetFun, 2),
 ((^), LetFun, 2),
 ((^^), LetFun, 2),
 ((||), LetFun, 2)]

{- The class and tycon associations -}

assocs = [(Bool, [True,False]),
 (Bounded, [minBound,maxBound]),
 (Char, []),
 (Double, []),
 (Either, [Left,Right]),
 (Enum,
  [succ,
   pred,
   toEnum,
   fromEnum,
   enumFrom,
   enumFromThen,
   enumFromTo,
   enumFromThenTo]),
 (Eq, [(==),(/=)]),
 (FilePath, []),
 (Float, []),
 (Floating,
  [pi,
   exp,
   log,
   sqrt,
   (**),
   logBase,
   sin,
   cos,
   tan,
   asin,
   acos,
   atan,
   sinh,
   cosh,
   tanh,
   asinh,
   acosh,
   atanh]),
 (Fractional, [(/),recip,fromRational_bUdDhA]),
 (Functor, [fmap]),
 (IO, []),
 (IOError, []),
 (Int, []),
 (Integer, []),
 (Integral, [quot,rem,div,mod,quotRem,divMod,toInteger]),
 (Maybe, [Nothing,Just]),
 (Monad, [(>>=),(>>),return,fail]),
 (Num, [(+),(-),(*),negate_bUdDhA,abs,signum,fromInteger_bUdDhA]),
 (Ord, [compare,(<),(<=),(>=),(>),max,min]),
 (Ordering, [LT,EQ,GT]),
 (Rational, []),
 (Read, [readsPrec,readList]),
 (ReadS, []),
 (Real, [toRational]),
 (RealFloat,
  [floatRadix,
   floatDigits,
   floatRange,
   decodeFloat,
   encodeFloat,
   exponent,
   significand,
   scaleFloat,
   isNaN,
   isInfinite,
   isDenormalized,
   isNegativeZero,
   isIEEE,
   atan2]),
 (RealFrac, [properFraction,truncate,round,ceiling,floor]),
 (Show, [showsPrec,show,showList]),
 (ShowS, []),
 (String, [])]

{- The infix rules -}

fixity = [(div, L, 7),
 (elem, N, 4),
 (mod, L, 7),
 (notElem, N, 4),
 (quot, L, 7),
 (rem, L, 7),
 (seq, R, 0),
 ((!!), L, 9),
 (($), R, 0),
 (($!), R, 0),
 ((&&), R, 3),
 ((*), L, 7),
 ((**), R, 8),
 ((+), L, 6),
 ((++), R, 5),
 ((-), L, 6),
 ((.), R, 9),
 ((/), L, 7),
 ((/=), N, 4),
 ((<), N, 4),
 ((<=), N, 4),
 ((=<<), R, 1),
 ((==), N, 4),
 ((>), N, 4),
 ((>=), N, 4),
 ((>>), L, 1),
 ((>>=), L, 1),
 ((^), R, 8),
 ((^^), R, 8),
 ((||), R, 2)]

{- The type synonyms -}
 
type FilePath = [Char] 
type ReadS a = [Char] -> [(a, [Char])] 
type ShowS = [Char] -> [Char] 
type String = [Char]

{- The record constructors -}

records = []
