module Prelude_B
       ((!!), ($), ($!), (&&), (||), (.), (++), (=<<), (^), (^^), all,
	and, any, appendFile, asTypeOf, break, catch, concat, concatMap,
	const, curry, cycle, drop, dropWhile, either, elem, even, error,
	filter, flip, foldl, foldl1, foldr, foldr1, fromIntegral, fst,
	getChar, getContents, getLine, gcd, head, id, init, interact,
	ioError, iterate, last, lcm, length, lex, lines, lookup, map, mapM,
	mapM_, maybe, maximum, minimum, not, notElem, null, odd, or,
	otherwise, print, product, putChar, putStr, putStrLn, read, readIO,
	readLn, readFile, reads, readParen, realToFrac, repeat, replicate,
	reverse, scanl, scanl1, scanr, scanr1, seq, sequence, sequence_,
	showChar, showParen, shows, showString, showApply, showsPrec', snd,
	span, splitAt, subtract, sum, tail, take, takeWhile, uncurry,
	undefined, unlines, until, unwords, unzip, unzip3, userError,
	words, writeFile, zip, zip3, zipWith, zipWith3, Eq(..), Show(..),
	Functor(..), Monad(..), Ord(..), Enum(..), Bounded(..), Num(..),
	Real(..), Integral(..), Fractional(..), Floating(..), RealFrac(..),
	RealFloat(..), Read(..), Bool(True, False), Either(Left, Right),
	Maybe(Nothing, Just), Ordering(LT, EQ, GT), ReadS, ShowS, String,
	FilePath, Rational, Char, Double, Float, Int, Integer, IOError, IO)
       where
import qualified Buddha as B
import Prims_B
import IOPrims_B (IO(..), IOError, tryIO, getChar, putChar,
		  getLine, putStr, getContents, readFile, writeFile, appendFile,
		  ioError)
import Prelude ( Maybe (..),
                       Either (..),
                       Bool (..),
                       Ordering (..),
                       Char (..),
                       Double (..),
                       Float (..),
                       Int (..),
                       Integer (..),
                       Rational (..))

v0 = B.ps "Prelude"
 
{-
data Maybe a = Nothing
	     | Just a
 
data Either a b = Left a
		| Right b
 
data Bool = False
	  | True
 
data Ordering = LT
	      | EQ
	      | GT
-}
 
type String = [Char]
 
type FilePath = String
 
type ReadS a = B.F String [(a, String)]
 
type ShowS = B.F String String
 
infixr 9 .
 
infixl 9 !!
 
infixr 8 ^, ^^, **
 
infixl 7 *, /, `quot`, `rem`, `div`, `mod`
 
infixl 6 +, -
 
infixr 5 ++
 
infix 4 ==, /=, <, <=, >=, >, `elem`, `notElem`
 
infixr 3 &&
 
infixr 2 ||
 
infixl 1 >>, >>=
 
infixr 1 =<<
 
infixr 0 $, $!, `seq`
 
(!!) :: B.D ([a] -> Int -> a)
(v294 !! v1) v2
  = let v3 = \ v296 -> (v1, v2) in
      let v4
	    = \ v298 ->
		let v5
		      = \ v300 ->
			  case (v3 v300) of
			     ((_ : _), _) -> (error v300 "Prelude.!!: negative index")
			     _ -> case (v3 v300) of
				     ([], _) -> (error v300 "Prelude.!!: index too large")
				     _ -> (Prelude_B.error v300 "No Match")
		  in
		  case (v3 v298) of
		     ((_ : xs), n) -> case ((>) v298 n 0) of
					 True -> ((!!) v298 xs (((-) v298 n 1)))
					 False -> (v5 v298)
		     _ -> (v5 v298)
	in
	case (v3 v294) of
	   ((x : _), v6) -> case ((Prelude_B.==) v294 v6 0) of
			       True -> x
			       False -> (v4 v294)
	   _ -> (v4 v294)
 
($), ($!) :: B.D (B.F a b -> a -> b)
(v301 $ f) x = (B.app f x)
(v302 $! f) x = (seq v302 x ((B.app f x)))
 
(&&), (||) :: B.D (Bool -> Bool -> Bool)
(v303 && v7) v8
  = case (v7, v8) of
       (True, x) -> x
       (False, _) -> False
(v304 || v9) v10
  = case (v9, v10) of
       (True, _) -> True
       (False, x) -> x
 
(++) :: B.D ([a] -> [a] -> [a])
(v305 ++ v11) v12
  = case (v11, v12) of
       ([], ys) -> ys
       ((x : xs), ys) -> (:) x (((++) v305 xs ys))
 
(=<<) :: (Monad m) => B.D (B.F a (m b) -> m a -> m b)
(v306 =<< f) x = ((>>=) v306 x f)
 
(.) :: B.D (B.F b c -> B.F a b -> a -> c)
(v307 . f) g x = (B.app f ((B.app g x)))
 
(^) :: (Num a, Integral b) => B.D (a -> b -> a)
(v308 ^ v13) v14
  = let v15 = \ v310 -> (v13, v14) in
      let v16
	    = \ v312 ->
		let v17
		      = \ v314 ->
			  case (v15 v314) of
			     (_, _) -> (error v314 "Prelude.^: negative exponent")
			     _ -> (Prelude_B.error v314 "No Match")
		  in
		  case (v15 v312) of
		     (x, n) -> let f v315 v18 v19 v20
				     = let v21 = \ v317 -> (v18, v19, v20) in
					 let v22
					       = \ v319 ->
						   case (v21 v319) of
						      (x, n, y) -> let g v320 x n
									 = case (even v320 n) of
									      True -> (g v320
											 (((*) v320
											     x
											     x))
											 ((quot v320
											     n
											     2)))
									      False -> case
											 (otherwise
											    v320)
											 of
											  True -> (f v320
												     x
												     (((-)
													 v320
													 n
													 1))
												     (((*)
													 v320
													 x
													 y)))
								     in (g v319 x n)
						      _ -> (Prelude_B.error v319 "No Match")
					   in
					   case (v21 v315) of
					      (_, v23, y) -> case ((Prelude_B.==) v315 v23 0) of
								True -> y
								False -> (v22 v315)
					      _ -> (v22 v315)
				 in
				 case ((>) v312 n 0) of
				    True -> (f v312 x (((-) v312 n 1)) x)
				    False -> (v17 v312)
		     _ -> (v17 v312)
	in
	case (v15 v308) of
	   (x, v24) -> case ((Prelude_B.==) v308 v24 0) of
			  True -> 1
			  False -> (v16 v308)
	   _ -> (v16 v308)
 
(^^) :: (Fractional a, Integral b) => B.D (a -> b -> a)
(v321 ^^ x) n
  = case ((>=) v321 n 0) of
       True -> ((^) v321 x n)
       False -> (recip v321
		   (((^) v321 x ((Prelude_B.negate_bUdDhA v321 n)))))
 
and :: B.D ([Bool] -> Bool)
and v322 xs = (foldr v322 (B.fu2 ((&&) v322)) True xs)
 
all :: B.D (B.F a Bool -> [a] -> Bool)
all v324 p v323
  = ((.) v324 (B.fu1 (and v324)) ((B.fu1 (map v324 p))) v323)
 
any :: B.D (B.F a Bool -> [a] -> Bool)
any v326 p v325
  = ((.) v326 (B.fu1 (or v326)) ((B.fu1 (map v326 p))) v325)
 
asTypeOf :: B.D (a -> a -> a)
asTypeOf v327 x y = (const v327 x y)
 
break :: B.D (B.F a Bool -> [a] -> ([a], [a]))
break v329 p v328
  = (span v329 ((B.fu1 ((.) v329 (B.fu1 (not v329)) p))) v328)
 
catch :: B.D (IO a -> B.F IOError (IO a) -> IO a)
catch v330 io handle
  = case (tryIO v330 io) of
       MkIO m -> MkIO
		   ((B.fio
		       (\ state ->
			  case (B.app m state) of
			     Left e -> case (tryIO v330 ((B.app handle e))) of
					  MkIO me -> (B.app me state)
			     right -> right)))
 
concat :: B.D ([[a]] -> [a])
concat v331 xs = (foldr v331 (B.fu2 ((++) v331)) [] xs)
 
concatMap :: B.D (B.F a [b] -> [a] -> [b])
concatMap v333 f v332
  = ((.) v333 (B.fu1 (concat v333)) ((B.fu1 (map v333 f))) v332)
 
const :: B.D (a -> b -> a)
const v334 k j = k
 
curry :: B.D (B.F (a, b) c -> a -> b -> c)
curry v335 f x y = (B.app f (x, y))
 
cycle :: B.D ([a] -> [a])
cycle v336 v25
  = case v25 of
       [] -> []
       xs -> let xs' = \ v337 -> ((++) v337 xs (xs' v337)) in (xs' v336)
 
drop :: B.D (Int -> [a] -> [a])
drop v338 v26 v27
  = let v28 = \ v340 -> (v26, v27) in
      let v29
	    = \ v342 ->
		case (v28 v342) of
		   (_, []) -> []
		   _ -> let v30
			      = \ v344 ->
				  case (v28 v344) of
				     (_, _) -> (error v344 "Prelude.drop: negative argument")
				     _ -> (Prelude_B.error v344 "No Match")
			  in
			  case (v28 v342) of
			     (n, (_ : xs)) -> case ((>) v342 n 0) of
						 True -> (drop v342 (((-) v342 n 1)) xs)
						 False -> (v30 v342)
			     _ -> (v30 v342)
	in
	case (v28 v338) of
	   (v31, xs) -> case ((Prelude_B.==) v338 v31 0) of
			   True -> xs
			   False -> (v29 v338)
	   _ -> (v29 v338)
 
dropWhile :: B.D (B.F a Bool -> [a] -> [a])
dropWhile v345 v32 v33
  = case (v32, v33) of
       (p, []) -> []
       (p, xs) -> case (B.app p ((head v345 xs))) of
		     True -> (dropWhile v345 p ((tail v345 xs)))
		     False -> xs
 
either :: B.D (B.F a c -> B.F b c -> Either a b -> c)
either v346 v34 v35 v36
  = case (v34, v35, v36) of
       (l, r, (Left x)) -> (B.app l x)
       (l, r, (Right y)) -> (B.app r y)
 
elem :: (Eq a) => B.D (a -> [a] -> Bool)
elem v348 x v347
  = (any v348 ((B.fu1 (\ v37 -> ((==) v348 v37 x)))) v347)
 
error :: B.D ([Char] -> a)
error v349 s = (Prims_B.primError v349 s)
 
even :: (Integral a) => B.D (a -> Bool)
even v350 n = ((==) v350 ((rem v350 n 2)) 0)
 
filter :: B.D (B.F a Bool -> [a] -> [a])
filter v351 v38 v39
  = case (v38, v39) of
       (p, []) -> []
       (p, (x : xs)) -> case (B.app p x) of
			   True -> (:) x ((filter v351 p xs))
			   False -> (filter v351 p xs)
 
flip :: B.D (B.F a (B.F b c) -> b -> a -> c)
flip v352 f x y = (B.app (B.app f y) x)
 
foldl :: B.D (B.F a (B.F b a) -> a -> [b] -> a)
foldl v353 v40 v41 v42
  = case (v40, v41, v42) of
       (f, z, []) -> z
       (f, z, (x : xs)) -> (foldl v353 f ((B.app (B.app f z) x)) xs)
 
foldl1 :: B.D (B.F a (B.F a a) -> [a] -> a)
foldl1 v354 f v43
  = case v43 of
       (x : xs) -> (foldl v354 f x xs)
 
foldr :: B.D (B.F a (B.F b b) -> b -> [a] -> b)
foldr v355 v44 v45 v46
  = case (v44, v45, v46) of
       (f, z, []) -> z
       (f, z, (x : xs)) -> (B.app (B.app f x) ((foldr v355 f z xs)))
 
foldr1 :: B.D (B.F a (B.F a a) -> [a] -> a)
foldr1 v356 v47 v48
  = case (v47, v48) of
       (f, [x]) -> x
       (f, (x : xs)) -> (B.app (B.app f x) ((foldr1 v356 f xs)))
 
fromIntegral :: (Integral a, Num b) => B.D (a -> b)
fromIntegral v358 v357
  = ((.) v358 (B.fu1 (fromInteger_bUdDhA v358))
       (B.fu1 (toInteger v358))
       v357)
 
fst :: B.D ((a, b) -> a)
fst v359 v49
  = case v49 of
       (x, y) -> x
 
gcd :: (Integral a) => B.D (a -> a -> a)
gcd v360 v50 v51
  = let v52 = \ v362 -> (v50, v51) in
      let v53
	    = \ v364 ->
		case (v52 v364) of
		   (x, y) -> let gcd' v365 v54 v55
				   = let v56 = \ v367 -> (v54, v55) in
				       let v57
					     = \ v369 ->
						 case (v56 v369) of
						    (x, y) -> (gcd' v369 y ((rem v369 x y)))
						    _ -> (Prelude_B.error v369 "No Match")
					 in
					 case (v56 v365) of
					    (x, v58) -> case ((Prelude_B.==) v365 v58 0) of
							   True -> x
							   False -> (v57 v365)
					    _ -> (v57 v365)
			       in (gcd' v364 ((abs v364 x)) ((abs v364 y)))
		   _ -> (Prelude_B.error v364 "No Match")
	in
	case (v52 v360) of
	   (v59, v60) -> case ((Prelude_B.==) v360 v59 0) of
			    True -> case ((Prelude_B.==) v360 v60 0) of
				       True -> (error v360 "Prelude.gcd: gcd 0 0 is undefined")
				       False -> (v53 v360)
			    False -> (v53 v360)
	   _ -> (v53 v360)
 
head :: B.D ([a] -> a)
head v370 v61
  = case v61 of
       (x : y) -> x
 
id :: B.D (a -> a)
id v371 x = x
 
init :: B.D ([a] -> [a])
init v372 v62
  = case v62 of
       [x] -> []
       (x : xs) -> (:) x ((init v372 xs))
 
interact :: B.D (B.F [Char] [Char] -> IO ())
interact v373 f
  = ((>>=) v373 (getContents v373)
       ((B.fu1 (\ s -> (putStr v373 ((B.app f s)))))))
 
iterate :: B.D (B.F a a -> a -> [a])
iterate v374 f x = (:) x ((iterate v374 f ((B.app f x))))
 
last :: B.D ([a] -> a)
last v375 v64
  = case v64 of
       [x] -> x
       (x : xs) -> (last v375 xs)
 
lcm :: (Integral a) => B.D (a -> a -> a)
lcm v376 v65 v66
  = let v67 = \ v378 -> (v65, v66) in
      let v68
	    = \ v380 ->
		let v69
		      = \ v382 ->
			  case (v67 v382) of
			     (x, y) -> (abs v382
					  (((*) v382 ((quot v382 x ((gcd v382 x y)))) y)))
			     _ -> (Prelude_B.error v382 "No Match")
		  in
		  case (v67 v380) of
		     (v70, _) -> case ((Prelude_B.==) v380 v70 0) of
				    True -> 0
				    False -> (v69 v380)
		     _ -> (v69 v380)
	in
	case (v67 v376) of
	   (_, v71) -> case ((Prelude_B.==) v376 v71 0) of
			  True -> 0
			  False -> (v68 v376)
	   _ -> (v68 v376)
 
length :: B.D ([a] -> Int)
length v383 v72
  = case v72 of
       [] -> 0
       (_ : l) -> ((+) v383 1 ((length v383 l)))
 
lines :: B.D ([Char] -> [[Char]])
lines v384 v73
  = let v74
	  = \ v386 ->
	      case v73 of
		 s -> let v388
			    = \ v387 ->
				(break v387 ((B.fu1 (\ v75 -> ((==) v387 v75 '\n')))) s)
			  l = \ v389 -> (\ (l, s') -> l) (v388 v389)
			  s' = \ v390 -> (\ (l, s') -> s') (v388 v390)
			in
			(:) (l v386)
			  (case (s' v386) of
			      [] -> []
			      (_ : s'') -> (lines v386 s''))
		 _ -> (Prelude_B.error v386 "No Match")
      in
      case ((Prelude_B.==) v384 v73 "") of
	 True -> []
	 False -> (v74 v384)
 
lookup :: (Eq a) => B.D (a -> [(a, b)] -> Maybe b)
lookup v391 v76 v77
  = let v78 = \ v393 -> (v76, v77) in
      case (v78 v391) of
	 (key, []) -> Nothing
	 _ -> let v79 = \ v395 -> (Prelude_B.error v395 "No Match") in
		case (v78 v391) of
		   (key, ((x, y) : xys)) -> case ((==) v391 key x) of
					       True -> Just y
					       False -> case (otherwise v391) of
							   True -> (lookup v391 key xys)
							   False -> (v79 v391)
		   _ -> (v79 v391)
map v396 v80 v81
  = case (v80, v81) of
       (f, []) -> []
       (f, (x : xs)) -> (:) ((B.app f x)) ((map v396 f xs))
 
mapM :: (Monad m) => B.D (B.F a (m b) -> [a] -> m [b])
mapM v397 f as = (sequence v397 ((map v397 f as)))
 
mapM_ :: (Monad m) => B.D (B.F a (m b) -> [a] -> m ())
mapM_ v398 f as = (sequence_ v398 ((map v398 f as)))
 
maybe :: B.D (b -> B.F a b -> Maybe a -> b)
maybe v399 v82 v83 v84
  = case (v82, v83, v84) of
       (n, f, Nothing) -> n
       (n, f, (Just x)) -> (B.app f x)
 
maximum :: (Ord a) => B.D ([a] -> a)
maximum v400 v85
  = case v85 of
       [] -> (error v400 "Prelude.maximum: empty list")
       xs -> (foldl1 v400 (B.fu2 (max v400)) xs)
 
minimum :: (Ord a) => B.D ([a] -> a)
minimum v401 v86
  = case v86 of
       [] -> (error v401 "Prelude.minimum: empty list")
       xs -> (foldl1 v401 (B.fu2 (min v401)) xs)
 
not :: B.D (Bool -> Bool)
not v402 v87
  = case v87 of
       True -> False
       False -> True
 
notElem :: (Eq a) => B.D (a -> [a] -> Bool)
notElem v404 x v403
  = (all v404 ((B.fu1 (\ v88 -> ((/=) v404 v88 x)))) v403)
 
null :: B.D ([a] -> Bool)
null v405 v89
  = case v89 of
       [] -> True
       (x : y) -> False
 
odd :: (Integral a) => B.D (a -> Bool)
odd v406 x = (not v406 ((even v406 x)))
 
or :: B.D ([Bool] -> Bool)
or v407 xs = (foldr v407 (B.fu2 ((||) v407)) False xs)
 
otherwise :: B.D Bool
otherwise = \ v408 -> True
 
print :: (Show a) => B.D (a -> IO ())
print v410 v409
  = ((.) v410 (B.fu1 (putStrLn v410)) (B.fu1 (show v410)) v409)
 
product :: (Num a) => B.D ([a] -> a)
product v411 xs = (foldl v411 (B.fu2 ((*) v411)) 1 xs)
 
putStrLn :: B.D ([Char] -> IO ())
putStrLn v412 s
  = ((>>) v412 ((putStr v412 s)) ((putStr v412 "\n")))
 
readIO :: (Read a) => B.D ([Char] -> IO a)
readIO v413 s
  = case
      ((>>=) v413 ((reads v413 s))
	 ((B.fu1
	     (\ v91 ->
		case v91 of
		   (x, t) -> ((>>=) v413 ((lex v413 t))
				((B.fu1
				    (\ v90 ->
				       case v90 of
					  ("", "") -> (Prelude_B.return v413 x)
					  _ -> (Prelude_B.fail v413
						  "pattern match error: Prelude.hs (471,56)")))))
		   _ -> (Prelude_B.fail v413
			   "pattern match error: Prelude.hs (471,36)")))))
      of
       [x] -> (return v413 x)
       [] -> (ioError v413
		((userError v413 "PreludeIO.readIO: no parse")))
       _ -> (ioError v413
	       ((userError v413 "PreludeIO.readIO: ambiguous parse")))
 
readLn :: (Read a) => B.D (IO a)
readLn
  = \ v414 ->
      ((>>=) v414 (getLine v414)
	 ((B.fu1
	     (\ l ->
		((>>=) v414 ((readIO v414 l))
		   ((B.fu1 (\ r -> (return v414 r)))))))))
 
realToFrac :: (Real a, Fractional b) => B.D (a -> b)
realToFrac v416 v415
  = ((.) v416 (B.fu1 (fromRational_bUdDhA v416))
       (B.fu1 (toRational v416))
       v415)
 
repeat :: B.D (a -> [a])
repeat v418 x = (xs v418)
  where
     xs = \ v417 -> (:) x (xs v417)
 
replicate :: B.D (Int -> a -> [a])
replicate v419 n x = (take v419 n ((repeat v419 x)))
 
reverse :: B.D ([a] -> [a])
reverse v420 xs
  = (foldl v420 ((B.fu2 (flip v420 (B.fu2 (:))))) [] xs)
 
scanl :: B.D (B.F a (B.F b a) -> a -> [b] -> [a])
scanl v421 f q xs
  = (:) q
      (case xs of
	  [] -> []
	  x : xs -> (scanl v421 f ((B.app (B.app f q) x)) xs))
 
scanl1 :: B.D (B.F a (B.F a a) -> [a] -> [a])
scanl1 v422 v94 v95
  = case (v94, v95) of
       (x, []) -> []
       (f, (x : xs)) -> (scanl v422 f x xs)
 
scanr :: B.D (B.F a (B.F b b) -> b -> [a] -> [b])
scanr v423 v96 v97 v98
  = case (v96, v97, v98) of
       (f, q0, []) -> [q0]
       (f, q0, (x : xs)) -> let qs = \ v424 -> (scanr v424 f q0 xs) in
			      (:) ((B.app (B.app f x) ((head v423 (qs v423))))) (qs v423)
 
scanr1 :: B.D (B.F a (B.F a a) -> [a] -> [a])
scanr1 v425 v99 v100
  = case (v99, v100) of
       (f, []) -> []
       (f, [x]) -> [x]
       (f, (x : xs)) -> let qs = \ v426 -> (scanr1 v426 f xs) in
			  (:) ((B.app (B.app f x) ((head v425 (qs v425))))) (qs v425)
 
seq :: B.D (a -> b -> b)
seq v427 x y = (Prims_B.primSeq v427 x y)
 
sequence :: (Monad m) => B.D ([m a] -> m [a])
sequence v430 v428
  = (foldr v430 (B.fu2 (mcons v430)) ((return v430 [])) v428)
  where
     mcons v429 p q
       = ((>>=) v429 p
	    ((B.fu1
		(\ x ->
		   ((>>=) v429 q ((B.fu1 (\ y -> (return v429 ((:) x y))))))))))
 
sequence_ :: (Monad m) => B.D ([m a] -> m ())
sequence_ v432 v431
  = (foldr v432 (B.fu2 ((>>) v432)) ((return v432 ())) v431)
 
showChar :: B.D (Char -> [Char] -> [Char])
showChar v433 c s = (:) c s
 
showParen :: B.D (Bool -> B.F [Char] [Char] -> [Char] -> [Char])
showParen v435 b p v434
  = case b of
       True -> ((.) v435 ((B.fu1 (showChar v435 '(')))
		  ((B.fu1 ((.) v435 p ((B.fu1 (showChar v435 ')'))))))
		  v434)
       False -> (B.app p v434)
 
shows :: (Show a) => B.D (a -> [Char] -> [Char])
shows v438 v436 v437 = (showsPrec v438 0 v436 v437)
 
showString :: B.D ([Char] -> [Char] -> [Char])
showString v439 s1 s2 = ((++) v439 s1 s2)
 
showApply :: B.D (Bool -> [B.F [Char] [Char]] -> [Char] -> [Char])
showApply v441 parens fs s
  = (showParen v441 parens ((B.fu1 (showApply' v441 fs))) s)
  where
     showApply' v440 v101 v102
       = case (v101, v102) of
	    ([], s) -> s
	    ([f], s) -> (B.app f s)
	    ((f : fs), s) -> (B.app f
				((showString v440 " " ((showApply' v440 fs s)))))
showsPrec' v442 d x = (B.fu1 (showsPrec v442 d x))
 
snd :: B.D ((a, b) -> b)
snd v443 v103
  = case v103 of
       (x, y) -> y
 
span :: B.D (B.F a Bool -> [a] -> ([a], [a]))
span v444 v104 v105
  = let v106 = \ v446 -> (v104, v105) in
      case (v106 v444) of
	 (p, []) -> ([], [])
	 _ -> let v107 = \ v448 -> (Prelude_B.error v448 "No Match") in
		case (v106 v444) of
		   (p, xs@(x : xs')) -> let v450 = \ v449 -> (span v449 p xs')
					    ys = \ v451 -> (\ (ys, zs) -> ys) (v450 v451)
					    zs = \ v452 -> (\ (ys, zs) -> zs) (v450 v452)
					  in
					  case (B.app p x) of
					     True -> ((:) x (ys v444), (zs v444))
					     False -> case (otherwise v444) of
							 True -> ([], xs)
							 False -> (v107 v444)
		   _ -> (v107 v444)
 
splitAt :: B.D (Int -> [a] -> ([a], [a]))
splitAt v453 v108 v109
  = let v110 = \ v455 -> (v108, v109) in
      let v111
	    = \ v457 ->
		case (v110 v457) of
		   (_, []) -> ([], [])
		   _ -> let v112
			      = \ v459 ->
				  case (v110 v459) of
				     (_, _) -> (error v459 "Prelude.splitAt: negative argument")
				     _ -> (Prelude_B.error v459 "No Match")
			  in
			  case (v110 v457) of
			     (n, (x : xs)) -> let v461
						    = \ v460 -> (splitAt v460 (((-) v460 n 1)) xs)
						  xs' = \ v462 -> (\ (xs', xs'') -> xs') (v461 v462)
						  xs''
						    = \ v463 -> (\ (xs', xs'') -> xs'') (v461 v463)
						in
						case ((>) v457 n 0) of
						   True -> ((:) x (xs' v457), (xs'' v457))
						   False -> (v112 v457)
			     _ -> (v112 v457)
	in
	case (v110 v453) of
	   (v113, xs) -> case ((Prelude_B.==) v453 v113 0) of
			    True -> ([], xs)
			    False -> (v111 v453)
	   _ -> (v111 v453)
 
sum :: (Num a) => B.D ([a] -> a)
sum v465 v464 = (foldl v465 (B.fu2 ((+) v465)) 0 v464)
 
subtract :: (Num a) => B.D (a -> a -> a)
subtract v468 v466 v467 = (flip v468 (B.fu2 ((-) v468)) v466 v467)
 
tail :: B.D ([a] -> [a])
tail v469 v114
  = case v114 of
       (y : xs) -> xs
 
take :: B.D (Int -> [a] -> [a])
take v470 n xs
  = case ((<=) v470 n 0) of
       True -> []
       False -> case xs of
		   [] -> []
		   (y : ys) -> (:) y ((take v470 (((-) v470 n 1)) ys))
 
takeWhile :: B.D (B.F a Bool -> [a] -> [a])
takeWhile v471 v115 v116
  = case (v115, v116) of
       (p, []) -> []
       (p, (x : xs)) -> case (B.app p x) of
			   True -> (:) x ((takeWhile v471 p xs))
			   False -> []
 
uncurry :: B.D (B.F a (B.F b c) -> (a, b) -> c)
uncurry v472 f p = (B.app (B.app f ((fst v472 p))) ((snd v472 p)))
undefined = \ v473 -> (undefined v473)
 
unlines :: B.D ([[Char]] -> [Char])
unlines v474 ss
  = (concatMap v474 ((B.fu1 (\ v117 -> ((++) v474 v117 "\n")))) ss)
 
until :: B.D (B.F a Bool -> B.F a a -> a -> a)
until v475 p f x
  = case (B.app p x) of
       True -> x
       False -> (until v475 p f ((B.app f x)))
 
unwords :: B.D ([[Char]] -> [Char])
unwords v476 v118
  = case v118 of
       [] -> ""
       ws -> (foldr1 v476 ((B.fu2 (\ w s -> ((++) v476 w ((:) ' ' s)))))
		ws)
 
unzip :: B.D ([(a, b)] -> ([a], [b]))
unzip v477 ps
  = (foldr v477
       ((B.fu2 (\ v478@(a, b) v479@(~(as, bs)) -> ((:) a as, (:) b bs))))
       ([], [])
       ps)
 
unzip3 :: B.D ([(a, b, c)] -> ([a], [b], [c]))
unzip3 v480 ps
  = (foldr v480
       ((B.fu2
	   (\ v481@(a, b, c) v482@(~(as, bs, cs)) ->
	      ((:) a as, (:) b bs, (:) c cs))))
       ([], [], [])
       ps)
 
userError :: B.D ([Char] -> IOError)
userError v483 s = (Prims_B.primUserError v483 s)
 
words :: B.D ([Char] -> [[Char]])
words v485 s
  = let v119 = \ v487 -> (dropWhile v487 (B.fu1 (isSpace v487)) s) in
      let v120
	    = \ v489 ->
		case (v119 v489) of
		   s' -> let v491 = \ v490 -> (break v490 (B.fu1 (isSpace v490)) s')
			     w = \ v492 -> (\ (w, s'') -> w) (v491 v492)
			     s'' = \ v493 -> (\ (w, s'') -> s'') (v491 v493)
			   in (:) (w v489) ((words v489 (s'' v489)))
		   _ -> (Prelude_B.error v489 "No Match")
	in
	case ((Prelude_B.==) v485 (v119 v485) "") of
	   True -> []
	   False -> (v120 v485)
  where
     isSpace v484 c = (elem v484 c " \t\n\r\f\v\160")
 
zip :: B.D ([a] -> [b] -> [(a, b)])
zip v494 xs ys = (zipWith v494 ((B.fu2 (\ a b -> (a, b)))) xs ys)
 
zip3 :: B.D ([a] -> [b] -> [c] -> [(a, b, c)])
zip3 v495 xs ys zs
  = (zipWith3 v495 ((B.fu3 (\ x y z -> (x, y, z)))) xs ys zs)
 
zipWith :: B.D (B.F a (B.F b c) -> [a] -> [b] -> [c])
zipWith v496 v121 v122 v123
  = case (v121, v122, v123) of
       (z, (a : as), (b : bs)) -> (:) ((B.app (B.app z a) b))
				    ((zipWith v496 z as bs))
       (x, y, z) -> []
 
zipWith3 ::
	   B.D (B.F a (B.F b (B.F c d)) -> [a] -> [b] -> [c] -> [d])
zipWith3 v497 v124 v125 v126 v127
  = case (v124, v125, v126, v127) of
       (z, (a : as), (b : bs), (c : cs)) -> (:)
					      ((B.app (B.app (B.app z a) b) c))
					      ((zipWith3 v497 z as bs cs))
       (_, _, _, _) -> []
 
class Eq a where
    
   (==), (/=) :: B.D (a -> a -> Bool)
   (v498 /= x) y = (not v498 (((==) v498 x y)))
   (v499 == x) y = (not v499 (((/=) v499 x y)))
 
instance Eq Char where
   (v500 == x) y = (Prims_B.primEqChar v500 x y)
 
instance Eq Int where
   (v501 == x) y = (Prims_B.primEqInt v501 x y)
 
instance Eq Integer where
   (v502 == x) y = (Prims_B.primEqInteger v502 x y)
 
instance Eq Float where
   (v503 == x) y = (Prims_B.primEqFloat v503 x y)
 
instance Eq Double where
   (v504 == x) y = (Prims_B.primEqDouble v504 x y)
 
instance Eq IOError where
   (v505 == x) y = (Prims_B.primEqIOError v505 x y)
 
instance Eq () where
   (v506 == v129) v128
     = case (v129, v128) of
	  ((), ()) -> True
 
instance Eq Bool where
   (v507 == v130) v131
     = case (v130, v131) of
	  (True, True) -> True
	  (False, False) -> True
	  (_, _) -> False
 
instance (Eq a) => Eq [a] where
   (v508 == v132) v133
     = case (v132, v133) of
	  ([], []) -> True
	  ((x : xs), (y : ys)) -> ((&&) v508 (((==) v508 x y))
				     (((==) v508 xs ys)))
	  (_, _) -> False
 
instance (Eq a) => Eq (Maybe a) where
   (v509 == v134) v135
     = case (v134, v135) of
	  (Nothing, Nothing) -> True
	  ((Just x), (Just y)) -> ((==) v509 x y)
	  (_, _) -> False
 
instance (Eq a, Eq b) => Eq (Either a b) where
   (v510 == v136) v137
     = case (v136, v137) of
	  (Left x, Left y) -> ((==) v510 x y)
	  (Right x, Right y) -> ((==) v510 x y)
	  (_, _) -> False
 
instance Eq Ordering where
   (v511 == v138) v139
     = case (v138, v139) of
	  (GT, GT) -> True
	  (LT, LT) -> True
	  (EQ, EQ) -> True
	  (_, _) -> False
 
class (Eq a) => Ord a where
    
   compare :: B.D (a -> a -> Ordering)
    
   (<), (<=), (>=), (>) :: B.D (a -> a -> Bool)
    
   max, min :: B.D (a -> a -> a)
   compare v512 x y
     = case ((==) v512 x y) of
	  True -> EQ
	  False -> case ((<=) v512 x y) of
		      True -> LT
		      False -> case (otherwise v512) of
				  True -> GT
   (v513 <= x) y = ((/=) v513 ((compare v513 x y)) GT)
   (v514 < x) y = ((==) v514 ((compare v514 x y)) LT)
   (v515 >= x) y = ((/=) v515 ((compare v515 x y)) LT)
   (v516 > x) y = ((==) v516 ((compare v516 x y)) GT)
   max v517 x y
     = case ((>=) v517 x y) of
	  True -> x
	  False -> case (otherwise v517) of
		      True -> y
   min v518 x y
     = case ((<) v518 x y) of
	  True -> x
	  False -> case (otherwise v518) of
		      True -> y
 
instance Ord Char where
   (v519 <= x) y = (Prims_B.primLteChar v519 x y)
 
instance Ord Int where
   (v520 <= x) y = (Prims_B.primLteInt v520 x y)
 
instance Ord Integer where
   (v521 <= x) y = (Prims_B.primLteInteger v521 x y)
 
instance Ord Float where
   (v522 <= x) y = (Prims_B.primLteFloat v522 x y)
 
instance Ord Double where
   (v523 <= x) y = (Prims_B.primLteDouble v523 x y)
 
instance Ord () where
   (v524 <= v141) v140
     = case (v141, v140) of
	  ((), ()) -> True
 
instance Ord Bool where
   (v525 <= v142) v143
     = case (v142, v143) of
	  (False, _) -> True
	  (True, True) -> True
	  (True, False) -> False
 
instance (Ord a) => Ord [a] where
   (v526 <= v144) v145
     = case (v144, v145) of
	  ([], _) -> True
	  ((x : xs), (y : ys)) -> ((||) v526 (((<) v526 x y))
				     (((&&) v526 (((==) v526 x y)) (((<=) v526 xs ys)))))
	  ((_ : _), []) -> False
 
instance (Ord a) => Ord (Maybe a) where
   (v527 <= v146) v147
     = case (v146, v147) of
	  (Nothing, _) -> True
	  ((Just x), (Just y)) -> ((<=) v527 x y)
 
instance (Ord a, Ord b) => Ord (Either a b) where
   (v528 <= v148) v149
     = case (v148, v149) of
	  (Left x, Left y) -> ((<=) v528 x y)
	  (Left x, Right y) -> False
	  (Right x, Right y) -> ((<=) v528 x y)
 
instance Ord Ordering where
   (v529 <= v150) v151
     = case (v150, v151) of
	  (LT, _) -> True
	  (EQ, LT) -> False
	  (EQ, GT) -> True
	  (GT, GT) -> True
	  (GT, _) -> False
 
class Enum a where
    
   succ, pred :: B.D (a -> a)
    
   toEnum :: B.D (Int -> a)
    
   fromEnum :: B.D (a -> Int)
    
   enumFrom :: B.D (a -> [a])
    
   enumFromThen :: B.D (a -> a -> [a])
    
   enumFromTo :: B.D (a -> a -> [a])
    
   enumFromThenTo :: B.D (a -> a -> a -> [a])
   succ v531 v530
     = ((.) v531 (B.fu1 (toEnum v531))
	  ((B.fu1
	      ((.) v531 ((B.fu1 (\ v152 -> ((+) v531 v152 1))))
		 (B.fu1 (fromEnum v531)))))
	  v530)
   pred v533 v532
     = ((.) v533 (B.fu1 (toEnum v533))
	  ((B.fu1
	      ((.) v533 ((B.fu1 (subtract v533 1))) (B.fu1 (fromEnum v533)))))
	  v532)
   enumFrom v534 x
     = (map v534 (B.fu1 (toEnum v534))
	  (Prelude_B.enumFrom v534 ((fromEnum v534 x))))
   enumFromTo v535 x y
     = (map v535 (B.fu1 (toEnum v535))
	  (Prelude_B.enumFromTo v535 (fromEnum v535 x) (fromEnum v535 y)))
   enumFromThenTo v536 x y z
     = (map v536 (B.fu1 (toEnum v536))
	  (Prelude_B.enumFromThenTo v536 (fromEnum v536 x) (fromEnum v536 y)
	     (fromEnum v536 z)))
 
instance Enum Char where
   fromEnum v537 x = (Prims_B.primFromEnumChar v537 x)
   toEnum v538 x = (Prims_B.primToEnumChar v538 x)
   enumFrom v539 c
     = (map v539 (B.fu1 (toEnum v539))
	  (Prelude_B.enumFromTo v539 (fromEnum v539 c)
	     (fromEnum v539 ((maxBound v539) :: Char))))
   enumFromThen v541 c d
     = (map v541 (B.fu1 (toEnum v541))
	  (Prelude_B.enumFromThenTo v541 (fromEnum v541 c) (fromEnum v541 d)
	     (fromEnum v541 ((lastChar v541) :: Char))))
     where
	lastChar
	  = \ v540 ->
	      case ((<) v540 d c) of
		 True -> (minBound v540)
		 False -> (maxBound v540)
 
instance Enum Int where
   fromEnum v542 x = (id v542 x)
   toEnum v543 x = (id v543 x)
   enumFrom v544 x = (Prims_B.primEnumFromInt v544 x)
   enumFromTo v545 x y = (Prims_B.primEnumFromToInt v545 x y)
   enumFromThen v546 x y = (Prims_B.primEnumFromThenInt v546 x y)
   enumFromThenTo v547 x y z
     = (Prims_B.primEnumFromThenToInt v547 x y z)
 
instance Enum Integer where
   fromEnum v548 x = (Prims_B.primFromEnumInteger v548 x)
   toEnum v549 x = (Prims_B.primToEnumInteger v549 x)
   enumFrom v550 x = (Prims_B.primEnumFromInteger v550 x)
   enumFromTo v551 x y = (Prims_B.primEnumFromToInteger v551 x y)
   enumFromThen v552 x y = (Prims_B.primEnumFromThenInteger v552 x y)
   enumFromThenTo v553 x y z
     = (Prims_B.primEnumFromThenToInteger v553 x y z)
 
instance Enum Float where
   fromEnum v554 x = (Prims_B.primFromEnumFloat v554 x)
   toEnum v555 x = (Prims_B.primToEnumFloat v555 x)
   enumFrom v556 x = (Prims_B.primEnumFromFloat v556 x)
   enumFromTo v557 x y = (Prims_B.primEnumFromToFloat v557 x y)
   enumFromThen v558 x y = (Prims_B.primEnumFromThenFloat v558 x y)
   enumFromThenTo v559 x y z
     = (Prims_B.primEnumFromThenToFloat v559 x y z)
 
instance Enum Double where
   fromEnum v560 x = (Prims_B.primFromEnumDouble v560 x)
   toEnum v561 x = (Prims_B.primToEnumDouble v561 x)
   enumFrom v562 x = (Prims_B.primEnumFromDouble v562 x)
   enumFromTo v563 x y = (Prims_B.primEnumFromToDouble v563 x y)
   enumFromThen v564 x y = (Prims_B.primEnumFromThenDouble v564 x y)
   enumFromThenTo v565 x y z
     = (Prims_B.primEnumFromThenToDouble v565 x y z)
 
instance Enum () where
   toEnum v566 v153
     = let v154 = \ v568 -> (Prelude_B.error v568 "No Match") in
	 case ((Prelude_B.==) v566 v153 0) of
	    True -> ()
	    False -> (v154 v566)
   fromEnum v569 v155
     = case v155 of
	  () -> 0
   enumFrom v570 v156
     = case v156 of
	  () -> [()]
   enumFromThen v571 v158 v157
     = case (v158, v157) of
	  ((), ()) -> [()]
 
instance Enum Bool where
   fromEnum v572 v159
     = case v159 of
	  False -> 0
	  True -> 1
   toEnum v573 v160
     = let v161
	     = \ v575 ->
		 let v162 = \ v577 -> (Prelude_B.error v577 "No Match") in
		   case ((Prelude_B.==) v575 v160 1) of
		      True -> True
		      False -> (v162 v575)
	 in
	 case ((Prelude_B.==) v573 v160 0) of
	    True -> False
	    False -> (v161 v573)
   enumFrom v578 x
     = (map v578 (B.fu1 (toEnum v578))
	  (Prelude_B.enumFromTo v578 (fromEnum v578 x)
	     (fromEnum v578 ((maxBound v578) :: Bool))))
   enumFromThen v580 x y
     = (map v580 (B.fu1 (toEnum v580))
	  (Prelude_B.enumFromThenTo v580 (fromEnum v580 x) (fromEnum v580 y)
	     (fromEnum v580 ((lastBool v580) :: Bool))))
     where
	lastBool
	  = \ v579 ->
	      case ((<) v579 y x) of
		 True -> (minBound v579)
		 False -> (maxBound v579)
 
instance Enum Ordering where
   fromEnum v581 v163
     = case v163 of
	  LT -> 0
	  EQ -> 1
	  GT -> 2
   toEnum v582 v164
     = let v165
	     = \ v584 ->
		 let v166
		       = \ v586 ->
			   let v167 = \ v588 -> (Prelude_B.error v588 "No Match") in
			     case ((Prelude_B.==) v586 v164 2) of
				True -> GT
				False -> (v167 v586)
		   in
		   case ((Prelude_B.==) v584 v164 1) of
		      True -> EQ
		      False -> (v166 v584)
	 in
	 case ((Prelude_B.==) v582 v164 0) of
	    True -> LT
	    False -> (v165 v582)
   enumFrom v589 x
     = (map v589 (B.fu1 (toEnum v589))
	  (Prelude_B.enumFromTo v589 (fromEnum v589 x)
	     (fromEnum v589 ((maxBound v589) :: Ordering))))
   enumFromThen v591 x y
     = (map v591 (B.fu1 (toEnum v591))
	  (Prelude_B.enumFromThenTo v591 (fromEnum v591 x) (fromEnum v591 y)
	     (fromEnum v591 ((lastOrdering v591) :: Bool))))
     where
	lastOrdering
	  = \ v590 ->
	      case ((<) v590 y x) of
		 True -> (minBound v590)
		 False -> (maxBound v590)
 
class Bounded a where
    
   minBound :: B.D a
    
   maxBound :: B.D a
 
instance Bounded () where
   minBound = \ v592 -> ()
   maxBound = \ v593 -> ()
 
instance Bounded Char where
   minBound = \ v594 -> '\NUL'
   maxBound = \ v595 -> '\255'
 
instance Bounded Int where
   minBound = \ v596 -> (Prims_B.primMinInt v596)
   maxBound = \ v597 -> (Prims_B.primMaxInt v597)
 
instance Bounded Bool where
   minBound = \ v598 -> False
   maxBound = \ v599 -> True
 
instance Bounded Ordering where
   minBound = \ v600 -> LT
   maxBound = \ v601 -> GT
 
class Functor f where
    
   fmap :: B.D (B.F a b -> f a -> f b)
 
instance Functor IO where
   fmap v602 f x
     = ((>>=) v602 x ((B.fu1 ((.) v602 (B.fu1 (return v602)) f))))
 
instance Functor Maybe where
   fmap v603 v168 v169
     = case (v168, v169) of
	  (f, Nothing) -> Nothing
	  (f, (Just x)) -> Just ((B.app f x))
 
instance Functor [] where
   fmap v606 v604 v605 = (map v606 v604 v605)
 
class Monad m where
    
   (>>=) :: B.D (m a -> B.F a (m b) -> m b)
    
   (>>) :: B.D (m a -> m b -> m b)
    
   return :: B.D (a -> m a)
    
   fail :: B.D ([Char] -> m a)
   (v607 >> m) k = ((>>=) v607 m ((B.fu1 (\ v608@_ -> k))))
   fail v609 s = (error v609 s)
 
instance Monad IO where
   return v610 x = MkIO ((B.fio (\ state -> Right (state, x))))
   (v611 >> io1) io2 = ((>>=) v611 io1 ((B.fu1 (\ v612@_ -> io2))))
   (v613 >>= io) next
     = case (tryIO v613 io) of
	  MkIO m -> MkIO
		      ((B.fio
			  (\ state ->
			     case (B.app m state) of
				Left e -> Left e
				Right (newState, a) -> case (tryIO v613 ((B.app next a))) of
							  MkIO last -> (B.app last newState))))
 
instance Monad Maybe where
   (v614 >>= v170) v171
     = case (v170, v171) of
	  ((Just x), k) -> (B.app k x)
	  (Nothing, k) -> Nothing
   return v616 v615 = Just v615
   fail v617 s = Nothing
 
instance Monad [] where
   (v618 >>= m) k = (concatMap v618 k m)
   return v619 x = [x]
   fail v620 s = []
 
class Show a where
    
   showsPrec :: B.D (Int -> a -> [Char] -> [Char])
    
   show :: B.D (a -> [Char])
    
   showList :: B.D ([a] -> [Char] -> [Char])
   showsPrec v622 v621@_ x s = ((++) v622 ((show v622 x)) s)
   show v623 x = (showsPrec v623 0 x "")
   showList v625 v172 v624
     = case v172 of
	  [] -> (showString v625 "[]" v624)
	  (x : xs) -> let showl v626 v173
			    = case v173 of
				 [] -> (B.fu1 (showChar v626 ']'))
				 (x : xs) -> (B.fu1
						((.) v626 ((B.fu1 (showChar v626 ',')))
						   ((B.fu1
						       ((.) v626 ((B.fu1 (shows v626 x)))
							  ((showl v626 xs)))))))
			in
			((.) v625 ((B.fu1 (showChar v625 '[')))
			   ((B.fu1 ((.) v625 ((B.fu1 (shows v625 x))) ((showl v625 xs)))))
			   v624)
 
instance Show () where
   showsPrec v628 p v174 v627
     = case v174 of
	  () -> (showString v628 "()" v627)
 
instance Show Bool where
   showsPrec v630 v175 v176 v629
     = case (v175, v176) of
	  (p, True) -> (showString v630 "True" v629)
	  (p, False) -> (showString v630 "False" v629)
 
instance Show Ordering where
   showsPrec v632 v177 v178 v631
     = case (v177, v178) of
	  (p, LT) -> (showString v632 "LT" v631)
	  (p, EQ) -> (showString v632 "EQ" v631)
	  (p, GT) -> (showString v632 "GT" v631)
 
instance (Show a) => Show (Maybe a) where
   showsPrec v634 v179 v180 v633
     = case (v179, v180) of
	  (p, Nothing) -> (showString v634 "Nothing" v633)
	  (p, (Just x)) -> ((.) v634
			      ((B.fu1
				  (showParen v634 (((>=) v634 p 10))
				     ((B.fu1 (showString v634 "Just "))))))
			      ((B.fu1 (showsPrec v634 10 x)))
			      v633)
 
instance (Show a) => Show [a] where
   showsPrec v637 p v635 v636 = (showList v637 v635 v636)
 
instance (Show a, Show b) => Show (Either a b) where
   showsPrec v639 v181 v182 v638
     = case (v181, v182) of
	  (p, (Left x)) -> ((.) v639
			      ((B.fu1
				  (showParen v639 (((>=) v639 p 10))
				     ((B.fu1 (showString v639 "Left "))))))
			      ((B.fu1 (showsPrec v639 10 x)))
			      v638)
	  (p, (Right x)) -> ((.) v639
			       ((B.fu1
				   (showParen v639 (((>=) v639 p 10))
				      ((B.fu1 (showString v639 "Right "))))))
			       ((B.fu1 (showsPrec v639 10 x)))
			       v638)
 
instance Show Char where
   showsPrec v641 v183 v184 v640
     = let v185 = \ v643 -> (v183, v184) in
	 let v186
	       = \ v645 ->
		   case (v185 v645) of
		      (p, c) -> (B.fu1
				   ((.) v645 ((B.fu1 (showChar v645 '\'')))
				      ((B.fu1
					  ((.) v645 ((B.fu1 (Prims_B.primShowLitChar v645 c)))
					     ((B.fu1 (showChar v645 '\''))))))))
		      _ -> (Prelude_B.error v645 "No Match")
	   in
	   case (v185 v641) of
	      (p, v187) -> case ((Prelude_B.==) v641 v187 '\'') of
			      True -> (showString v641 "'\\''" v640)
			      False -> (B.app (v186 v641) v640)
	      _ -> (B.app (v186 v641) v640)
   showList v652 cs v646
     = ((.) v652 ((B.fu1 (showChar v652 '"'))) ((showl v652 cs)) v646)
     where
	showl v647 v188
	  = let v189
		  = \ v649 ->
		      let v190
			    = \ v651 ->
				case v188 of
				   (c : cs) -> (B.fu1
						  ((.) v651
						     ((B.fu1 (Prims_B.primShowLitChar v651 c)))
						     ((showl v651 cs))))
				   _ -> (Prelude_B.error v651 "No Match")
			in
			case v188 of
			   (v191 : cs) -> case ((Prelude_B.==) v649 v191 '"') of
					     True -> (B.fu1
							((.) v649 ((B.fu1 (showString v649 "\\\"")))
							   ((showl v649 cs))))
					     False -> (v190 v649)
			   _ -> (v190 v649)
	      in
	      case ((Prelude_B.==) v647 v188 "") of
		 True -> (B.fu1 (showChar v647 '"'))
		 False -> (v189 v647)
 
instance Show Int where
   showsPrec v654 p c v653 = (Prims_B.primShowsPrecInt v654 p c v653)
 
instance Show Integer where
   showsPrec v656 p c v655
     = (Prims_B.primShowsPrecInteger v656 p c v655)
 
instance Show Float where
   showsPrec v658 p c v657
     = (Prims_B.primShowsPrecFloat v658 p c v657)
 
instance Show Double where
   showsPrec v660 p c v659
     = (Prims_B.primShowsPrecDouble v660 p c v659)
 
instance Show IOError where
   showsPrec v662 p c v661
     = (Prims_B.primShowsPrecIOError v662 p c v661)
 
class (Eq a, Show a) => Num a where
   fromInteger :: Integer -> a
   negate :: a -> a
   fromInteger i = fromInteger_bUdDhA (-1) i
    
   (+), (-), (*) :: B.D (a -> a -> a)
    
   negate_bUdDhA :: B.D (a -> a)
    
   abs, signum :: B.D (a -> a)
    
   fromInteger_bUdDhA :: B.D (Integer -> a)
   (v663 - x) y = ((+) v663 x ((negate_bUdDhA v663 y)))
   negate_bUdDhA v664 x = ((-) v664 0 x)
 
instance Num Int where
   fromInteger x = Prims_B.prim_No_Debug_fromIntegerInt x
   negate x = Prims_B.prim_No_Debug_negateInt x
   (v665 + x) y = (Prims_B.primPlusInt v665 x y)
   (v666 - x) y = (Prims_B.primMinusInt v666 x y)
   (v667 * x) y = (Prims_B.primMulInt v667 x y)
   negate_bUdDhA v668 x = (Prims_B.primNegateInt v668 x)
   abs v669 x = (Prims_B.primAbsInt v669 x)
   signum v670 x = (Prims_B.primSigNumInt v670 x)
   fromInteger_bUdDhA v671 x = (Prims_B.primFromIntegerInt v671 x)
 
instance Num Integer where
   fromInteger x = Prims_B.prim_No_Debug_fromIntegerInteger x
   negate x = Prims_B.prim_No_Debug_negateInteger x
   (v672 + x) y = (Prims_B.primPlusInteger v672 x y)
   (v673 - x) y = (Prims_B.primMinusInteger v673 x y)
   (v674 * x) y = (Prims_B.primMulInteger v674 x y)
   negate_bUdDhA v675 x = (Prims_B.primNegateInteger v675 x)
   abs v676 x = (Prims_B.primAbsInteger v676 x)
   signum v677 x = (Prims_B.primSigNumInteger v677 x)
   fromInteger_bUdDhA v678 x = (Prims_B.primFromIntegerInteger v678 x)
 
instance Num Float where
   fromInteger x = Prims_B.prim_No_Debug_fromIntegerFloat x
   negate x = Prims_B.prim_No_Debug_negateFloat x
   (v679 + x) y = (Prims_B.primPlusFloat v679 x y)
   (v680 - x) y = (Prims_B.primMinusFloat v680 x y)
   (v681 * x) y = (Prims_B.primMulFloat v681 x y)
   negate_bUdDhA v682 x = (Prims_B.primNegateFloat v682 x)
   abs v683 x = (Prims_B.primAbsFloat v683 x)
   signum v684 x = (Prims_B.primSigNumFloat v684 x)
   fromInteger_bUdDhA v685 x = (Prims_B.primFromIntegerFloat v685 x)
 
instance Num Double where
   fromInteger x = Prims_B.prim_No_Debug_fromIntegerDouble x
   negate x = Prims_B.prim_No_Debug_negateDouble x
   (v686 + x) y = (Prims_B.primPlusDouble v686 x y)
   (v687 - x) y = (Prims_B.primMinusDouble v687 x y)
   (v688 * x) y = (Prims_B.primMulDouble v688 x y)
   negate_bUdDhA v689 x = (Prims_B.primNegateDouble v689 x)
   abs v690 x = (Prims_B.primAbsDouble v690 x)
   signum v691 x = (Prims_B.primSigNumDouble v691 x)
   fromInteger_bUdDhA v692 x = (Prims_B.primFromIntegerDouble v692 x)
 
class (Num a, Ord a) => Real a where
    
   toRational :: B.D (a -> Rational)
 
instance Real Integer where
   toRational v693 x = (Prims_B.primToRationalInteger v693 x)
 
instance Real Int where
   toRational v694 x = (Prims_B.primToRationalInt v694 x)
 
instance Real Float where
   toRational v695 x = (Prims_B.primToRationalFloat v695 x)
 
instance Real Double where
   toRational v696 x = (Prims_B.primToRationalDouble v696 x)
 
class (Real a, Enum a) => Integral a where
    
   quot, rem :: B.D (a -> a -> a)
    
   div, mod :: B.D (a -> a -> a)
    
   quotRem, divMod :: B.D (a -> a -> (a, a))
    
   toInteger :: B.D (a -> Integer)
   quot v701 n d = (q v701)
     where
	v698 = \ v697 -> (quotRem v697 n d)
	q = \ v699 -> (\ (q, r) -> q) (v698 v699)
	r = \ v700 -> (\ (q, r) -> r) (v698 v700)
   rem v706 n d = (r v706)
     where
	v703 = \ v702 -> (quotRem v702 n d)
	q = \ v704 -> (\ (q, r) -> q) (v703 v704)
	r = \ v705 -> (\ (q, r) -> r) (v703 v705)
   div v711 n d = (q v711)
     where
	v708 = \ v707 -> (divMod v707 n d)
	q = \ v709 -> (\ (q, r) -> q) (v708 v709)
	r = \ v710 -> (\ (q, r) -> r) (v708 v710)
   mod v716 n d = (r v716)
     where
	v713 = \ v712 -> (divMod v712 n d)
	q = \ v714 -> (\ (q, r) -> q) (v713 v714)
	r = \ v715 -> (\ (q, r) -> r) (v713 v715)
   divMod v722 n d
     = case
	 ((==) v722 ((signum v722 (r v722)))
	    ((Prelude_B.negate_bUdDhA v722 (signum v722 d))))
	 of
	  True -> (((-) v722 (q v722) 1), ((+) v722 (r v722) d))
	  False -> (qr v722)
     where
	v718 = \ v717 -> (quotRem v717 n d)
	qr = \ v719 -> (\ qr@(q, r) -> qr) (v718 v719)
	q = \ v720 -> (\ qr@(q, r) -> q) (v718 v720)
	r = \ v721 -> (\ qr@(q, r) -> r) (v718 v721)
 
instance Integral Int where
   div v723 x y = (Prims_B.primDivInt v723 x y)
   quot v724 x y = (Prims_B.primQuotInt v724 x y)
   rem v725 x y = (Prims_B.primRemInt v725 x y)
   mod v726 x y = (Prims_B.primModInt v726 x y)
   quotRem v727 x y = (Prims_B.primQuotRemInt v727 x y)
   toInteger v728 x = (Prims_B.primToIntegerInt v728 x)
 
instance Integral Integer where
   div v729 x y = (Prims_B.primDivInteger v729 x y)
   quot v730 x y = (Prims_B.primQuotInteger v730 x y)
   rem v731 x y = (Prims_B.primRemInteger v731 x y)
   mod v732 x y = (Prims_B.primModInteger v732 x y)
   quotRem v733 x y = (Prims_B.primQuotRemInteger v733 x y)
   toInteger v734 x = (Prims_B.primToIntegerInteger v734 x)
 
class (Num a) => Fractional a where
   fromRational :: Rational -> a 
   fromRational r = fromRational_bUdDhA (-1) r
    
   (/) :: B.D (a -> a -> a)
    
   recip :: B.D (a -> a)
    
   fromRational_bUdDhA :: B.D (Rational -> a)
   recip v735 x = ((/) v735 1 x)
   (v736 / x) y = ((*) v736 x ((recip v736 y)))
 
instance Fractional Float where
   fromRational x = Prims_B.prim_No_Debug_fromRationalFloat x
   (v737 / x) y = (Prims_B.primDivideFloat v737 x y)
   fromRational_bUdDhA v738 x = (Prims_B.primFromRationalFloat v738 x)
 
instance Fractional Double where
   fromRational x = Prims_B.prim_No_Debug_fromRationalDouble x 
   (v739 / x) y = (Prims_B.primDivideDouble v739 x y)
   fromRational_bUdDhA v740 x
     = (Prims_B.primFromRationalDouble v740 x)
 
class (Fractional a) => Floating a where
    
   pi :: B.D a
    
   exp, log, sqrt :: B.D (a -> a)
    
   (**), logBase :: B.D (a -> a -> a)
    
   sin, cos, tan :: B.D (a -> a)
    
   asin, acos, atan :: B.D (a -> a)
    
   sinh, cosh, tanh :: B.D (a -> a)
    
   asinh, acosh, atanh :: B.D (a -> a)
   (v741 ** x) y = (exp v741 (((*) v741 ((log v741 x)) y)))
   logBase v742 x y = ((/) v742 ((log v742 y)) ((log v742 x)))
   sqrt v743 x = ((**) v743 x (0.5))
   tan v744 x = ((/) v744 ((sin v744 x)) ((cos v744 x)))
   tanh v745 x = ((/) v745 ((sinh v745 x)) ((cosh v745 x)))
 
instance Floating Float where
   pi = \ v746 -> (Prims_B.primPiFloat v746)
   exp v747 x = (Prims_B.primExpFloat v747 x)
   log v748 x = (Prims_B.primLogFloat v748 x)
   sin v749 x = (Prims_B.primSinFloat v749 x)
   cos v750 x = (Prims_B.primCosFloat v750 x)
   sinh v751 x = (Prims_B.primSinhFloat v751 x)
   cosh v752 x = (Prims_B.primCoshFloat v752 x)
   asin v753 x = (Prims_B.primAsinFloat v753 x)
   acos v754 x = (Prims_B.primAcosFloat v754 x)
   atan v755 x = (Prims_B.primAtanFloat v755 x)
   asinh v756 x = (Prims_B.primAsinhFloat v756 x)
   acosh v757 x = (Prims_B.primAcoshFloat v757 x)
   atanh v758 x = (Prims_B.primAtanhFloat v758 x)
 
instance Floating Double where
   pi = \ v759 -> (Prims_B.primPiDouble v759)
   exp v760 x = (Prims_B.primExpDouble v760 x)
   log v761 x = (Prims_B.primLogDouble v761 x)
   sin v762 x = (Prims_B.primSinDouble v762 x)
   cos v763 x = (Prims_B.primCosDouble v763 x)
   sinh v764 x = (Prims_B.primSinhDouble v764 x)
   cosh v765 x = (Prims_B.primCoshDouble v765 x)
   asin v766 x = (Prims_B.primAsinDouble v766 x)
   acos v767 x = (Prims_B.primAcosDouble v767 x)
   atan v768 x = (Prims_B.primAtanDouble v768 x)
   asinh v769 x = (Prims_B.primAsinhDouble v769 x)
   acosh v770 x = (Prims_B.primAcoshDouble v770 x)
   atanh v771 x = (Prims_B.primAtanhDouble v771 x)
 
class (Real a, Fractional a) => RealFrac a where
    
   properFraction :: (Integral b) => B.D (a -> (b, a))
    
   truncate, round :: (Integral b) => B.D (a -> b)
    
   ceiling, floor :: (Integral b) => B.D (a -> b)
   truncate v776 x = (m v776)
     where
	v773 = \ v772 -> (properFraction v772 x)
	m = \ v774 -> (\ (m, z) -> m) (v773 v774)
	z = \ v775 -> (\ (m, z) -> z) (v773 v775)
   round v777 x
     = let v779 = \ v778 -> (properFraction v778 x)
	   n = \ v780 -> (\ (n, r) -> n) (v779 v780)
	   r = \ v781 -> (\ (n, r) -> r) (v779 v781)
	   m = \ v782 ->
		 case ((<) v782 (r v782) 0) of
		    True -> ((-) v782 (n v782) 1)
		    False -> ((+) v782 (n v782) 1)
	 in
	 case
	   (compare v777
	      ((signum v777 (((-) v777 ((abs v777 (r v777))) (0.5)))))
	      0)
	   of
	    LT -> (n v777)
	    EQ -> case (even v777 (n v777)) of
		     True -> (n v777)
		     False -> (m v777)
	    GT -> (m v777)
   ceiling v787 x
     = case ((>) v787 (r v787) 0) of
	  True -> ((+) v787 (n v787) 1)
	  False -> (n v787)
     where
	v784 = \ v783 -> (properFraction v783 x)
	n = \ v785 -> (\ (n, r) -> n) (v784 v785)
	r = \ v786 -> (\ (n, r) -> r) (v784 v786)
   floor v792 x
     = case ((<) v792 (r v792) 0) of
	  True -> ((-) v792 (n v792) 1)
	  False -> (n v792)
     where
	v789 = \ v788 -> (properFraction v788 x)
	n = \ v790 -> (\ (n, r) -> n) (v789 v790)
	r = \ v791 -> (\ (n, r) -> r) (v789 v791)
 
instance RealFrac Float where
   properFraction v793 x = (floatProperFraction v793 x)
 
instance RealFrac Double where
   properFraction v794 x = (floatProperFraction v794 x)
floatProperFraction v804 x
  = case ((>=) v804 (n v804) 0) of
       True -> (((*) v804 ((fromInteger_bUdDhA v804 (m v804)))
		   (((^) v804 ((fromInteger_bUdDhA v804 (b v804))) (n v804)))),
		0)
       False -> case (otherwise v804) of
		   True -> ((fromInteger_bUdDhA v804 (w v804)),
			    (encodeFloat v804 (r v804) (n v804)))
  where
     v796 = \ v795 -> (decodeFloat v795 x)
     m = \ v797 -> (\ (m, n) -> m) (v796 v797)
     n = \ v798 -> (\ (m, n) -> n) (v796 v798)
     b = \ v799 -> (floatRadix v799 x)
     v801
       = \ v800 ->
	   (quotRem v800 (m v800)
	      (((^) v800 (b v800) ((Prelude_B.negate_bUdDhA v800 (n v800))))))
     w = \ v802 -> (\ (w, r) -> w) (v801 v802)
     r = \ v803 -> (\ (w, r) -> r) (v801 v803)
 
class (RealFrac a, Floating a) => RealFloat a where
    
   floatRadix :: B.D (a -> Integer)
    
   floatDigits :: B.D (a -> Int)
    
   floatRange :: B.D (a -> (Int, Int))
    
   decodeFloat :: B.D (a -> (Integer, Int))
    
   encodeFloat :: B.D (Integer -> Int -> a)
    
   exponent :: B.D (a -> Int)
    
   significand :: B.D (a -> a)
    
   scaleFloat :: B.D (Int -> a -> a)
    
   isNaN, isInfinite, isDenormalized, isNegativeZero, isIEEE ::
	    B.D (a -> Bool)
    
   atan2 :: B.D (a -> a -> a)
   exponent v809 x
     = case ((==) v809 (m v809) 0) of
	  True -> 0
	  False -> ((+) v809 (n v809) ((floatDigits v809 x)))
     where
	v806 = \ v805 -> (decodeFloat v805 x)
	m = \ v807 -> (\ (m, n) -> m) (v806 v807)
	n = \ v808 -> (\ (m, n) -> n) (v806 v808)
   significand v814 x
     = (encodeFloat v814 (m v814)
	  ((Prelude_B.negate_bUdDhA v814 ((floatDigits v814 x)))))
     where
	v811 = \ v810 -> (decodeFloat v810 x)
	m = \ v812 -> (\ (m, n) -> m) (v811 v812)
	n = \ v813 -> (\ (m, n) -> n) (v811 v813)
   scaleFloat v819 k x
     = (encodeFloat v819 (m v819) (((+) v819 (n v819) k)))
     where
	v816 = \ v815 -> (decodeFloat v815 x)
	m = \ v817 -> (\ (m, n) -> m) (v816 v817)
	n = \ v818 -> (\ (m, n) -> n) (v816 v818)
 
instance RealFloat Float where
   floatRadix v820 x = (Prims_B.primFloatRadixFloat v820 x)
   floatDigits v821 x = (Prims_B.primFloatDigitsFloat v821 x)
   floatRange v822 x = (Prims_B.primFloatRangeFloat v822 x)
   decodeFloat v823 x = (Prims_B.primDecodeFloatFloat v823 x)
   encodeFloat v824 x y = (Prims_B.primEncodeFloatFloat v824 x y)
   isNaN v825 x = (Prims_B.primIsNaNFloat v825 x)
   isInfinite v826 x = (Prims_B.primIsInfiniteFloat v826 x)
   isDenormalized v827 x = (Prims_B.primIsDenormalizedFloat v827 x)
   isNegativeZero v828 x = (Prims_B.primIsNegativeZeroFloat v828 x)
   isIEEE v829 x = (Prims_B.primIsIEEEFloat v829 x)
   atan2 v830 x y = (Prims_B.primATan2Float v830 x y)
 
instance RealFloat Double where
   floatRadix v831 x = (Prims_B.primFloatRadixDouble v831 x)
   floatDigits v832 x = (Prims_B.primFloatDigitsDouble v832 x)
   floatRange v833 x = (Prims_B.primFloatRangeDouble v833 x)
   decodeFloat v834 x = (Prims_B.primDecodeFloatDouble v834 x)
   encodeFloat v835 x y = (Prims_B.primEncodeFloatDouble v835 x y)
   isNaN v836 x = (Prims_B.primIsNaNDouble v836 x)
   isInfinite v837 x = (Prims_B.primIsInfiniteDouble v837 x)
   isDenormalized v838 x = (Prims_B.primIsDenormalizedDouble v838 x)
   isNegativeZero v839 x = (Prims_B.primIsNegativeZeroDouble v839 x)
   isIEEE v840 x = (Prims_B.primIsIEEEDouble v840 x)
   atan2 v841 x y = (Prims_B.primATan2Double v841 x y)
 
class Read a where
    
   readsPrec :: B.D (Int -> [Char] -> [(a, [Char])])
    
   readList :: B.D ([Char] -> [([a], [Char])])
   readList v845 v842
     = (readParen v845 False
	  ((B.fu1
	      (\ r ->
		 ((>>=) v845 ((lex v845 r))
		    ((B.fu1
			(\ v193 ->
			   case v193 of
			      ("[", s) -> ((>>=) v845 ((readl v845 s))
					     ((B.fu1 (\ pr -> (Prelude_B.return v845 pr)))))
			      _ -> (Prelude_B.fail v845
				      "pattern match error: Prelude.hs (1276,62)"))))))))
	  v842)
     where
	readl v843 s
	  = ((++) v843
	       (((>>=) v843 ((lex v843 s))
		   ((B.fu1
		       (\ v194 ->
			  case v194 of
			     ("]", t) -> (Prelude_B.return v843 ([], t))
			     _ -> (Prelude_B.fail v843
				     "pattern match error: Prelude.hs (1278,62)"))))))
	       (((>>=) v843 ((reads v843 s))
		   ((B.fu1
		       (\ v196 ->
			  case v196 of
			     (x, t) -> ((>>=) v843 ((readl' v843 t))
					  ((B.fu1
					      (\ v195 ->
						 case v195 of
						    (xs, u) -> (Prelude_B.return v843 ((:) x xs, u))
						    _ -> (Prelude_B.fail v843
							    "pattern match error: Prelude.hs (1280,62)")))))
			     _ -> (Prelude_B.fail v843
				     "pattern match error: Prelude.hs (1279,62)")))))))
	readl' v844 s
	  = ((++) v844
	       (((>>=) v844 ((lex v844 s))
		   ((B.fu1
		       (\ v197 ->
			  case v197 of
			     ("]", t) -> (Prelude_B.return v844 ([], t))
			     _ -> (Prelude_B.fail v844
				     "pattern match error: Prelude.hs (1281,62)"))))))
	       (((>>=) v844 ((lex v844 s))
		   ((B.fu1
		       (\ v200 ->
			  case v200 of
			     (",", t) -> ((>>=) v844 ((reads v844 t))
					    ((B.fu1
						(\ v199 ->
						   case v199 of
						      (x, u) -> ((>>=) v844 ((readl' v844 u))
								   ((B.fu1
								       (\ v198 ->
									  case v198 of
									     (xs,
									      v) -> (Prelude_B.return
										       v844
										       ((:) x xs,
											v))
									     _ -> (Prelude_B.fail
										     v844
										     "pattern match error: Prelude.hs (1284,62)")))))
						      _ -> (Prelude_B.fail v844
							      "pattern match error: Prelude.hs (1283,62)")))))
			     _ -> (Prelude_B.fail v844
				     "pattern match error: Prelude.hs (1282,62)")))))))
 
instance Read () where
   readsPrec v847 p v846
     = (readParen v847 False
	  ((B.fu1
	      (\ r ->
		 ((>>=) v847 ((lex v847 r))
		    ((B.fu1
			(\ v202 ->
			   case v202 of
			      ("(", s) -> ((>>=) v847 ((lex v847 s))
					     ((B.fu1
						 (\ v201 ->
						    case v201 of
						       (")", t) -> (Prelude_B.return v847 ((), t))
						       _ -> (Prelude_B.fail v847
							       "pattern match error: Prelude.hs (1289,54)")))))
			      _ -> (Prelude_B.fail v847
				      "pattern match error: Prelude.hs (1288,54)"))))))))
	  v846)
 
instance (Read a) => Read [a] where
   readsPrec v849 p v848 = (readList v849 v848)
 
instance Read Char where
   readsPrec v851 p v850
     = (readParen v851 False
	  ((B.fu1
	      (\ r ->
		 ((>>=) v851 ((lex v851 r))
		    ((B.fu1
			(\ v204 ->
			   case v204 of
			      ('\'' : s, t) -> ((>>=) v851 ((readLitChar v851 s))
						  ((B.fu1
						      (\ v203 ->
							 case v203 of
							    (c, "'") -> (Prelude_B.return v851
									   (c, t))
							    _ -> (Prelude_B.fail v851
								    "pattern match error: Prelude.hs (1297,55)")))))
			      _ -> (Prelude_B.fail v851
				      "pattern match error: Prelude.hs (1296,55)"))))))))
	  v850)
   readList v858 v852
     = (readParen v858 False
	  ((B.fu1
	      (\ r ->
		 ((>>=) v858 ((lex v858 r))
		    ((B.fu1
			(\ v206 ->
			   case v206 of
			      ('"' : s, t) -> ((>>=) v858 ((readl v858 s))
						 ((B.fu1
						     (\ v205 ->
							case v205 of
							   (l, _) -> (Prelude_B.return v858 (l, t))
							   _ -> (Prelude_B.fail v858
								   "pattern match error: Prelude.hs (1300,59)")))))
			      _ -> (Prelude_B.fail v858
				      "pattern match error: Prelude.hs (1299,59)"))))))))
	  v852)
     where
	readl v853 v207
	  = let v208
		  = \ v855 ->
		      let v209
			    = \ v857 ->
				case v207 of
				   s -> ((>>=) v857 ((readLitChar v857 s))
					   ((B.fu1
					       (\ v211 ->
						  case v211 of
						     (c, t) -> ((>>=) v857 ((readl v857 t))
								  ((B.fu1
								      (\ v210 ->
									 case v210 of
									    (cs,
									     u) -> (Prelude_B.return
										      v857
										      ((:) c cs, u))
									    _ -> (Prelude_B.fail
										    v857
										    "pattern match error: Prelude.hs (1304,55)")))))
						     _ -> (Prelude_B.fail v857
							     "pattern match error: Prelude.hs (1303,55)")))))
				   _ -> (Prelude_B.error v857 "No Match")
			in
			case v207 of
			   (v212 : v213 : s) -> case ((Prelude_B.==) v855 v212 '\\') of
						   True -> case ((Prelude_B.==) v855 v213 '&') of
							      True -> (readl v855 s)
							      False -> (v209 v855)
						   False -> (v209 v855)
			   _ -> (v209 v855)
	      in
	      case v207 of
		 (v214 : s) -> case ((Prelude_B.==) v853 v214 '"') of
				  True -> [("", s)]
				  False -> (v208 v853)
		 _ -> (v208 v853)
 
instance Read Int where
   readsPrec v859 p s = (Prims_B.primReadsPrecInt v859 p s)
 
instance Read Integer where
   readsPrec v860 p s = (Prims_B.primReadsPrecInteger v860 p s)
 
instance Read Float where
   readsPrec v861 p s = (Prims_B.primReadsPrecFloat v861 p s)
 
instance Read Double where
   readsPrec v862 p s = (Prims_B.primReadsPrecDouble v862 p s)
 
instance Read Bool where
   readsPrec v863 d s0
     = (concat v863
	  [(readParen v863 False
	      ((B.fu1
		  (\ s0 ->
		     ((>>=) v863 ((lex v863 s0))
			((B.fu1
			    (\ v215 ->
			       case v215 of
				  ("False", s1) -> (Prelude_B.return v863 (False, s1))
				  _ -> (Prelude_B.fail v863
					  "pattern match error: Prelude.hs (1323,51)"))))))))
	      s0),
	   (readParen v863 False
	      ((B.fu1
		  (\ s0 ->
		     ((>>=) v863 ((lex v863 s0))
			((B.fu1
			    (\ v216 ->
			       case v216 of
				  ("True", s1) -> (Prelude_B.return v863 (True, s1))
				  _ -> (Prelude_B.fail v863
					  "pattern match error: Prelude.hs (1325,49)"))))))))
	      s0)])
 
instance Read Ordering where
   readsPrec v864 d s0
     = (concat v864
	  [(readParen v864 False
	      ((B.fu1
		  (\ s0 ->
		     ((>>=) v864 ((lex v864 s0))
			((B.fu1
			    (\ v217 ->
			       case v217 of
				  ("LT", s1) -> (Prelude_B.return v864 (LT, s1))
				  _ -> (Prelude_B.fail v864
					  "pattern match error: Prelude.hs (1331,45)"))))))))
	      s0),
	   (readParen v864 False
	      ((B.fu1
		  (\ s0 ->
		     ((>>=) v864 ((lex v864 s0))
			((B.fu1
			    (\ v218 ->
			       case v218 of
				  ("EQ", s1) -> (Prelude_B.return v864 (EQ, s1))
				  _ -> (Prelude_B.fail v864
					  "pattern match error: Prelude.hs (1333,45)"))))))))
	      s0),
	   (readParen v864 False
	      ((B.fu1
		  (\ s0 ->
		     ((>>=) v864 ((lex v864 s0))
			((B.fu1
			    (\ v219 ->
			       case v219 of
				  ("GT", s1) -> (Prelude_B.return v864 (GT, s1))
				  _ -> (Prelude_B.fail v864
					  "pattern match error: Prelude.hs (1335,45)"))))))))
	      s0)])
 
instance (Read a, Read b) => Read (Either a b) where
   readsPrec v865 d s0
     = (concat v865
	  [(readParen v865 (((>) v865 d 10))
	      ((B.fu1
		  (\ s0 ->
		     ((>>=) v865 ((lex v865 s0))
			((B.fu1
			    (\ v221 ->
			       case v221 of
				  ("Left", s1) -> ((>>=) v865 ((readsPrec v865 11 s1))
						     ((B.fu1
							 (\ v220 ->
							    case v220 of
							       (x1, s2) -> (Prelude_B.return v865
									      (Left x1, s2))
							       _ -> (Prelude_B.fail v865
								       "pattern match error: Prelude.hs (1343,26)")))))
				  _ -> (Prelude_B.fail v865
					  "pattern match error: Prelude.hs (1342,46)"))))))))
	      s0),
	   (readParen v865 (((>) v865 d 10))
	      ((B.fu1
		  (\ s0 ->
		     ((>>=) v865 ((lex v865 s0))
			((B.fu1
			    (\ v223 ->
			       case v223 of
				  ("Right", s1) -> ((>>=) v865 ((readsPrec v865 11 s1))
						      ((B.fu1
							  (\ v222 ->
							     case v222 of
								(x1, s2) -> (Prelude_B.return v865
									       (Right x1, s2))
								_ -> (Prelude_B.fail v865
									"pattern match error: Prelude.hs (1347,26)")))))
				  _ -> (Prelude_B.fail v865
					  "pattern match error: Prelude.hs (1346,48)"))))))))
	      s0)])
 
instance (Read a) => Read (Maybe a) where
   readsPrec v866 d s0
     = (concat v866
	  [(readParen v866 False
	      ((B.fu1
		  (\ s0 ->
		     ((>>=) v866 ((lex v866 s0))
			((B.fu1
			    (\ v224 ->
			       case v224 of
				  ("Nothing", s1) -> (Prelude_B.return v866 (Nothing, s1))
				  _ -> (Prelude_B.fail v866
					  "pattern match error: Prelude.hs (1353,55)"))))))))
	      s0),
	   (readParen v866 (((>) v866 d 10))
	      ((B.fu1
		  (\ s0 ->
		     ((>>=) v866 ((lex v866 s0))
			((B.fu1
			    (\ v226 ->
			       case v226 of
				  ("Just", s1) -> ((>>=) v866 ((readsPrec v866 11 s1))
						     ((B.fu1
							 (\ v225 ->
							    case v225 of
							       (x1, s2) -> (Prelude_B.return v866
									      (Just x1, s2))
							       _ -> (Prelude_B.fail v866
								       "pattern match error: Prelude.hs (1357,26)")))))
				  _ -> (Prelude_B.fail v866
					  "pattern match error: Prelude.hs (1356,46)"))))))))
	      s0)])
 
readParen ::
	    B.D (Bool -> B.F [Char] [(a, [Char])] -> [Char] -> [(a, [Char])])
readParen v870 b g v867
  = case b of
       True -> (mandatory v870 v867)
       False -> (optional v870 v867)
  where
     optional v868 r = ((++) v868 ((B.app g r)) ((mandatory v868 r)))
     mandatory v869 r
       = ((>>=) v869 ((lex v869 r))
	    ((B.fu1
		(\ v229 ->
		   case v229 of
		      ("(", s) -> ((>>=) v869 ((optional v869 s))
				     ((B.fu1
					 (\ v228 ->
					    case v228 of
					       (x, t) -> ((>>=) v869 ((lex v869 t))
							    ((B.fu1
								(\ v227 ->
								   case v227 of
								      (")", u) -> (Prelude_B.return
										     v869
										     (x, u))
								      _ -> (Prelude_B.fail v869
									      "pattern match error: Prelude.hs (1364,58)")))))
					       _ -> (Prelude_B.fail v869
						       "pattern match error: Prelude.hs (1363,58)")))))
		      _ -> (Prelude_B.fail v869
			      "pattern match error: Prelude.hs (1362,58)")))))
 
readLitChar :: B.D ([Char] -> [(Char, [Char])])
readLitChar v871 v230
  = let v231
	  = \ v873 ->
	      case v230 of
		 (c : s) -> [(c, s)]
		 _ -> (Prelude_B.error v873 "No Match")
      in
      case v230 of
	 (v232 : s) -> case ((Prelude_B.==) v871 v232 '\\') of
			  True -> (readEsc v871 s)
			  False -> (v231 v871)
	 _ -> (v231 v871)
 
readEsc :: B.D ([Char] -> [(Char, [Char])])
readEsc v874 v233
  = let v234
	  = \ v876 ->
	      let v235
		    = \ v878 ->
			let v236
			      = \ v880 ->
				  let v237
					= \ v882 ->
					    let v238
						  = \ v884 ->
						      let v239
							    = \ v886 ->
								let v240
								      = \ v888 ->
									  let v241
										= \ v890 ->
										    let v242
											  = \ v892
											      ->
											      let v243
												    = \ v894
													->
													case
													  v233
													  of
													   _ -> []
													   _ -> (Prelude_B.error
														   v894
														   "No Match")
												in
												case
												  v233
												  of
												   (v244
												      :
												      s) -> case
													      ((Prelude_B.==)
														 v892
														 v244
														 '\'')
													      of
													       True -> [('\'',
															 s)]
													       False -> (v243
															   v892)
												   _ -> (v243
													   v892)
										      in
										      case v233 of
											 (v245 :
											    s) -> case
												    ((Prelude_B.==)
												       v890
												       v245
												       '"')
												    of
												     True -> [('"',
													       s)]
												     False -> (v242
														 v890)
											 _ -> (v242
												 v890)
									    in
									    case v233 of
									       (v246 : s) -> case
											       ((Prelude_B.==)
												  v888
												  v246
												  '\\')
											       of
												True -> [('\\',
													  s)]
												False -> (v241
													    v888)
									       _ -> (v241 v888)
								  in
								  case v233 of
								     (v247 : s) -> case
										     ((Prelude_B.==)
											v886
											v247
											'v')
										     of
										      True -> [('\v',
												s)]
										      False -> (v240
												  v886)
								     _ -> (v240 v886)
							in
							case v233 of
							   (v248 : s) -> case
									   ((Prelude_B.==) v884 v248
									      't')
									   of
									    True -> [('\t', s)]
									    False -> (v239 v884)
							   _ -> (v239 v884)
					      in
					      case v233 of
						 (v249 : s) -> case ((Prelude_B.==) v882 v249 'r')
								 of
								  True -> [('\r', s)]
								  False -> (v238 v882)
						 _ -> (v238 v882)
				    in
				    case v233 of
				       (v250 : s) -> case ((Prelude_B.==) v880 v250 'n') of
							True -> [('\n', s)]
							False -> (v237 v880)
				       _ -> (v237 v880)
			  in
			  case v233 of
			     (v251 : s) -> case ((Prelude_B.==) v878 v251 'f') of
					      True -> [('\f', s)]
					      False -> (v236 v878)
			     _ -> (v236 v878)
		in
		case v233 of
		   (v252 : s) -> case ((Prelude_B.==) v876 v252 'b') of
				    True -> [('\b', s)]
				    False -> (v235 v876)
		   _ -> (v235 v876)
      in
      case v233 of
	 (v253 : s) -> case ((Prelude_B.==) v874 v253 'a') of
			  True -> [('\a', s)]
			  False -> (v234 v874)
	 _ -> (v234 v874)
 
lex :: B.D ([Char] -> [([Char], [Char])])
lex v895 x = (Prims_B.primLex v895 x)
 
reads :: (Read a) => B.D ([Char] -> [(a, [Char])])
reads v897 v896 = (readsPrec v897 0 v896)
 
read :: (Read a) => B.D ([Char] -> a)
read v898 s
  = case
      ((>>=) v898 ((reads v898 s))
	 ((B.fu1
	     (\ v255 ->
		case v255 of
		   (x, t) -> ((>>=) v898 ((lex v898 t))
				((B.fu1
				    (\ v254 ->
				       case v254 of
					  ("", "") -> (Prelude_B.return v898 x)
					  _ -> (Prelude_B.fail v898
						  "pattern match error: Prelude.hs (1396,57)")))))
		   _ -> (Prelude_B.fail v898
			   "pattern match error: Prelude.hs (1396,37)")))))
      of
       [x] -> x
       [] -> (error v898 "Prelude.read: no parse")
       _ -> (error v898 "Prelude.read: ambiguous parse")
 
instance (Eq a, Eq b) => Eq ((,) a b) where
   (v899 == v2_) v1_
     = case (v2_, v1_) of
	  (((,) x1 x2), ((,) x3 x4)) -> ((&&) v899 (((==) v899 x1 x3))
					   (((==) v899 x2 x4)))
 
instance (Ord a, Ord b) => Ord ((,) a b) where
   (v900 <= v4_) v3_
     = case (v4_, v3_) of
	  (((,) x1 x2), ((,) x3 x4)) -> (((||) v900 (((<) v900 x1 x3))
					    (((&&) v900 (((==) v900 x1 x3)) (((<=) v900 x2 x4))))))
 
instance (Bounded a, Bounded b) => Bounded ((,) a b) where
   minBound = \ v901 -> (,) (minBound v901) (minBound v901)
   maxBound = \ v902 -> (,) (maxBound v902) (maxBound v902)
 
instance (Eq a, Eq b, Eq c) => Eq ((,,) a b c) where
   (v903 == v6_) v5_
     = case (v6_, v5_) of
	  (((,,) x1 x2 x3), ((,,) x4 x5 x6)) -> ((&&) v903
						   (((==) v903 x1 x4))
						   (((&&) v903 (((==) v903 x2 x5))
						       (((==) v903 x3 x6)))))
 
instance (Ord a, Ord b, Ord c) => Ord ((,,) a b c) where
   (v904 <= v8_) v7_
     = case (v8_, v7_) of
	  (((,,) x1 x2 x3), ((,,) x4 x5 x6)) -> (((||) v904
						    (((<) v904 x1 x4))
						    (((&&) v904 (((==) v904 x1 x4))
							(((||) v904 (((<) v904 x2 x5))
							    (((&&) v904 (((==) v904 x2 x5))
								(((<=) v904 x3 x6))))))))))
 
instance (Bounded a, Bounded b, Bounded c) => Bounded ((,,) a b c)
	 where
   minBound
     = \ v905 -> (,,) (minBound v905) (minBound v905) (minBound v905)
   maxBound
     = \ v906 -> (,,) (maxBound v906) (maxBound v906) (maxBound v906)
 
instance (Eq a, Eq b, Eq c, Eq d) => Eq ((,,,) a b c d) where
   (v907 == v10_) v9_
     = case (v10_, v9_) of
	  (((,,,) x1 x2 x3 x4), ((,,,) x5 x6 x7 x8)) -> ((&&) v907
							   (((==) v907 x1 x5))
							   (((&&) v907 (((==) v907 x2 x6))
							       (((&&) v907 (((==) v907 x3 x7))
								   (((==) v907 x4 x8)))))))
 
instance (Ord a, Ord b, Ord c, Ord d) => Ord ((,,,) a b c d) where
   (v908 <= v12_) v11_
     = case (v12_, v11_) of
	  (((,,,) x1 x2 x3 x4), ((,,,) x5 x6 x7 x8)) -> (((||) v908
							    (((<) v908 x1 x5))
							    (((&&) v908 (((==) v908 x1 x5))
								(((||) v908 (((<) v908 x2 x6))
								    (((&&) v908 (((==) v908 x2 x6))
									(((||) v908
									    (((<) v908 x3 x7))
									    (((&&) v908
										(((==) v908 x3 x7))
										(((<=) v908 x4
										    x8))))))))))))))
 
instance (Bounded a, Bounded b, Bounded c, Bounded d) => Bounded
	 ((,,,) a b c d) where
   minBound
     = \ v909 ->
	 (,,,) (minBound v909) (minBound v909) (minBound v909)
	   (minBound v909)
   maxBound
     = \ v910 ->
	 (,,,) (maxBound v910) (maxBound v910) (maxBound v910)
	   (maxBound v910)
 
instance (Eq a, Eq b, Eq c, Eq d, Eq e) => Eq ((,,,,) a b c d e)
	 where
   (v911 == v14_) v13_
     = case (v14_, v13_) of
	  (((,,,,) x1 x2 x3 x4 x5), ((,,,,) x6 x7 x8 x9 x10)) -> ((&&) v911
								    (((==) v911 x1 x6))
								    (((&&) v911 (((==) v911 x2 x7))
									(((&&) v911
									    (((==) v911 x3 x8))
									    (((&&) v911
										(((==) v911 x4 x9))
										(((==) v911 x5
										    x10)))))))))
 
instance (Ord a, Ord b, Ord c, Ord d, Ord e) => Ord
	 ((,,,,) a b c d e) where
   (v912 <= v16_) v15_
     = case (v16_, v15_) of
	  (((,,,,) x1 x2 x3 x4 x5), ((,,,,) x6 x7 x8 x9 x10)) -> (((||) v912
								     (((<) v912 x1 x6))
								     (((&&) v912 (((==) v912 x1 x6))
									 (((||) v912
									     (((<) v912 x2 x7))
									     (((&&) v912
										 (((==) v912 x2 x7))
										 (((||) v912
										     (((<) v912 x3
											 x8))
										     (((&&) v912
											 (((==) v912
											     x3
											     x8))
											 (((||) v912
											     (((<)
												 v912
												 x4
												 x9))
											     (((&&)
												 v912
												 (((==)
												     v912
												     x4
												     x9))
												 (((<=)
												     v912
												     x5
												     x10))))))))))))))))))
 
instance (Bounded a, Bounded b, Bounded c, Bounded d, Bounded e) =>
	 Bounded ((,,,,) a b c d e) where
   minBound
     = \ v913 ->
	 (,,,,) (minBound v913) (minBound v913) (minBound v913)
	   (minBound v913)
	   (minBound v913)
   maxBound
     = \ v914 ->
	 (,,,,) (maxBound v914) (maxBound v914) (maxBound v914)
	   (maxBound v914)
	   (maxBound v914)
 
showTuple :: B.D ([B.F [Char] [Char]] -> [Char] -> [Char])
showTuple v916 v257 v915
  = case v257 of
       (x : xs) -> let showT v917 v256
			 = case v256 of
			      [] -> (B.fu1 (showChar v917 ')'))
			      (x : xs) -> (B.fu1
					     ((.) v917 ((B.fu1 (showChar v917 ',')))
						((B.fu1 ((.) v917 x ((showT v917 xs)))))))
		     in
		     ((.) v916 ((B.fu1 (showChar v916 '(')))
			((B.fu1 ((.) v916 x ((showT v916 xs)))))
			v915)
 
instance (Show x1, Show x2) => Show (x1, x2) where
   showsPrec v920 v919@_ v258 v918
     = case v258 of
	  (x1, x2) -> (showTuple v920
			 [(B.fu1 (shows v920 x1)), (B.fu1 (shows v920 x2))]
			 v918)
 
instance (Show x1, Show x2, Show x3) => Show (x1, x2, x3) where
   showsPrec v923 v922@_ v259 v921
     = case v259 of
	  (x1, x2, x3) -> (showTuple v923
			     [(B.fu1 (shows v923 x1)), (B.fu1 (shows v923 x2)),
			      (B.fu1 (shows v923 x3))]
			     v921)
 
instance (Show x1, Show x2, Show x3, Show x4) => Show
	 (x1, x2, x3, x4) where
   showsPrec v926 v925@_ v260 v924
     = case v260 of
	  (x1, x2, x3, x4) -> (showTuple v926
				 [(B.fu1 (shows v926 x1)), (B.fu1 (shows v926 x2)),
				  (B.fu1 (shows v926 x3)), (B.fu1 (shows v926 x4))]
				 v924)
 
instance (Show x1, Show x2, Show x3, Show x4, Show x5) => Show
	 (x1, x2, x3, x4, x5) where
   showsPrec v929 v928@_ v261 v927
     = case v261 of
	  (x1, x2, x3, x4, x5) -> (showTuple v929
				     [(B.fu1 (shows v929 x1)), (B.fu1 (shows v929 x2)),
				      (B.fu1 (shows v929 x3)), (B.fu1 (shows v929 x4)),
				      (B.fu1 (shows v929 x5))]
				     v927)
 
instance (Read x1, Read x2) => Read (x1, x2) where
   readsPrec v933 v931@_ v930
     = (readParen v933 False (B.fu1 (rb v933)) v930)
     where
	rb v932 s0
	  = ((>>=) v932 ((lex v932 s0))
	       ((B.fu1
		   (\ v266 ->
		      case v266 of
			 ("(", s1) -> ((>>=) v932 ((reads v932 s1))
					 ((B.fu1
					     (\ v265 ->
						case v265 of
						   (x1, s2) -> ((>>=) v932 ((lex v932 s2))
								  ((B.fu1
								      (\ v264 ->
									 case v264 of
									    (",", s3) -> ((>>=) v932
											    ((reads
												v932
												s3))
											    ((B.fu1
												(\ v263
												   ->
												   case
												     v263
												     of
												      (x2,
												       s4) -> ((>>=)
														 v932
														 ((lex
														     v932
														     s4))
														 ((B.fu1
														     (\ v262
															->
															case
															  v262
															  of
															   (")",
															    s5) -> (Prelude_B.return
																      v932
																      ((x1,
																	x2),
																       s5))
															   _ -> (Prelude_B.fail
																   v932
																   "pattern match error: Prelude.hs (1567,46)")))))
												      _ -> (Prelude_B.fail
													      v932
													      "pattern match error: Prelude.hs (1567,23)")))))
									    _ -> (Prelude_B.fail
										    v932
										    "pattern match error: Prelude.hs (1566,46)")))))
						   _ -> (Prelude_B.fail v932
							   "pattern match error: Prelude.hs (1566,23)")))))
			 _ -> (Prelude_B.fail v932
				 "pattern match error: Prelude.hs (1565,41)")))))
 
instance (Read x1, Read x2, Read x3) => Read (x1, x2, x3) where
   readsPrec v937 v935@_ v934
     = (readParen v937 False (B.fu1 (rb v937)) v934)
     where
	rb v936 s0
	  = ((>>=) v936 ((lex v936 s0))
	       ((B.fu1
		   (\ v273 ->
		      case v273 of
			 ("(", s1) -> ((>>=) v936 ((reads v936 s1))
					 ((B.fu1
					     (\ v272 ->
						case v272 of
						   (x1, s2) -> ((>>=) v936 ((lex v936 s2))
								  ((B.fu1
								      (\ v271 ->
									 case v271 of
									    (",", s3) -> ((>>=) v936
											    ((reads
												v936
												s3))
											    ((B.fu1
												(\ v270
												   ->
												   case
												     v270
												     of
												      (x2,
												       s4) -> ((>>=)
														 v936
														 ((lex
														     v936
														     s4))
														 ((B.fu1
														     (\ v269
															->
															case
															  v269
															  of
															   (",",
															    s5) -> ((>>=)
																      v936
																      ((reads
																	  v936
																	  s5))
																      ((B.fu1
																	  (\ v268
																	     ->
																	     case
																	       v268
																	       of
																		(x3,
																		 s6) -> ((>>=)
																			   v936
																			   ((lex
																			       v936
																			       s6))
																			   ((B.fu1
																			       (\ v267
																				  ->
																				  case
																				    v267
																				    of
																				     (")",
																				      s7) -> (Prelude_B.return
																						v936
																						((x1,
																						  x2,
																						  x3),
																						 s7))
																				     _ -> (Prelude_B.fail
																					     v936
																					     "pattern match error: Prelude.hs (1577,46)")))))
																		_ -> (Prelude_B.fail
																			v936
																			"pattern match error: Prelude.hs (1577,23)")))))
															   _ -> (Prelude_B.fail
																   v936
																   "pattern match error: Prelude.hs (1576,46)")))))
												      _ -> (Prelude_B.fail
													      v936
													      "pattern match error: Prelude.hs (1576,23)")))))
									    _ -> (Prelude_B.fail
										    v936
										    "pattern match error: Prelude.hs (1575,46)")))))
						   _ -> (Prelude_B.fail v936
							   "pattern match error: Prelude.hs (1575,23)")))))
			 _ -> (Prelude_B.fail v936
				 "pattern match error: Prelude.hs (1574,45)")))))
 
instance (Read x1, Read x2, Read x3, Read x4) => Read
	 (x1, x2, x3, x4) where
   readsPrec v941 v939@_ v938
     = (readParen v941 False (B.fu1 (rb v941)) v938)
     where
	rb v940 s0
	  = ((>>=) v940 ((lex v940 s0))
	       ((B.fu1
		   (\ v282 ->
		      case v282 of
			 ("(", s1) -> ((>>=) v940 ((reads v940 s1))
					 ((B.fu1
					     (\ v281 ->
						case v281 of
						   (x1, s2) -> ((>>=) v940 ((lex v940 s2))
								  ((B.fu1
								      (\ v280 ->
									 case v280 of
									    (",", s3) -> ((>>=) v940
											    ((reads
												v940
												s3))
											    ((B.fu1
												(\ v279
												   ->
												   case
												     v279
												     of
												      (x2,
												       s4) -> ((>>=)
														 v940
														 ((lex
														     v940
														     s4))
														 ((B.fu1
														     (\ v278
															->
															case
															  v278
															  of
															   (",",
															    s5) -> ((>>=)
																      v940
																      ((reads
																	  v940
																	  s5))
																      ((B.fu1
																	  (\ v277
																	     ->
																	     case
																	       v277
																	       of
																		(x3,
																		 s6) -> ((>>=)
																			   v940
																			   ((lex
																			       v940
																			       s6))
																			   ((B.fu1
																			       (\ v276
																				  ->
																				  case
																				    v276
																				    of
																				     (",",
																				      s7) -> ((>>=)
																						v940
																						((reads
																						    v940
																						    s7))
																						((B.fu1
																						    (\ v275
																						       ->
																						       case
																							 v275
																							 of
																							  (x4,
																							   s8) -> ((>>=)
																								     v940
																								     ((lex
																									 v940
																									 s8))
																								     ((B.fu1
																									 (\ v274
																									    ->
																									    case
																									      v274
																									      of
																									       (")",
																										s9) -> (Prelude_B.return
																											  v940
																											  ((x1,
																											    x2,
																											    x3,
																											    x4),
																											   s9))
																									       _ -> (Prelude_B.fail
																										       v940
																										       "pattern match error: Prelude.hs (1589,46)")))))
																							  _ -> (Prelude_B.fail
																								  v940
																								  "pattern match error: Prelude.hs (1589,23)")))))
																				     _ -> (Prelude_B.fail
																					     v940
																					     "pattern match error: Prelude.hs (1588,46)")))))
																		_ -> (Prelude_B.fail
																			v940
																			"pattern match error: Prelude.hs (1588,23)")))))
															   _ -> (Prelude_B.fail
																   v940
																   "pattern match error: Prelude.hs (1587,46)")))))
												      _ -> (Prelude_B.fail
													      v940
													      "pattern match error: Prelude.hs (1587,23)")))))
									    _ -> (Prelude_B.fail
										    v940
										    "pattern match error: Prelude.hs (1586,46)")))))
						   _ -> (Prelude_B.fail v940
							   "pattern match error: Prelude.hs (1586,23)")))))
			 _ -> (Prelude_B.fail v940
				 "pattern match error: Prelude.hs (1585,49)")))))
 
instance (Read x1, Read x2, Read x3, Read x4, Read x5) => Read
	 (x1, x2, x3, x4, x5) where
   readsPrec v945 v943@_ v942
     = (readParen v945 False (B.fu1 (rb v945)) v942)
     where
	rb v944 s0
	  = ((>>=) v944 ((lex v944 s0))
	       ((B.fu1
		   (\ v293 ->
		      case v293 of
			 ("(", s1) -> ((>>=) v944 ((reads v944 s1))
					 ((B.fu1
					     (\ v292 ->
						case v292 of
						   (x1, s2) -> ((>>=) v944 ((lex v944 s2))
								  ((B.fu1
								      (\ v291 ->
									 case v291 of
									    (",", s3) -> ((>>=) v944
											    ((reads
												v944
												s3))
											    ((B.fu1
												(\ v290
												   ->
												   case
												     v290
												     of
												      (x2,
												       s4) -> ((>>=)
														 v944
														 ((lex
														     v944
														     s4))
														 ((B.fu1
														     (\ v289
															->
															case
															  v289
															  of
															   (",",
															    s5) -> ((>>=)
																      v944
																      ((reads
																	  v944
																	  s5))
																      ((B.fu1
																	  (\ v288
																	     ->
																	     case
																	       v288
																	       of
																		(x3,
																		 s6) -> ((>>=)
																			   v944
																			   ((lex
																			       v944
																			       s6))
																			   ((B.fu1
																			       (\ v287
																				  ->
																				  case
																				    v287
																				    of
																				     (",",
																				      s7) -> ((>>=)
																						v944
																						((reads
																						    v944
																						    s7))
																						((B.fu1
																						    (\ v286
																						       ->
																						       case
																							 v286
																							 of
																							  (x4,
																							   s8) -> ((>>=)
																								     v944
																								     ((lex
																									 v944
																									 s8))
																								     ((B.fu1
																									 (\ v285
																									    ->
																									    case
																									      v285
																									      of
																									       (",",
																										s9) -> ((>>=)
																											  v944
																											  ((reads
																											      v944
																											      s9))
																											  ((B.fu1
																											      (\ v284
																												 ->
																												 case
																												   v284
																												   of
																												    (x5,
																												     s10) -> ((>>=)
																														v944
																														((lex
																														    v944
																														    s10))
																														((B.fu1
																														    (\ v283
																														       ->
																														       case
																															 v283
																															 of
																															  (")",
																															   s11) -> (Prelude_B.return
																																      v944
																																      ((x1,
																																	x2,
																																	x3,
																																	x4,
																																	x5),
																																       s11))
																															  _ -> (Prelude_B.fail
																																  v944
																																  "pattern match error: Prelude.hs (1602,48)")))))
																												    _ -> (Prelude_B.fail
																													    v944
																													    "pattern match error: Prelude.hs (1602,24)")))))
																									       _ -> (Prelude_B.fail
																										       v944
																										       "pattern match error: Prelude.hs (1601,46)")))))
																							  _ -> (Prelude_B.fail
																								  v944
																								  "pattern match error: Prelude.hs (1601,23)")))))
																				     _ -> (Prelude_B.fail
																					     v944
																					     "pattern match error: Prelude.hs (1600,46)")))))
																		_ -> (Prelude_B.fail
																			v944
																			"pattern match error: Prelude.hs (1600,23)")))))
															   _ -> (Prelude_B.fail
																   v944
																   "pattern match error: Prelude.hs (1599,46)")))))
												      _ -> (Prelude_B.fail
													      v944
													      "pattern match error: Prelude.hs (1599,23)")))))
									    _ -> (Prelude_B.fail
										    v944
										    "pattern match error: Prelude.hs (1598,46)")))))
						   _ -> (Prelude_B.fail v944
							   "pattern match error: Prelude.hs (1598,23)")))))
			 _ -> (Prelude_B.fail v944
				 "pattern match error: Prelude.hs (1597,54)")))))
