{-# OPTIONS -cpp #-}
{- primitives that should not be transformed -}

module Prims_B where

import qualified Buddha as B
import qualified Char
import qualified IOExts
import qualified CPUTime
import GHC.Exts
import Prelude hiding (IOError)
import Control.Exception (Exception (..))
import IOPrims_B (IOError)

primError :: B.D (String -> a)
primError parent s 
   = B.node (B.ps "error") [B.V s] parent 335 (B.ps "Prelude") (\_ -> error s)

primSeq :: B.D (a -> b -> b)
primSeq _ x y = (seq x y)

primEqChar :: B.D (Char -> Char -> Bool)
primEqChar _ c1 c2 = (c1 == c2)

primEqInt :: B.D (Int -> Int -> Bool)
primEqInt _ c1 c2 = (c1 == c2)

primEqInteger :: B.D (Integer -> Integer -> Bool)
primEqInteger _ c1 c2 = (c1 == c2)

primEqFloat :: B.D (Float -> Float -> Bool)
primEqFloat _ c1 c2 = (c1 == c2)

primEqDouble :: B.D (Double -> Double -> Bool)
primEqDouble _ c1 c2 = (c1 == c2)

primEqIOError :: B.D (IOError -> IOError -> Bool)
primEqIOError _ c1 c2 = (c1 == c2)

primLteChar :: B.D (Char -> Char -> Bool)
primLteChar _ c1 c2 = (c1 <= c2)

primLteInt :: B.D (Int -> Int -> Bool)
primLteInt _ c1 c2 = (c1 <= c2)

primLteInteger :: B.D (Integer -> Integer -> Bool)
primLteInteger _ c1 c2 = (c1 <= c2)

primLteFloat :: B.D (Float -> Float -> Bool)
primLteFloat _ c1 c2 = (c1 <= c2)

primLteDouble :: B.D (Double -> Double -> Bool)
primLteDouble _ c1 c2 = (c1 <= c2)

primFromEnumChar :: B.D (Char -> Int)
primFromEnumChar _ c = (fromEnum c)

primToEnumChar :: B.D (Int -> Char)
primToEnumChar _ c = (toEnum c)

primFromEnumInt :: B.D (Int -> Int)
primFromEnumInt _ c = (fromEnum c)

primToEnumInt :: B.D (Int -> Int)
primToEnumInt _ c = (toEnum c)

primFromEnumInteger :: B.D (Integer -> Int)
primFromEnumInteger _ c = (fromEnum c)

primToEnumInteger :: B.D (Int -> Integer)
primToEnumInteger _ c = (toEnum c)

primFromEnumDouble :: B.D (Double -> Int)
primFromEnumDouble _ c = (fromEnum c)

primToEnumDouble :: B.D (Int -> Double)
primToEnumDouble _ c = (toEnum c)

primFromEnumFloat :: B.D (Float -> Int)
primFromEnumFloat _ c = (fromEnum c)

primToEnumFloat :: B.D (Int -> Float)
primToEnumFloat _ c = (toEnum c)

primEnumFromInt :: B.D (Int -> [Int])
primEnumFromInt _ x = (enumFrom x)

primEnumFromToInt :: B.D (Int -> Int -> [Int])
primEnumFromToInt _ x y = (enumFromTo x y)

primEnumFromThenInt :: B.D (Int -> Int -> [Int])
primEnumFromThenInt _ x y = (enumFromThen x y)

primEnumFromThenToInt :: B.D (Int -> Int -> Int -> [Int])
primEnumFromThenToInt _ x y z = (enumFromThenTo x y z)

primEnumFromInteger :: B.D (Integer -> [Integer])
primEnumFromInteger _ x = (enumFrom x)

primEnumFromToInteger :: B.D (Integer -> Integer -> [Integer])
primEnumFromToInteger _ x y = (enumFromTo x y)

primEnumFromThenInteger :: B.D (Integer -> Integer -> [Integer])
primEnumFromThenInteger _ x y = (enumFromThen x y)

primEnumFromThenToInteger :: B.D (Integer -> Integer -> Integer -> [Integer])
primEnumFromThenToInteger _ x y z = (enumFromThenTo x y z)

primEnumFromFloat :: B.D (Float -> [Float])
primEnumFromFloat _ x = (enumFrom x)

primEnumFromToFloat :: B.D (Float -> Float -> [Float])
primEnumFromToFloat _ x y = (enumFromTo x y)

primEnumFromThenFloat :: B.D (Float -> Float -> [Float])
primEnumFromThenFloat _ x y = (enumFromThen x y)

primEnumFromThenToFloat :: B.D (Float -> Float -> Float -> [Float])
primEnumFromThenToFloat _ x y z = (enumFromThenTo x y z)

primEnumFromDouble :: B.D (Double -> [Double])
primEnumFromDouble _ x = (enumFrom x)

primEnumFromToDouble :: B.D (Double -> Double -> [Double])
primEnumFromToDouble _ x y = (enumFromTo x y)

primEnumFromThenDouble :: B.D (Double -> Double -> [Double])
primEnumFromThenDouble _ x y = (enumFromThen x y)

primEnumFromThenToDouble :: B.D (Double -> Double -> Double -> [Double])
primEnumFromThenToDouble _ x y z = (enumFromThenTo x y z)

primMinInt :: B.D (Int)
primMinInt _ = (minBound::Int) 

primMaxInt :: B.D (Int)
primMaxInt _ = (maxBound::Int) 

primShowLitChar :: B.D (Char -> String -> String)
primShowLitChar _ c s = (Char.showLitChar c s)

primShowsPrecInt :: B.D (Int -> Int -> String -> String)
primShowsPrecInt _ p c s = (showsPrec p c s)

primShowsPrecInteger :: B.D (Int -> Integer -> String -> String)
primShowsPrecInteger _ p c s = (showsPrec p c s)

primShowsPrecFloat :: B.D (Int -> Float -> String -> String)
primShowsPrecFloat _ p c s = (showsPrec p c s)

primShowsPrecDouble :: B.D (Int -> Double -> String -> String)
primShowsPrecDouble _ p c s = (showsPrec p c s)

primShowsPrecIOError :: B.D (Int -> IOError -> String -> String)
primShowsPrecIOError _ p c s = (showsPrec p c s)

primMinusFloat :: B.D (Float -> Float -> Float)
primMinusFloat _ x y = (x - y)

primMulFloat :: B.D (Float -> Float -> Float)
primMulFloat _ x y = (x * y)

primPlusFloat :: B.D (Float -> Float -> Float)
primPlusFloat _ x y = (x + y)

primNegateFloat :: B.D (Float -> Float)
primNegateFloat _ x = (negate x)

primAbsFloat :: B.D (Float -> Float)
primAbsFloat _ x = (abs x)

primSigNumFloat :: B.D (Float -> Float)
primSigNumFloat _ x = (signum x)

primFromIntegerFloat :: B.D (Integer -> Float)
primFromIntegerFloat _ x = (fromInteger x)

primMinusDouble :: B.D (Double -> Double -> Double)
primMinusDouble _ x y = (x - y)

primMulDouble :: B.D (Double -> Double -> Double)
primMulDouble _ x y = (x * y)

primPlusDouble :: B.D (Double -> Double -> Double)
primPlusDouble _ x y = (x + y)

primNegateDouble :: B.D (Double -> Double)
primNegateDouble _ x = (negate x)

primAbsDouble :: B.D (Double -> Double)
primAbsDouble _ x = (abs x)

primSigNumDouble :: B.D (Double -> Double)
primSigNumDouble _ x = (signum x)

primFromIntegerDouble :: B.D (Integer -> Double)
primFromIntegerDouble _ x = (fromInteger x)

primMinusInt :: B.D (Int -> Int -> Int)
primMinusInt _ x y = (x - y)

primMulInt :: B.D (Int -> Int -> Int)
primMulInt _ x y = (x * y)

primPlusInt :: B.D (Int -> Int -> Int)
primPlusInt _ x y = (x + y)

primNegateInt :: B.D (Int -> Int)
primNegateInt _ x = (negate x)

primAbsInt :: B.D (Int -> Int)
primAbsInt _ x = (abs x)

primSigNumInt :: B.D (Int -> Int)
primSigNumInt _ x = (signum x)

primFromIntegerInt :: B.D (Integer -> Int)
primFromIntegerInt _ x = (fromInteger x)

primMinusInteger :: B.D (Integer -> Integer -> Integer)
primMinusInteger _ x y = (x - y)

primMulInteger :: B.D (Integer -> Integer -> Integer)
primMulInteger _ x y = (x * y)

primPlusInteger :: B.D (Integer -> Integer -> Integer)
primPlusInteger _ x y = (x + y)

primNegateInteger :: B.D (Integer -> Integer)
primNegateInteger _ x = (negate x)

primAbsInteger :: B.D (Integer -> Integer)
primAbsInteger _ x = (abs x)

primSigNumInteger :: B.D (Integer -> Integer)
primSigNumInteger _ x = (signum x)

primFromIntegerInteger :: B.D (Integer -> Integer)
primFromIntegerInteger _ x = (fromInteger x)

primToRationalInt :: B.D (Int -> Rational)
primToRationalInt _ x = (toRational x)

primToRationalInteger :: B.D (Integer -> Rational)
primToRationalInteger _ x = (toRational x)

primToRationalFloat :: B.D (Float -> Rational)
primToRationalFloat _ x = (toRational x)

primToRationalDouble :: B.D (Double -> Rational)
primToRationalDouble _ x = (toRational x)

{- these are intentionally not debugable -}

prim_No_Debug_fromIntegerInt :: (Integer -> Int)
prim_No_Debug_fromIntegerInt i = fromInteger i

prim_No_Debug_fromIntegerInteger :: (Integer -> Integer)
prim_No_Debug_fromIntegerInteger i = fromInteger i

prim_No_Debug_fromIntegerFloat :: (Integer -> Float)
prim_No_Debug_fromIntegerFloat i = fromInteger i

prim_No_Debug_fromIntegerDouble :: (Integer -> Double)
prim_No_Debug_fromIntegerDouble i = fromInteger i

prim_No_Debug_fromRationalFloat :: (Rational -> Float)
prim_No_Debug_fromRationalFloat f = fromRational f

prim_No_Debug_fromRationalDouble :: (Rational -> Double)
prim_No_Debug_fromRationalDouble f = fromRational f

prim_No_Debug_negateInt :: (Int -> Int)
prim_No_Debug_negateInt i = negate i

prim_No_Debug_negateInteger :: (Integer -> Integer)
prim_No_Debug_negateInteger i = negate i

prim_No_Debug_negateFloat :: (Float -> Float)
prim_No_Debug_negateFloat f = negate f

prim_No_Debug_negateDouble :: (Double -> Double)
prim_No_Debug_negateDouble f = negate f

{- end of intentionally not debugable functions -}

primDivInt :: B.D (Int -> Int -> Int)
primDivInt _ x y = (div x y)

primQuotInt :: B.D (Int -> Int -> Int)
primQuotInt _ x y = (quot x y)

primRemInt :: B.D (Int -> Int -> Int)
primRemInt _ x y =  (rem x y)

primModInt :: B.D (Int -> Int -> Int)
primModInt _ x y =  (mod x y)

primQuotRemInt :: B.D (Int -> Int -> (Int, Int))
primQuotRemInt _ x y =  (quotRem x y)

primToIntegerInt :: B.D (Int -> Integer)
primToIntegerInt _ x = (toInteger x)

primDivInteger :: B.D (Integer -> Integer -> Integer)
primDivInteger _ x y = (div x y)

primQuotInteger :: B.D (Integer -> Integer -> Integer)
primQuotInteger _ x y = (quot x y)

primRemInteger :: B.D (Integer -> Integer -> Integer)
primRemInteger _ x y =  (rem x y)

primModInteger :: B.D (Integer -> Integer -> Integer)
primModInteger _ x y =  (mod x y)

primQuotRemInteger :: B.D (Integer -> Integer -> (Integer, Integer))
primQuotRemInteger _ x y =  (quotRem x y)

primToIntegerInteger :: B.D (Integer -> Integer)
primToIntegerInteger _ x = (toInteger x)

primDivideFloat :: B.D (Float -> Float -> Float)
primDivideFloat _ x y = (x / y)

primFromRationalFloat :: B.D (Rational -> Float)
primFromRationalFloat _ x = (fromRational x) 
    
primDivideDouble :: B.D (Double -> Double -> Double)
primDivideDouble _ x y = (x / y)

primFromRationalDouble :: B.D (Rational -> Double)
primFromRationalDouble _ x = (fromRational x) 

primPiFloat :: B.D (Float)
primPiFloat _ = pi

primExpFloat :: B.D (Float -> Float)
primExpFloat _ x = (exp x)

primLogFloat :: B.D (Float -> Float)
primLogFloat _ x = (log x)

primSinFloat :: B.D (Float -> Float)
primSinFloat _ x = (sin x)

primCosFloat :: B.D (Float -> Float)
primCosFloat _ x = (cos x)

primSinhFloat :: B.D (Float -> Float)
primSinhFloat _ x = (sinh x)

primCoshFloat :: B.D (Float -> Float)
primCoshFloat _ x = (cosh x)

primAsinFloat :: B.D (Float -> Float)
primAsinFloat _ x = (asin x)

primAcosFloat :: B.D (Float -> Float)
primAcosFloat _ x = (acos x)

primAtanFloat :: B.D (Float -> Float)
primAtanFloat _ x = (atan x)

primAsinhFloat :: B.D (Float -> Float)
primAsinhFloat _ x = (asinh x)

primAcoshFloat :: B.D (Float -> Float)
primAcoshFloat _ x = (acosh x)

primAtanhFloat :: B.D (Float -> Float)
primAtanhFloat _ x = (atanh x)

primPiDouble :: B.D (Double)
primPiDouble _ = pi

primExpDouble :: B.D (Double -> Double)
primExpDouble _ x = (exp x)

primLogDouble :: B.D (Double -> Double)
primLogDouble _ x = (log x)

primSinDouble :: B.D (Double -> Double)
primSinDouble _ x = (sin x)

primCosDouble :: B.D (Double -> Double)
primCosDouble _ x = (cos x)

primSinhDouble :: B.D (Double -> Double)
primSinhDouble _ x = (sinh x)

primCoshDouble :: B.D (Double -> Double)
primCoshDouble _ x = (cosh x)

primAsinDouble :: B.D (Double -> Double)
primAsinDouble _ x = (asin x)

primAcosDouble :: B.D (Double -> Double)
primAcosDouble _ x = (acos x)

primAtanDouble :: B.D (Double -> Double)
primAtanDouble _ x = (atan x)

primAsinhDouble :: B.D (Double -> Double)
primAsinhDouble _ x = (asinh x)

primAcoshDouble :: B.D (Double -> Double)
primAcoshDouble _ x = (acosh x)

primAtanhDouble :: B.D (Double -> Double)
primAtanhDouble _ x = (atanh x)

primFloatRadixFloat :: B.D (Float -> Integer)
primFloatRadixFloat _ x = (floatRadix x)

primFloatDigitsFloat :: B.D ( Float -> Int)
primFloatDigitsFloat _ x = (floatDigits x)

primFloatRangeFloat :: B.D (Float -> (Int, Int))
primFloatRangeFloat _ x = (floatRange x)

primDecodeFloatFloat :: B.D (Float -> (Integer, Int))
primDecodeFloatFloat _ x = (decodeFloat x)

primEncodeFloatFloat :: B.D (Integer -> Int -> Float)
primEncodeFloatFloat _ x y = (encodeFloat x y)

primIsNaNFloat :: B.D (Float -> Bool)
primIsNaNFloat _ x = (isNaN x)

primIsInfiniteFloat :: B.D ( Float -> Bool)
primIsInfiniteFloat _ x = (isInfinite x)

primIsDenormalizedFloat :: B.D (Float -> Bool)
primIsDenormalizedFloat _ x = (isDenormalized x)

primIsNegativeZeroFloat :: B.D (Float -> Bool)
primIsNegativeZeroFloat _ x = (isNegativeZero x)

primIsIEEEFloat :: B.D (Float -> Bool)
primIsIEEEFloat _ x = (isIEEE x)

primATan2Float :: B.D (Float -> Float -> Float)
primATan2Float _ x y = (atan2 x y)

primFloatRadixDouble :: B.D (Double -> Integer)
primFloatRadixDouble _ x = (floatRadix x)

primFloatDigitsDouble :: B.D ( Double -> Int)
primFloatDigitsDouble _ x = (floatDigits x)

primFloatRangeDouble :: B.D (Double -> (Int, Int))
primFloatRangeDouble _ x = (floatRange x)

primDecodeFloatDouble :: B.D (Double -> (Integer, Int))
primDecodeFloatDouble _ x = (decodeFloat x)

primEncodeFloatDouble :: B.D (Integer -> Int -> Double)
primEncodeFloatDouble _ x y = (encodeFloat x y)

primIsNaNDouble :: B.D (Double -> Bool)
primIsNaNDouble _ x = (isNaN x)

primIsInfiniteDouble :: B.D ( Double -> Bool)
primIsInfiniteDouble _ x = (isInfinite x)

primIsDenormalizedDouble :: B.D (Double -> Bool)
primIsDenormalizedDouble _ x = (isDenormalized x)

primIsNegativeZeroDouble :: B.D (Double -> Bool)
primIsNegativeZeroDouble _ x = (isNegativeZero x)

primIsIEEEDouble :: B.D (Double -> Bool)
primIsIEEEDouble _ x = (isIEEE x)

primATan2Double :: B.D (Double -> Double -> Double)
primATan2Double _ x y = (atan2 x y)

primLex :: B.D (String -> [(String, String)])
primLex _ s = (lex s)

primReadLitChar :: B.D (String -> [(Char, String)])
primReadLitChar _ s = (Char.readLitChar s)

primLexLitChar :: B.D (String -> [(String, String)])
primLexLitChar _ s = (Char.lexLitChar s)

primReadsPrecInt :: B.D (Int -> String -> [(Int, String)])
primReadsPrecInt _ i s = (readsPrec i s)

primReadsPrecInteger :: B.D (Int -> String -> [(Integer, String)])
primReadsPrecInteger _ i s = (readsPrec i s)

primReadsPrecFloat :: B.D (Int -> String -> [(Float, String)])
primReadsPrecFloat _ i s = (readsPrec i s)

primReadsPrecDouble :: B.D (Int -> String -> [(Double, String)])
primReadsPrecDouble _ i s = (readsPrec i s)

primCpuTimePrecision :: B.D (Integer)
primCpuTimePrecision _ = (CPUTime.cpuTimePrecision)

primUserError :: B.D (String -> IOError)
#if __GLASGOW_HASKELL__ < 600
primUserError _ s = (userError s) 
#endif

#if __GLASGOW_HASKELL__ >= 600
primUserError _ s = (IOException (userError s))
#endif
