module RandomPrims_B ( Random.StdGen
                     , primShowStdGen
                     , primReadsPrecStdGen
                     , primNextStdGen
                     , primSplitStdGen
                     , primMkStdGen
                     , primNewStdGen
                     , primSetStdGen
                     , primGetStdGen
                     , primGetStdRandom
                     , primGenRangeStdGen
                     ) where

import Prelude

import qualified Random ( 
                        , StdGen
                        , mkStdGen
                        , RandomGen (..)
                        , Random (..)
                        , newStdGen
                        , setStdGen
                        , getStdGen
                        , getStdRandom
                        )

import qualified Buddha as B (D, F, app) 

import qualified IOPrims_B ( IO, threadIO )

primShowStdGen :: B.D (Random.StdGen -> String)
primShowStdGen _ stdGen = (show stdGen)

primReadsPrecStdGen :: B.D (Int -> String -> [(Random.StdGen, String)])
primReadsPrecStdGen _ i s = (readsPrec i s)

primGenRangeStdGen :: B.D (Random.StdGen -> (Int, Int))
primGenRangeStdGen _ stdGen = (Random.genRange stdGen)

primNextStdGen :: B.D (Random.StdGen -> (Int, Random.StdGen))
primNextStdGen _ stdGen = (Random.next stdGen)

primSplitStdGen :: B.D (Random.StdGen -> (Random.StdGen, Random.StdGen))
primSplitStdGen _ stdGen = (Random.split stdGen)

primMkStdGen :: Int -> B.D Random.StdGen
primMkStdGen _ i = (Random.mkStdGen i)

primNewStdGen :: B.D (IOPrims_B.IO Random.StdGen)
primNewStdGen _ = (IOPrims_B.threadIO Random.newStdGen)

primSetStdGen :: B.D (Random.StdGen -> (IOPrims_B.IO ()))
primSetStdGen _ stdGen = (IOPrims_B.threadIO (Random.setStdGen stdGen))
 
primGetStdGen :: B.D (IOPrims_B.IO Random.StdGen)
primGetStdGen _ = (IOPrims_B.threadIO Random.getStdGen)

-- XXX we lose some of the EDT here due to the use of origFun
-- but there is little we can do without looking deeper into the internals
-- of the GHC implementation
primGetStdRandom :: B.D ((B.F Random.StdGen (a, Random.StdGen)) -> (IOPrims_B.IO a))
primGetStdRandom _ f
   = (IOPrims_B.threadIO (Random.getStdRandom (B.app f)))
