module Random_B
       (RandomGen(next, split, genRange), RandomPrims_B.StdGen, mkStdGen,
	Random(random, randomR, randoms, randomRs, randomIO, randomRIO),
	getStdRandom, getStdGen, setStdGen, newStdGen)
       where
import qualified Buddha as B
import qualified Prelude_B
import Prelude_B (fromInteger, fromRational)
import RandomPrims_B (StdGen, primShowStdGen, primReadsPrecStdGen,
		      primGenRangeStdGen, primNextStdGen, primSplitStdGen, primMkStdGen,
		      primNewStdGen, primSetStdGen, primGetStdGen, primGetStdRandom)
import Prelude_B
import Char_B (ord, chr)
v0 = B.ps "Random"
 
class RandomGen g where
    
   genRange :: B.D (g -> (Int, Int))
    
   next :: B.D (g -> (Int, g))
    
   split :: B.D (g -> (g, g))
 
instance RandomGen RandomPrims_B.StdGen where
   genRange v16 g = (RandomPrims_B.primGenRangeStdGen v16 g)
   next v17 g = (RandomPrims_B.primNextStdGen v17 g)
   split v18 g = (RandomPrims_B.primSplitStdGen v18 g)
 
instance Read RandomPrims_B.StdGen where
   readsPrec v19 i s = (RandomPrims_B.primReadsPrecStdGen v19 i s)
 
instance Show RandomPrims_B.StdGen where
   show v20 g = (RandomPrims_B.primShowStdGen v20 g)
 
mkStdGen :: B.D (Int -> RandomPrims_B.StdGen)
mkStdGen v21 i = (RandomPrims_B.primMkStdGen v21 i)
 
class Random a where
    
   random :: (RandomGen g) => B.D (g -> (a, g))
    
   randomR :: (RandomGen g) => B.D ((a, a) -> g -> (a, g))
    
   randoms :: (RandomGen g) => B.D (g -> [a])
   randoms v22 g
     = (B.app (B.fu1 (\ v23@(x, g') -> (:) x ((randoms v22 g'))))
	  ((random v22 g)))
    
   randomRs :: (RandomGen g) => B.D ((a, a) -> g -> [a])
   randomRs v28 ival g = (:) (x v28) ((randomRs v28 ival (g' v28)))
     where
	v25 = \ v24 -> (randomR v24 ival g)
	x = \ v26 -> (\ (x, g') -> x) (v25 v26)
	g' = \ v27 -> (\ (x, g') -> g') (v25 v27)
    
   randomIO :: B.D (IO a)
   randomIO = \ v29 -> (getStdRandom v29 (B.fu1 (random v29)))
    
   randomRIO :: B.D ((a, a) -> IO a)
   randomRIO v30 range
     = (getStdRandom v30 ((B.fu1 (randomR v30 range))))
 
instance Random Int where
   randomR v31 v1 g
     = case v1 of
	  (a, b) -> (randomIvalInteger v31
		       ((toInteger v31 a), (toInteger v31 b))
		       g)
   random v32 g = (randomR v32 ((minBound v32), (maxBound v32)) g)
 
randomIvalInteger ::
		  (RandomGen g, Num a) => B.D ((Integer, Integer) -> g -> (a, g))
randomIvalInteger v33 v8 rng
  = case v8 of
       (l, h) -> let k = \ v34 -> ((+) v34 (((-) v34 h l)) 1)
		     b = \ v35 -> 2147483561
		     n = \ v36 -> (iLogBase v36 (b v36) (k v36))
		     f v37 v2 v3 v4
		       = let v5 = \ v39 -> (v2, v3, v4) in
			   let v6
				 = \ v41 ->
				     case (v5 v41) of
					(n, acc, g) -> let v43 = \ v42 -> (next v42 g)
							   x = \ v44 -> (\ (x, g') -> x) (v43 v44)
							   g' = \ v45 -> (\ (x, g') -> g') (v43 v45)
							 in
							 (f v41 (((-) v41 n 1))
							    (((+) v41 ((fromIntegral v41 (x v41)))
								(((*) v41 acc (b v41)))))
							    (g' v41))
					_ -> (Prelude_B.error v41 "No Match")
			     in
			     case (v5 v37) of
				(v7, acc, g) -> case ((Prelude_B.==) v37 v7 0) of
						   True -> (acc, g)
						   False -> (v6 v37)
				_ -> (v6 v37)
		   in
		   case ((>) v33 l h) of
		      True -> (randomIvalInteger v33 (h, l) rng)
		      False -> case (otherwise v33) of
				  True -> case ((f v33 (n v33) 1 rng)) of
					     (v, rng') -> ((fromInteger_bUdDhA v33
							      (((+) v33 l ((mod v33 v (k v33)))))),
							   rng')
 
iLogBase :: B.D (Integer -> Integer -> Integer)
iLogBase v46 b i
  = case ((<) v46 i b) of
       True -> 1
       False -> ((+) v46 1 ((iLogBase v46 b ((div v46 i b)))))
 
instance Random Integer where
   randomR v47 ival g = (randomIvalInteger v47 ival g)
   random v48 g
     = (randomR v48
	  ((toInteger v48 ((minBound v48) :: Int)),
	   (toInteger v48 ((maxBound v48) :: Int)))
	  g)
 
instance Random Float where
   random v49 g
     = (randomIvalDouble v49 (0 :: Double, 1) (B.fu1 (realToFrac v49))
	  g)
   randomR v50 v9 g
     = case v9 of
	  (a, b) -> (randomIvalDouble v50
		       ((realToFrac v50 a), (realToFrac v50 b))
		       (B.fu1 (realToFrac v50))
		       g)
 
instance Random Double where
   randomR v51 ival g = (randomIvalDouble v51 ival (B.fu1 (id v51)) g)
   random v52 g = (randomR v52 (0 :: Double, 1) g)
 
randomIvalDouble ::
		 (RandomGen g, Fractional a) =>
		   B.D ((Double, Double) -> B.F Double a -> g -> (a, g))
randomIvalDouble v53 v10 fromDouble rng
  = case v10 of
       (l, h) -> case ((>) v53 l h) of
		    True -> (randomIvalDouble v53 (h, l) fromDouble rng)
		    False -> case (otherwise v53) of
				True -> case
					  ((randomIvalInteger v53
					      ((toInteger v53 ((minBound v53) :: Int)),
					       (toInteger v53 ((maxBound v53) :: Int)))
					      rng))
					  of
					   (x, rng') -> let scaled_x
							      = \ v54 ->
								  ((+) v54
								     ((B.app fromDouble
									 (((/) v54 (((+) v54 l h))
									     2))))
								     (((*) v54
									 ((B.app fromDouble
									     (((/) v54
										 (((-) v54 h l))
										 ((realToFrac v54
										     (intRange
											v54)))))))
									 ((fromIntegral v54
									     (x :: Int))))))
							  in ((scaled_x v53), rng')
 
intRange :: B.D Integer
intRange
  = \ v55 ->
      ((-) v55 ((toInteger v55 ((maxBound v55) :: Int)))
	 ((toInteger v55 ((minBound v55) :: Int))))
 
instance Random Char where
   randomR v56 v11 g
     = case v11 of
	  (a, b) -> case
		      ((randomIvalInteger v56
			  ((toInteger v56 ((ord v56 a))), (toInteger v56 ((ord v56 b))))
			  g))
		      of
		       (x, g) -> ((chr v56 x), g)
   random v57 g = (randomR v57 ((minBound v57), (maxBound v57)) g)
 
instance Random Bool where
   randomR v58 v15 g
     = case v15 of
	  (a, b) -> let bool2Int v59 v12
			  = case v12 of
			       False -> (0 :: Integer)
			       True -> (1 :: Integer)
			 
			int2Bool :: B.D (Integer -> Bool)
			int2Bool v60 v13
			  = let v14 = \ v62 -> True in
			      case ((Prelude_B.==) v60 v13 0) of
				 True -> False
				 False -> (v14 v60)
		      in
		      case
			((randomIvalInteger v58
			    ((toInteger v58 ((bool2Int v58 a))),
			     (toInteger v58 ((bool2Int v58 b))))
			    g))
			of
			 (x, g) -> ((int2Bool v58 x), g)
   random v63 g = (randomR v63 ((minBound v63), (maxBound v63)) g)
 
newStdGen :: B.D (IO RandomPrims_B.StdGen)
newStdGen = \ v64 -> (RandomPrims_B.primNewStdGen v64)
 
setStdGen :: B.D (RandomPrims_B.StdGen -> IO ())
setStdGen v65 g = (RandomPrims_B.primSetStdGen v65 g)
 
getStdGen :: B.D (IO RandomPrims_B.StdGen)
getStdGen = \ v66 -> (RandomPrims_B.primGetStdGen v66)
 
getStdRandom ::
	       B.D (B.F RandomPrims_B.StdGen (a, RandomPrims_B.StdGen) -> IO a)
getStdRandom v67 f = (RandomPrims_B.primGetStdRandom v67 f)