-- a little bit broken because everything requires Prelude.Integral
-- so this won't work for user instances of Integral
-- problem is that it is difficult to replace Rational in the Prelude
-- with another type becuase of fromRational, it seems to insist on
-- refering to the GHC version of that type rather than the one that
-- is in scope, sigh.

module RatioPrims_B 
          ( Ratio
          , Rational
          , (%)
          , numerator
          , denominator
          , approxRational ) 
     where

import Ratio (Ratio, Rational)
import qualified Ratio ((%), numerator, denominator, approxRational)
import Buddha as B
import qualified Prelude_B
import qualified Prelude

(%) :: (Prelude.Integral a) => B.D (a -> a -> (Ratio a))
(%) _ a b = (a Ratio.% b)

numerator, denominator :: (Prelude.Integral a) => B.D (Ratio a -> a)
numerator _ r   = (Ratio.numerator r)
denominator _ r = (Ratio.denominator r)

approxRational :: (Prelude.RealFrac a) => B.D (a -> a -> Rational)
approxRational _ a b = (Ratio.approxRational a b)

instance (Prelude.Integral a) => Prelude_B.Eq (Ratio a) where
    (==) _ x y = x Prelude.== y

instance  (Prelude.Integral a)  => Prelude_B.Ord (Ratio a) where
    (<=) _ x y = x Prelude.<= y
    (<) _ x y  = x Prelude.< y

instance (Prelude.Integral a) => Prelude_B.Num (Ratio a) where
    (+) _ x y = (x Prelude.+ y) 
    (*) _ x y = (x Prelude.* y) 
    negate_bUdDhA _ x = (Prelude.negate x)
    abs _ x = (Prelude.abs x)
    signum _ x = (Prelude.signum x)
    fromInteger_bUdDhA _ x = (Prelude.fromInteger x)

instance (Prelude.Integral a) => Prelude_B.Real (Ratio a) where
    toRational _ x = (Prelude.toRational x) 

instance  (Prelude.Integral a)  => Prelude_B.Fractional (Ratio a)  where
    (/) _ x y = (x Prelude./ y) 
    recip _ x = (Prelude.recip x)
    fromRational_bUdDhA _ x = (Prelude.fromRational x)

{- XXX can't get this to work -}
instance (Prelude.Integral a) => Prelude_B.RealFrac (Ratio a)  where
    properFraction _ x = Prelude.undefined 


instance (Prelude.Integral a) => Prelude_B.Enum (Ratio a)  where
    succ _ x           = (Prelude.succ x) 
    pred _ x           = (Prelude.pred x) 
    toEnum _ x         = (Prelude.toEnum x)
    fromEnum _ x       = (Prelude.fromEnum x) 
    enumFrom _ x       = (Prelude.enumFrom x) 
    enumFromThen _ x y = (Prelude.enumFromThen x y) 
    enumFromTo _ x y   = (Prelude.enumFromTo x y)
    enumFromThenTo _ x y z = (Prelude.enumFromThenTo x y z)

instance  (Prelude.Read a, Prelude.Integral a)  => Prelude_B.Read (Ratio a)  where
    readsPrec _ p s = (Prelude.readsPrec p s)

instance  (Prelude.Integral a)  => Prelude_B.Show (Ratio a)  where
    showsPrec _ p x s = (Prelude.showsPrec p x s)
