module SystemPrims_B 
   ( S.ExitCode(ExitSuccess,ExitFailure)
   , getArgs
   , getProgName
   , getEnv
   , system
   , exitWith
   , exitFailure
   , primExitCodeEq
   , primExitCodeLte
   , primExitCodeReadsPrec
   , primExitCodeShowsPrec
   ) where

import qualified IOPrims_B
                 ( IO
                 , threadIO )

import Buddha as B ( D )

import qualified System as S
                ( ExitCode(ExitSuccess,ExitFailure)
                , getArgs
                , getProgName
                , getEnv
                , system
                , exitWith
                , exitFailure )

import Prelude

getArgs  :: B.D (IOPrims_B.IO [String])
getArgs _ = (IOPrims_B.threadIO S.getArgs)

getProgName  :: B.D (IOPrims_B.IO String)
getProgName _ = (IOPrims_B.threadIO S.getProgName)

getEnv :: B.D (String -> (IOPrims_B.IO String))
getEnv _ s = (IOPrims_B.threadIO (S.getEnv s))

system :: B.D (String -> (IOPrims_B.IO S.ExitCode))
system _ s = (IOPrims_B.threadIO (S.system s))

exitWith :: B.D (S.ExitCode -> (IOPrims_B.IO a))
exitWith _ c = (IOPrims_B.threadIO (S.exitWith c))

exitFailure :: B.D (IOPrims_B.IO a)
exitFailure _ = (IOPrims_B.threadIO S.exitFailure)

primExitCodeEq :: B.D (S.ExitCode -> S.ExitCode -> Bool)
primExitCodeEq _ e1 e2 = (e1 == e2)

primExitCodeLte :: B.D (S.ExitCode -> S.ExitCode -> Bool)
primExitCodeLte _ e1 e2 = (e1 <= e2)

primExitCodeShowsPrec :: B.D (Int -> S.ExitCode -> String -> String)
primExitCodeShowsPrec _ i e s = showsPrec i e s

primExitCodeReadsPrec :: B.D (Int -> String -> [(S.ExitCode, String)])
primExitCodeReadsPrec _ i s = readsPrec i s
