{- hand build intermediate file for the Time Prims 
   do not edit me unless you know what you are doing -}

{- The module name -}

module TimePrims where

{- The ident info for all constructors and top level identifiers -}

idents = [ (primGetClockTime, LetConst, 0)
         , (primEqClockTime, LetFun, 2)
         , (primLteClockTime, LetFun, 2)
         , (tdYear, LetFun, 1)
         , (tdMonth, LetFun, 1)
         , (tdDay, LetFun, 1)
         , (tdHour, LetFun, 1)
         , (tdMin, LetFun, 1)
         , (tdSec, LetFun, 1)
         , (tdPicosec, LetFun, 1)
         , (primAddToClockTime, LetFun, 2)
         , (primTimeDiffEq, LetFun, 2)
         , (primTimeDiffLte, LetFun, 2)
         , (primTimeDiffReadsPrec, LetFun, 2)
         , (primTimeDiffShowsPrec, LetFun, 3)
         , (TimeDiff, Con, 7)
         , (Sunday, Con, 0)
         , (Monday, Con, 0)
         , (Tuesday, Con, 0)
         , (Wednesday, Con, 0)
         , (Thursday, Con, 0)
         , (Friday, Con, 0)
         , (Saturday, Con, 0)
         , (January, Con, 0)
         , (February, Con, 0)
         , (March, Con, 0)
         , (April, Con, 0)
         , (May, Con, 0)
         , (June, Con, 0)
         , (July, Con, 0)
         , (August, Con, 0)
         , (September, Con, 0)
         , (October, Con, 0)
         , (November, Con, 0)
         , (December, Con, 0)
         , (primMonthEq, LetFun, 2)
         , (primMonthLte, LetFun, 2)
         , (primMonthShowsPrec, LetFun, 3)
         , (primMonthReadsPrec, LetFun, 2)
         , (primMonthFromEnum, LetFun, 1)
         , (primMonthToEnum, LetFun, 1)
         , (primMonthRange, LetFun, 1)
         , (primMonthIndex, LetFun, 2)
         , (primMonthInRange, LetFun, 2)
         , (primMonthMinBound, LetConst, 0)
         , (primMonthMaxBound, LetConst, 0)
         , (primDayEq, LetFun, 2)
         , (primDayLte, LetFun, 2)
         , (primDayShowsPrec, LetFun, 3)
         , (primDayReadsPrec, LetFun, 2)
         , (primDayFromEnum, LetFun, 1)
         , (primDayToEnum, LetFun, 1)
         , (primDayRange, LetFun, 1)
         , (primDayIndex, LetFun, 2)
         , (primDayInRange, LetFun, 2)
         , (primDayMinBound, LetConst, 0)
         , (primDayMaxBound, LetConst, 0)
         , (CalendarTime, Con, 12)
         , (ctYear, LetFun, 1)
         , (ctMonth, LetFun, 1)
         , (ctDay, LetFun, 1)
         , (ctHour, LetFun, 1)
         , (ctMin, LetFun, 1)
         , (ctSec, LetFun, 1)
         , (ctPicosec, LetFun, 1)
         , (ctWDay, LetFun, 1)
         , (ctYDay, LetFun, 1)
         , (ctTZName, LetFun, 1)
         , (ctTZ, LetFun, 1)
         , (ctIsDST, LetFun, 1)
         , (primCalendarTimeEq, LetFun, 2)
         , (primCalendarTimeLte, LetFun, 2)
         , (primCalendarTimeShowsPrec, LetFun, 3)
         , (primCalendarTimeReadsPrec, LetFun, 2)
         , (primDiffClockTimes, LetFun, 2)
         , (primToCalendarTime, LetFun, 1)
         , (primToUTCTime, LetFun, 1)
         , (primToClockTime, LetFun, 1)
         , (primFormatCalendarTime, LetFun, 3)
         ]

{- the association information -}


assocs = [ (ClockTime, [])
         , (TimeDiff, [TimeDiff,tdYear,tdMonth,tdDay,tdHour,tdMin,tdSec,tdPicosec])
         , (Month, [January, February, March, April, May, June, July, August,
                    September, October, November, December])
         , (Day, [Sunday, Monday, Tuesday, Wednesday, Thursday, Friday, Saturday])
         , (CalendarTime, [CalendarTime, ctYear, ctMonth, ctDay, ctHour, ctMin, ctSec, 
                           ctPicosec, ctWDay, ctYDay, ctTZName, ctTZ, ctIsDST])
         ]

{- the infix rules should be empty -}

fixity = []

{- type synonyms -}

{- records -}

records = [(TimeDiff, [tdYear,tdMonth,tdDay,tdHour,tdMin,tdSec,tdPicosec])
          , (CalendarTime, [ctYear, ctMonth, ctDay, ctHour, ctMin, ctSec, 
                           ctPicosec, ctWDay, ctYDay, ctTZName, ctTZ, ctIsDST])]
