module TimePrims_B ( T.ClockTime 
                   , T.TimeDiff (TimeDiff)
                   , tdYear
                   , tdMonth
                   , tdDay
                   , tdHour
                   , tdMin
                   , tdSec 
                   , tdPicosec 
                   , T.CalendarTime (CalendarTime)
                   , ctYear
                   , ctMonth
                   , ctDay, ctHour, ctMin, ctSec
                   , ctPicosec
                   , ctWDay
                   , ctYDay
                   , ctTZName
                   , ctTZ
                   , ctIsDST
                   , primCalendarTimeEq
                   , primCalendarTimeLte
                   , primCalendarTimeReadsPrec
                   , primCalendarTimeShowsPrec
                   , primEqClockTime
                   , primLteClockTime
                   , primGetClockTime 
                   , primAddToClockTime 
                   , primTimeDiffEq
                   , primTimeDiffLte
                   , primTimeDiffReadsPrec
                   , primTimeDiffShowsPrec
                   , T.Month (..)
                   , primMonthEq
                   , primMonthLte
                   , primMonthShowsPrec
                   , primMonthReadsPrec
                   , primMonthFromEnum
                   , primMonthToEnum
                   , primMonthRange
                   , primMonthIndex
                   , primMonthInRange
                   , primMonthMinBound 
                   , primMonthMaxBound 
                   , T.Day (..)
                   , primDayEq
                   , primDayLte
                   , primDayShowsPrec
                   , primDayReadsPrec
                   , primDayFromEnum
                   , primDayToEnum
                   , primDayIndex
                   , primDayRange
                   , primDayInRange
                   , primDayMinBound 
                   , primDayMaxBound 
                   , primDiffClockTimes 
                   , primToCalendarTime 
                   , primToUTCTime 
                   , primToClockTime 
                   , primFormatCalendarTime 
                   ) where

import IOPrims_B (IO, threadIO )
import Buddha as B (D)
import qualified Time as T
import qualified System.Locale as L
import Prelude hiding (IO)
import Ix (range, inRange, index)

primGetClockTime :: B.D (IO T.ClockTime)
primGetClockTime _ = threadIO $ T.getClockTime

primEqClockTime :: B.D (T.ClockTime -> T.ClockTime -> Bool)
primEqClockTime _ ct1 ct2 = (ct1 == ct2) 

primLteClockTime :: B.D (T.ClockTime -> T.ClockTime -> Bool)
primLteClockTime _ ct1 ct2 = (ct1 <= ct2) 

primAddToClockTime :: B.D (T.TimeDiff -> T.ClockTime -> (T.ClockTime))
primAddToClockTime _ td ct = (T.addToClockTime td ct)

tdYear , tdMonth , tdDay , tdHour , tdMin , tdSec  :: B.D (T.TimeDiff -> Int)
tdYear _ td = (T.tdYear td)
tdMonth _ td = (T.tdMonth td)
tdDay _ td = (T.tdDay td)
tdHour _ td = (T.tdHour td)
tdMin _ td = (T.tdMin td)
tdSec _ td = (T.tdSec td)
tdPicosec :: B.D (T.TimeDiff -> Integer)
tdPicosec _ td = (T.tdPicosec td)

primTimeDiffEq :: B.D (T.TimeDiff -> T.TimeDiff -> Bool)
primTimeDiffEq _ t1 t2 = (t1 == t2)

primTimeDiffLte :: B.D (T.TimeDiff -> T.TimeDiff -> Bool)
primTimeDiffLte _ t1 t2 = (t1 <= t2)

primTimeDiffReadsPrec :: B.D (Int -> String -> [(T.TimeDiff, String)])
primTimeDiffReadsPrec _ i s = (readsPrec i s)

primTimeDiffShowsPrec :: B.D (Int -> T.TimeDiff -> String -> String)
primTimeDiffShowsPrec _ i td s = (showsPrec i td s)

primMonthEq :: B.D (T.Month -> T.Month -> Bool)
primMonthEq _ t1 t2 = (t1 == t2)

primMonthLte :: B.D (T.Month -> T.Month -> Bool)
primMonthLte _ t1 t2 = (t1 <= t2)

primMonthShowsPrec :: B.D (Int -> T.Month -> String -> String)
primMonthShowsPrec _ i m s = (showsPrec i m s)

primMonthReadsPrec :: B.D (Int -> String -> [(T.Month, String)])
primMonthReadsPrec _ i s = (readsPrec i s)

primMonthFromEnum :: B.D (T.Month -> Int)
primMonthFromEnum _ t = (fromEnum t)

primMonthToEnum :: B.D (Int -> T.Month)
primMonthToEnum _ i = (toEnum i)

primMonthRange :: B.D ((T.Month, T.Month) -> [T.Month])
primMonthRange _ ts = (range ts) 

primMonthIndex :: B.D ((T.Month,T.Month) -> T.Month -> Int)
primMonthIndex _ ts t = (index ts t)

primMonthInRange :: B.D ((T.Month,T.Month) -> T.Month -> Bool)
primMonthInRange _ ts t = (inRange ts t)

primMonthMinBound :: B.D T.Month
primMonthMinBound _ = minBound

primMonthMaxBound :: B.D T.Month
primMonthMaxBound _ = maxBound

primDayEq :: B.D (T.Day -> T.Day -> Bool)
primDayEq _ t1 t2 = (t1 == t2)

primDayLte :: B.D (T.Day -> T.Day -> Bool)
primDayLte _ t1 t2 = (t1 <= t2)

primDayShowsPrec :: B.D (Int -> T.Day -> String -> String)
primDayShowsPrec _ i m s = (showsPrec i m s)

primDayReadsPrec :: B.D (Int -> String -> [(T.Day, String)])
primDayReadsPrec _ i s = (readsPrec i s)

primDayFromEnum :: B.D (T.Day -> Int)
primDayFromEnum _ t = (fromEnum t)

primDayToEnum :: B.D (Int -> T.Day)
primDayToEnum _ i = (toEnum i)

primDayRange :: B.D ((T.Day, T.Day) -> [T.Day])
primDayRange _ ts = (range ts) 

primDayIndex :: B.D ((T.Day,T.Day) -> T.Day -> Int)
primDayIndex _ ts t = (index ts t)

primDayInRange  :: B.D ((T.Day,T.Day) -> T.Day -> Bool)
primDayInRange _ ts t = (inRange ts t)

primDayMinBound :: B.D T.Day
primDayMinBound _ = minBound

primDayMaxBound :: B.D T.Day
primDayMaxBound _ = maxBound

ctYear :: B.D (T.CalendarTime -> Int)
ctYear _ t = T.ctYear t

ctMonth :: B.D (T.CalendarTime -> T.Month)
ctMonth _ t = T.ctMonth t

ctDay, ctHour, ctMin, ctSec :: B.D (T.CalendarTime -> Int)
ctDay _ t = T.ctDay t
ctHour _ t = T.ctHour t
ctMin _ t = T.ctMin t
ctSec _ t = T.ctSec t

ctPicosec :: B.D (T.CalendarTime -> Integer)
ctPicosec _ t = T.ctPicosec t

ctWDay :: B.D (T.CalendarTime -> T.Day)
ctWDay _ t = T.ctWDay t

ctYDay :: B.D (T.CalendarTime -> Int)
ctYDay _ t = T.ctYDay t

ctTZName :: B.D (T.CalendarTime -> String)
ctTZName _ t = T.ctTZName t

ctTZ :: B.D (T.CalendarTime -> Int)
ctTZ _ t = T.ctTZ t

ctIsDST :: B.D (T.CalendarTime -> Bool)
ctIsDST _ t = T.ctIsDST t

primCalendarTimeEq :: B.D (T.CalendarTime -> T.CalendarTime -> Bool)
primCalendarTimeEq _ t1 t2 = (t1 == t2)

primCalendarTimeLte :: B.D (T.CalendarTime -> T.CalendarTime -> Bool)
primCalendarTimeLte _ t1 t2 = (t1 <= t2)

primCalendarTimeShowsPrec :: B.D (Int -> T.CalendarTime -> String -> String)
primCalendarTimeShowsPrec _ i m s = (showsPrec i m s)

primCalendarTimeReadsPrec :: B.D (Int -> String -> [(T.CalendarTime, String)])
primCalendarTimeReadsPrec _ i s = (readsPrec i s)

primDiffClockTimes :: B.D (T.ClockTime -> T.ClockTime -> T.TimeDiff)
primDiffClockTimes _ ct1 ct2 = T.diffClockTimes ct1 ct2   

primToCalendarTime :: B.D (T.ClockTime -> (IO T.CalendarTime))
primToCalendarTime _ ct = threadIO $ T.toCalendarTime ct 

primToUTCTime :: B.D (T.ClockTime -> T.CalendarTime)
primToUTCTime _ ct = T.toUTCTime ct 

primToClockTime :: B.D (T.CalendarTime -> T.ClockTime)
primToClockTime _ cal = T.toClockTime cal

primFormatCalendarTime :: B.D (L.TimeLocale -> String -> T.CalendarTime -> String)
primFormatCalendarTime _ l s t = T.formatCalendarTime l s t 
