module Time_B
       (ClockTime,
	Month(January, February, March, April, May, June, July, August,
	      September, October, November, December),
	Day(Sunday, Monday, Tuesday, Wednesday, Thursday, Friday,
	    Saturday),
	CalendarTime(CalendarTime), ctYear, ctMonth, ctDay, ctHour, ctMin,
	ctSec, ctPicosec, ctWDay, ctYDay, ctTZName, ctTZ, ctIsDST,
	TimeDiff(TimeDiff), tdYear, tdMonth, tdDay, tdHour, tdMin, tdSec,
	tdPicosec, getClockTime, addToClockTime, diffClockTimes,
	toCalendarTime, toUTCTime, toClockTime, calendarTimeToString,
	formatCalendarTime)
       where
import qualified Buddha as B
import Prelude_B
import Ix_B (Ix(..))
import Locale_B (TimeLocale(..), wDays, months, intervals, amPm,
		 dateTimeFmt, dateFmt, timeFmt, time12Fmt, defaultTimeLocale)
import Char_B (intToDigit)
import TimePrims_B (ClockTime, Month(..), Day(..),
		    CalendarTime(..), ctYear, ctMonth, ctDay, ctHour, ctMin, ctSec,
		    ctPicosec, ctWDay, ctYDay, ctTZName, ctTZ, ctIsDST,
		    primEqClockTime, primLteClockTime, TimeDiff(..), tdYear, tdMonth,
		    tdDay, tdHour, tdMin, tdSec, tdPicosec, primGetClockTime,
		    primAddToClockTime, primTimeDiffEq, primTimeDiffLte,
		    primTimeDiffShowsPrec, primTimeDiffReadsPrec, primMonthEq,
		    primMonthLte, primMonthToEnum, primMonthFromEnum, primMonthRange,
		    primMonthInRange, primMonthIndex, primMonthReadsPrec,
		    primMonthShowsPrec, primMonthMinBound, primMonthMaxBound,
		    primDayEq, primDayLte, primDayToEnum, primDayFromEnum,
		    primDayRange, primDayInRange, primDayIndex, primDayReadsPrec,
		    primDayShowsPrec, primDayMinBound, primDayMaxBound,
		    primCalendarTimeEq, primCalendarTimeLte, primCalendarTimeReadsPrec,
		    primCalendarTimeShowsPrec, primDiffClockTimes, primToCalendarTime,
		    primToUTCTime, primToClockTime, primFormatCalendarTime)
v0 = B.ps "Time"
 
instance Eq ClockTime where
   (v1 == t1) t2 = (primEqClockTime v1 t1 t2)
 
instance Ord ClockTime where
   (v2 <= t1) t2 = (primLteClockTime v2 t1 t2)
 
instance Eq Month where
   (v3 == m1) m2 = (primMonthEq v3 m1 m2)
 
instance Ord Month where
   (v4 <= m1) m2 = (primMonthLte v4 m1 m2)
 
instance Enum Month where
   toEnum v5 i = (primMonthToEnum v5 i)
   fromEnum v6 i = (primMonthFromEnum v6 i)
 
instance Bounded Month where
   minBound = \ v7 -> (primMonthMinBound v7)
   maxBound = \ v8 -> (primMonthMaxBound v8)
 
instance Ix Month where
   range v9 ms = (primMonthRange v9 ms)
   inRange v10 ms m = (primMonthInRange v10 ms m)
   index v11 ms m = (primMonthIndex v11 ms m)
 
instance Read Month where
   readsPrec v12 x y = (primMonthReadsPrec v12 x y)
 
instance Show Month where
   showsPrec v14 x y v13 = (primMonthShowsPrec v14 x y v13)
 
instance Eq Day where
   (v15 == m1) m2 = (primDayEq v15 m1 m2)
 
instance Ord Day where
   (v16 <= m1) m2 = (primDayLte v16 m1 m2)
 
instance Enum Day where
   toEnum v17 i = (primDayToEnum v17 i)
   fromEnum v18 i = (primDayFromEnum v18 i)
 
instance Bounded Day where
   minBound = \ v19 -> (primDayMinBound v19)
   maxBound = \ v20 -> (primDayMaxBound v20)
 
instance Ix Day where
   range v21 ms = (primDayRange v21 ms)
   inRange v22 ms m = (primDayInRange v22 ms m)
   index v23 ms m = (primDayIndex v23 ms m)
 
instance Read Day where
   readsPrec v24 x y = (primDayReadsPrec v24 x y)
 
instance Show Day where
   showsPrec v26 x y v25 = (primDayShowsPrec v26 x y v25)
 
instance Eq CalendarTime where
   (v27 == m1) m2 = (primCalendarTimeEq v27 m1 m2)
 
instance Ord CalendarTime where
   (v28 <= m1) m2 = (primCalendarTimeLte v28 m1 m2)
 
instance Read CalendarTime where
   readsPrec v29 x y = (primCalendarTimeReadsPrec v29 x y)
 
instance Show CalendarTime where
   showsPrec v31 x y v30 = (primCalendarTimeShowsPrec v31 x y v30)
 
instance Eq TimeDiff where
   (v32 == t1) t2 = (primTimeDiffEq v32 t1 t2)
 
instance Ord TimeDiff where
   (v33 <= t1) t2 = (primTimeDiffLte v33 t1 t2)
 
instance Read TimeDiff where
   readsPrec v34 d s = (primTimeDiffReadsPrec v34 d s)
 
instance Show TimeDiff where
   showsPrec v35 i t s = (primTimeDiffShowsPrec v35 i t s)
 
getClockTime :: B.D (IO ClockTime)
getClockTime = \ v36 -> (primGetClockTime v36)
 
addToClockTime :: B.D (TimeDiff -> ClockTime -> ClockTime)
addToClockTime v37 td ct = (primAddToClockTime v37 td ct)
 
diffClockTimes :: B.D (ClockTime -> ClockTime -> TimeDiff)
diffClockTimes v38 ct1 ct2 = (primDiffClockTimes v38 ct1 ct2)
 
toCalendarTime :: B.D (ClockTime -> IO CalendarTime)
toCalendarTime v39 ct = (primToCalendarTime v39 ct)
 
toUTCTime :: B.D (ClockTime -> CalendarTime)
toUTCTime v40 ct = (primToUTCTime v40 ct)
 
toClockTime :: B.D (CalendarTime -> ClockTime)
toClockTime v41 cal = (primToClockTime v41 cal)
 
calendarTimeToString :: B.D (CalendarTime -> [Char])
calendarTimeToString v43 v42
  = (formatCalendarTime v43 (defaultTimeLocale v43) "%c" v42)
 
formatCalendarTime ::
		     B.D (TimeLocale -> [Char] -> CalendarTime -> [Char])
formatCalendarTime v44 t s c = (primFormatCalendarTime v44 t s c)