#! /bin/sh

# this shell script is for building programs that were transformed by buddha
# a declarative debugger for Haskell
# essentially it is just a wrapper for ghc, providing it with the right set
# of flags to compile all the _B.hs files that buddha produces.
# author: Bernie Pope
# see the buddha web page: www.cs.mu.oz.au/~bjpop/buddha

# if the first argument is "silent" then this will not
# cause any (verbose) output from ghc or the script itself

ghc=@ghcpath@

ghcArgs="-O --make -w -package-conf @datadir@/buddha.pkg.conf -prof -package buddha -package buddhaHsBase -package lang -package posix -fglasgow-exts -fno-implicit-prelude -fno-cse -o debug Main.hs"

if [ $# -eq 0 ]; then
   $ghc $ghcArgs
   exit 0
fi

if [ $# -gt 0 ]; then
   if [ $1 = "silent" ]; then
      $ghc -v0 $ghcArgs 
   else
      $ghc $ghcArgs
   fi
fi

exit 0
