{-------------------------------------------------------------------------------

        Copyright:              Bernie Pope 2003

        Module:                 ChatIO 

        Description:            chatty io - uses an IO ref to determine whether
                                to say something or keep its mouth shut
                                used for diagnostic writes in the debugger 

        Primary Authors:        Bernie Pope

-------------------------------------------------------------------------------}

{-
    This file is part of buddha.

    buddha is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    buddha is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with buddha; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
-}

module ChatIO 
   ( chatRef
   , setChat
   , ifChat
   , isChatty
   , ChatLevel (..)  
   ) where

import Data.IORef
import System.IO.Unsafe

--------------------------------------------------------------------------------

data ChatLevel 
   = Silent 
   | Normal 
   | Verbose
   deriving (Enum, Eq, Ord)

-- faking a global variable
chatRef :: IORef ChatLevel 
chatRef = unsafePerformIO $ newIORef Silent 

setChat :: ChatLevel -> IO ()
setChat level = writeIORef chatRef level 

ifChat :: ChatLevel -> IO () -> IO ()
ifChat level action
   = do chatLev <- readIORef chatRef
        case chatLev >= level of
           True -> action
           False -> return ()

isChatty :: ChatLevel -> IO Bool
isChatty level 
   = do currLev <- readIORef chatRef
        return $ level == currLev
