{-------------------------------------------------------------------------------

        Copyright:              Bernie Pope 2003

        Module:                 Error 

        Description:            Error messages

        Primary Authors:        Bernie Pope

-------------------------------------------------------------------------------}

{-
    This file is part of buddha.

    buddha is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    buddha is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with buddha; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
-}

module Error 
   ( abortWithError
   , ErrorCode (..)
   , fatalError
   , notSupported 
   ) where

import IO      
   ( hPutStrLn
   , hFlush
   , stderr
   )

import System  
   ( exitWith
   , ExitCode (..)
   )

import BuddhaName 
   ( buddhaNameVersion )

--------------------------------------------------------------------------------

data ErrorCode  
   = CmdLineError 
   | FileIOError
   | ParseError
   | ImportError
   | ExportError 
   | DeriveError
   | DesugarError
   | EnvironmentError
   | MiscError
   deriving Enum

-- print an error message and abort the program with
-- an appropriate error code
abortWithError :: ErrorCode -> String -> IO a
abortWithError errCode message
   = do hPutStrLn stderr $ buddhaNameVersion ++ " :ERROR: " ++ message
        hFlush stderr
        exitWith $ ExitFailure $ negate (fromEnum errCode + 1)

-- this kind of error is probably due to a bug in the program
fatalError :: String -> Int -> String -> a
fatalError file line string
   = error errorMsg
   where
   errorMsg = buddhaNameVersion ++
              ": a fatal error has occurred:" ++ 
              "\n------\n" ++
              string ++
              "\n------\n" ++
              "this _may_ a bug in buddha\n" ++
              "* if your program is valid Haskell 98 then please report this to the buddha\n" ++
              "* developers citing the error message a small example of the source code\n" ++
              "* that causes it to happen" ++
              "\nbuddha source ref: " ++
              "file = " ++
               file ++
              ", line = " ++
              show line 
 
-- some feature is not yet supported
notSupported :: String -> Int -> String -> a
notSupported file line string
   = error errorMsg
   where
   errorMsg = buddhaNameVersion ++ ": sorry, this feature is not yet supported:" ++ 
              "\n------\n" ++
              string ++
              "\n------\n" ++
              "\nbuddha source ref: " ++
              "file = " ++
               file ++
              ", line = " ++
              show line 
