{-# OPTIONS -cpp #-}
{-------------------------------------------------------------------------------

        Copyright:              Bernie Pope 2003

        Module:                 IfaceUtils

        Description:            Generic interface utilities that don't have a 
                                good home anywhere else.

        Primary Authors:        Bernie Pope

-------------------------------------------------------------------------------}

{-
    This file is part of buddha.

    buddha is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    buddha is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with buddha; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
-}

module IfaceUtils 
   ( IdentQual (..) 
   , insertMap 
   , insertMap_C
   , addListItemsToMap
   , addListItemsToMap_C
   ) where

import Data.FiniteMap

import Language.Haskell.Syntax

import Error 
   ( fatalError )

--------------------------------------------------------------------------------

-- how an item is imported/exported
data IdentQual
   = Qualified        -- striclty qualified only
   | UnQualified      -- pattern vars and local vars (strictly unqualified)
   | QualAndUnQual    -- top-levels, class members, datacons, unqualified imports
   deriving (Read, Eq, Ord, Show)

-- updating the various lookup tables:

-- used by AssocMap, IdentMap, InfixMap

insertMap :: IdentQual
          -> FiniteMap HsQName b 
          -> HsQName 
          -> b 
          -> FiniteMap HsQName b 
insertMap = insertMap_C (\old new -> new)

insertMap_C :: (b -> b -> b)
            -> IdentQual
            -> FiniteMap HsQName b 
            -> HsQName 
            -> b 
            -> FiniteMap HsQName b 
insertMap_C combiner qualification thisMap qName entry
   = case qualification of
     Qualified
        -> case qName of
              Qual mod name   -> addToFM_C combiner thisMap qName entry
              Special specCon -> addToFM_C combiner thisMap qName entry
              UnQual name
                 -> fatalError 
                       __FILE__ __LINE__ $ 
                          "insertMap_C: attempt to insert unqualified assoc when it must be qualified: " ++
                                 show qName
     UnQualified
        -> case qName of
              UnQual name     -> addToFM_C combiner thisMap qName entry
              Special specCon -> addToFM_C combiner thisMap qName entry
              Qual mod name   -> addToFM_C combiner thisMap (UnQual name) entry
     QualAndUnQual
        -> case qName of
              Qual mod name
                 -> let map1 = addToFM_C combiner thisMap qName entry
                    in  addToFM_C combiner map1 (UnQual name) entry
              UnQual name
                 -> fatalError __FILE__ __LINE__ $ "insertMap_C: attempt to insert an unqualified ident when it must be qualified: " ++
                                 show qName
              Special specCon -> addToFM_C combiner thisMap qName entry

addListItemsToMap :: IdentQual -> [(HsQName, b)] -> FiniteMap HsQName b -> FiniteMap HsQName b 
addListItemsToMap = addListItemsToMap_C (\old new -> new)

addListItemsToMap_C :: (b -> b -> b) 
                    -> IdentQual
                    -> [(HsQName, b)]
                    -> FiniteMap HsQName b 
                    -> FiniteMap HsQName b 
addListItemsToMap_C combiner idQual [] thisMap = thisMap 
addListItemsToMap_C combiner idQual ((qName,entry):rest) thisMap 
  = addListItemsToMap_C combiner idQual rest $ 
                  insertMap_C combiner idQual thisMap qName entry

