-----------------------------------------------------------------------------
-- PPrint:	Print functions
-- This file was originally part of Typing Haskell in Haskell by Mark
-- Jones
-----------------------------------------------------------------------------

module PPrint(module PPrint, module Text.PrettyPrint) where
import Text.PrettyPrint 

-----------------------------------------------------------------------------
-- This module contains definitions that do not appear in the
-- typeset version of the paper.

-----------------------------------------------------------------------------
-- Pretty printing; a replacement for Show:

pretty  :: PPrint a => a -> String
pretty   = render . pprint

ppParen    :: Bool -> Doc -> Doc
ppParen t x = if t then parens x else x

class PPrint a where
  pprint    :: a -> Doc

  parPprint :: a -> Doc
  parPprint  = parens . pprint

  pplist    :: [a] -> Doc
  pplist    xs = brackets (cat (punctuate comma (map pprint xs)))

  pptuple   :: [a] -> Doc
  pptuple   xs = parens (hcat (punctuate comma (map pprint xs)))

instance PPrint a => PPrint [a] where
  pprint  = pplist

instance PPrint Char where
  pprint  = char
  pplist  = doubleQuotes . text

instance PPrint Integer where
  pprint  = integer

instance PPrint Int where
  pprint  = int

instance PPrint Float where
  pprint  = float

instance PPrint Double where
  pprint  = double

instance (PPrint a, PPrint b) => PPrint (a,b) where
  pprint (x,y) = parens (sep [pprint x <> comma, pprint y])

instance (PPrint a, PPrint b, PPrint c) => PPrint (a,b,c) where
  pprint (x,y,z) = parens (sep [pprint x <> comma,
                                pprint y <> comma,
                                pprint z])

instance (PPrint a, PPrint b, PPrint c, PPrint d) => PPrint (a,b,c,d) where
  pprint (w,x,y,z) = parens (sep [pprint w <> comma,
                                  pprint x <> comma,
                                  pprint y <> comma,
                                  pprint z])


instance (PPrint a) => PPrint (Maybe a) where
   pprint (Just x) = text "Just" <+> pprint x
   pprint Nothing  = text "Nothing"

-----------------------------------------------------------------------------
