{-------------------------------------------------------------------------------

        Copyright:              Bernie Pope 2003

        Module:                 ParserUtils

        Description:            Generic parsing utilities that don't have a 
                                good home anywhere else.

        Primary Authors:        Bernie Pope

-------------------------------------------------------------------------------}

{-
    This file is part of buddha.

    buddha is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    buddha is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with buddha; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
-}

module ParserUtils 
   ( parseHsSource ) 
   where

import Language.Haskell.Syntax 
  ( HsModule
  , SrcLoc (..) 
  )

import Language.Haskell.Parser 
  ( parseModuleWithMode 
  , ParseResult (..)
  , ParseMode (..)
  )

import Error           
   ( abortWithError
   , ErrorCode (..) 
   )

import PPrint 

--------------------------------------------------------------------------------

-- call the haskell parser and check for errors
parseHsSource :: FilePath -> String -> IO HsModule
parseHsSource filename s 
   = case parseModuleWithMode (ParseMode filename) s of
              ParseOk e -> return e
              ParseFailed loc err 
                        -> abortWithError ParseError $ 
                                  "parse error at position " ++ 
                                         pretty loc 

-- make SrcLoc pretty
instance PPrint SrcLoc where
   pprint (SrcLoc fn line col) 
      = text "line =" <+> pprint line 
                      <> char ',' 
                      <+> text "column = "
                      <> pprint col
                      <+> text "in file"
                      <+> text fn

