{-------------------------------------------------------------------------------

        Copyright:              Bernie Pope 2003

        Module:                 Stack 

        Description:            A typical stack

        Primary Authors:        Bernie Pope

-------------------------------------------------------------------------------}

{-
    This file is part of buddha.

    buddha is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    buddha is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with buddha; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
-}

module Stack 
   ( emptyStack 
   , pushStack
   , popStack
   , peekStack
   , isEmptyStack
   , modifyTop
   , Stack 
   ) where

--------------------------------------------------------------------------------

type Stack a = [a]

emptyStack :: Stack a
emptyStack = []

isEmptyStack :: Stack a -> Bool
isEmptyStack [] = True
isEmptyStack _  = False

pushStack :: a -> Stack a -> Stack a
pushStack x stack = x : stack

popStack :: Stack a -> Maybe (a, Stack a)
popStack stack
   | isEmptyStack stack = Nothing
   | otherwise = case stack of (top : bottom) -> Just (top, bottom)

peekStack :: Stack a -> Maybe a
peekStack stack
   = case popStack stack of
        Nothing -> Nothing
        Just (top, _bottom) -> Just top

modifyTop :: (a -> a) -> Stack a -> Maybe (Stack a) 
modifyTop f stack
   = case popStack stack of
        Nothing -> Nothing
        Just (top, bottom)
           -> Just $ pushStack (f top) bottom
