{-------------------------------------------------------------------------------

        Copyright:              Bernie Pope 2003

        Module:                 Statistics

        Description:            Useful stats about the program being 
                                transformed.

        Primary Authors:        Bernie Pope

-------------------------------------------------------------------------------}

{-
    This file is part of buddha.

    buddha is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    buddha is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with buddha; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
-}

module Statistics where

data Statistics
   = Stats 
     { stats_partialAps       :: !Int
     , stats_saturatedAps     :: !Int
     , stats_overSaturatedAps :: !Int
     , stats_lambdas          :: !Int
     , stats_constants        :: !Int
     , stats_miscAps          :: !Int
     , stats_patVarAps        :: !Int
     }

initStats :: Statistics
initStats
   = Stats
     { stats_partialAps       = 0 
     , stats_saturatedAps     = 0 
     , stats_overSaturatedAps = 0 
     , stats_lambdas          = 0 
     , stats_constants        = 0
     , stats_miscAps          = 0
     , stats_patVarAps        = 0
     }

showStats :: Statistics -> String
showStats stats
   = "       partial applications = " ++ show (stats_partialAps stats) ++ "\n" ++
     "     saturated applications = " ++ show (stats_saturatedAps stats) ++ "\n" ++
     "over saturated applications = " ++ show (stats_overSaturatedAps stats) ++ "\n" ++
     " miscellaneous applications = " ++ show (stats_miscAps stats) ++ "\n" ++
     "   applications of pat vars = " ++ show (stats_patVarAps stats) ++ "\n" ++
     "        lambda abstractions = " ++ show (stats_lambdas stats) ++ "\n" ++
     "   constant vars refered to = " ++ show (stats_constants stats) 
 

incPartialStatBy :: Int -> Statistics -> Statistics
incPartialStatBy inc stat
   = stat { stats_partialAps = old + inc }
   where
   old = stats_partialAps stat

incSaturatedStatBy :: Int -> Statistics -> Statistics
incSaturatedStatBy inc stat
   = stat { stats_saturatedAps = old + inc }
   where
   old = stats_saturatedAps stat

incOverSatStatBy :: Int -> Statistics -> Statistics
incOverSatStatBy inc stat
   = stat { stats_overSaturatedAps = old + inc }
   where
   old = stats_overSaturatedAps stat

incLambdaStatBy :: Int -> Statistics -> Statistics
incLambdaStatBy inc stat
   = stat { stats_lambdas = old + inc }
   where
   old = stats_lambdas stat

incConstantsStatBy :: Int -> Statistics -> Statistics
incConstantsStatBy inc stat
   = stat { stats_constants = old + inc }
   where
   old = stats_constants stat

incMiscApsStatBy :: Int -> Statistics -> Statistics
incMiscApsStatBy inc stat
   = stat { stats_miscAps = old + inc }
   where 
   old = stats_miscAps stat

incPatVarApStatBy :: Int -> Statistics -> Statistics
incPatVarApStatBy inc stat
   = stat { stats_patVarAps = old + inc }
   where
   old = stats_patVarAps stat


addStats :: Statistics -> Statistics -> Statistics
addStats s1 s2
   = Stats
     { stats_partialAps       = stats_partialAps s1 + stats_partialAps s2
     , stats_saturatedAps     = stats_saturatedAps s1 + stats_saturatedAps s2
     , stats_overSaturatedAps = stats_overSaturatedAps s1 + stats_overSaturatedAps s2
     , stats_lambdas          = stats_lambdas s1 + stats_lambdas s2
     , stats_constants        = stats_constants s1 + stats_constants s2
     , stats_miscAps          = stats_miscAps s1 + stats_miscAps s2
     , stats_patVarAps        = stats_patVarAps s1 + stats_patVarAps s2
     }
