{-------------------------------------------------------------------------------

        Copyright:              Bernie Pope 2003

        Module:                 TypeSigMap 

        Description:            a map of ident -> qualified type 

        Primary Authors:        Bernie Pope

-------------------------------------------------------------------------------}
{-
    This file is part of buddha.

    buddha is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    buddha is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with buddha; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
-}

module TypeSigMap 
   ( TypeSigMap
   , typeSigMapFromDecls
   , emptyTypeSigMap
   , lookupTypeSig
   , showTypeSigMap
   ) where

import Data.FiniteMap

import Language.Haskell.Syntax 

--------------------------------------------------------------------------------

type TypeSigMap = FiniteMap HsName HsQualType

emptyTypeSigMap :: TypeSigMap
emptyTypeSigMap = emptyFM

lookupTypeSig :: TypeSigMap -> HsName -> Maybe HsQualType
lookupTypeSig = lookupFM

type Qualifier = HsQualType -> HsQualType

typeSigMapFromDecls :: [HsDecl] -> TypeSigMap
typeSigMapFromDecls decls = typeSigMapFromDeclsQual id decls

typeSigMapFromDeclsQual :: Qualifier -> [HsDecl] -> TypeSigMap
typeSigMapFromDeclsQual _qualifier [] = emptyTypeSigMap

typeSigMapFromDeclsQual qualifier (HsTypeSig _sloc names qualType : decls)
   = addListToFM (typeSigMapFromDeclsQual qualifier decls) newMembers
   where
   newMembers = [ (ident, qualifier qualType) | ident <- names ]

typeSigMapFromDeclsQual qualifier 
                        (HsClassDecl _sloc _cntxt className argNames memberDecls : decls)
   = plusFM (typeSigMapFromDeclsQual qualifier decls) newMembers
   where
   newMembers = typeSigMapFromDeclsQual newQualifier memberDecls
   newQualifier :: Qualifier
   newQualifier (HsQualType oldContxt oldType)
      = HsQualType (thisAsst : oldContxt) oldType
   thisAsst = (UnQual className, map HsTyVar argNames) 

typeSigMapFromDeclsQual qualifier (otherDecl : decls) 
   = typeSigMapFromDeclsQual qualifier decls

showTypeSigMap :: TypeSigMap -> String
showTypeSigMap sigMap
   = unlines $ map show mapList
   where
   mapList = typeSigMapToList sigMap

typeSigMapToList :: TypeSigMap -> [(HsName, HsQualType)]
typeSigMapToList = fmToList
