{- this is the COPYRIGHT from the NHC sources where this file 
   was taken from:
   
The majority of the source code of the nhc98 Haskell compiler is
(c) copyright to Niklas Rojemo, 1991-1998.

Many parts of the nhc98 compiler, libraries, and system were
contributed or modified by Malcolm Wallace, Jan Sparud, David Wakeling,
Colin Runciman, Phil Hassall, and Olaf Chitil, and are (c) copyright
to them, their respective institutions, or funding bodies, 1996-2002.

The core of the hmake tool is
(c) copyright to Thomas Hallgren, 1991-1997.
(Code is incorporated from the earlier tools hbcmake and nhc13make.)
Many modifications to hmake are
(c) copyright to Malcolm Wallace, 1998-2001.

The hmake interactive tool is
(c) copyright to Malcolm Wallace, 2000.

The hp2graph tool is
(c) copyright to David Wakeling and Niklas Rojemo, 1991-1996.

The hat-trans tool is
(c) copyright to Olaf Chitil, 2002.

The hat-observe tool is
(c) copyright to Thorsten Brehm, 2001.

The hat-detect tool is
(c) copyright to Thorsten Brehm, 2001.

The hat-trail tool is
(c) copyright to Malcolm Wallace, 2002.

The hat-stack tool is
(c) copyright to Malcolm Wallace, 2001.

The hat-check tool is
(c) copyright to Colin Runciman, 2001.

The hat-trail-in-java (redex trail browser) tool is
(c) copyright to Jan Sparud, 1996-1998,
with modifications 
(c) copyright to Colin Runciman, 2000-2001.

The HOOD Observe library and graphical browser are
(c) copyright to Andy Gill, 2000.
The HOOD graphical browser incorporates open source Java components
(c) copyright MicroStar Inc, 1999.  (Please read their separate license.)

The Random library is copied direct from Hugs, which has a separate
BSD-style license.  That implementation of Random is
(c) copyright Lennart Augustsson, with modifications by Sigbjorn Finne.
Some parts of the implementation of the Time library were also
contributed by Lennart.


The development of nhc98 (and its predecessor nhc13) has been supported
by NUTEK (Sweden), Canon Research Europe Ltd., EPSRC (UK), and the
Universities of Chalmers (Sweden) and York (UK).

LICENCE
-------
It is the intention that this software be "freely available" in the Gnu
(http://www.gnu.org/) and Open Source (http://www.opensource.org/)
traditions.  The following is a brief statement of the rights and
restrictions attached to this software distribution.  It is a
preliminary licence; we may modify the terms and conditions at a later
date.  Any successor to this licence may, when published, be applied to
this software as an alternative to the current terms, if you wish.

If you are not sure about any of the terms of this licence, please
contact us to discuss your requirements.  (Primary contact:
Malcolm.Wallace@cs.york.ac.uk)

You may use, re-distribute, and modify this software, but you must not
alter or remove these copyright notices.  You may add your own
additional copyright notices for any modifications to this software that
you distribute.  (Any modifications must be provided - at least - as
source code, they must be described in the documentation, and you must
clearly indicate that the software has been modified, for instance by
changing the name of the executable or its version number, or by some
other method.)

You must not restrict anyone else's rights to use, re-distribute or
modify this software.  Distributions of standard or modified versions of
this software must retain this licence (or its successor).

In addition, you are explicitly granted the right to re-use parts of this
software in the creation of new software, without having to place the
new software under this or any other licence, provided that:
 . the new software does not have the same name as this software, but
 . you clearly acknowledge which code you have re-used from this software,
 . you retain the relevant copyright notices, and
 . you indicate to users where they can freely obtain a standard version of
   this software.

Programs, object files, and intermediate files produced as output by
this software do not fall under this copyright statement and are not
governed by the terms of this licence.  You are free to use them (or
restrict their use) as you like.

UNLESS OTHERWISE STATED IN WRITING, THIS SOFTWARE IS SUPPLIED "AS IS"
AND WITHOUT ANY WARRANTY, EXPRESS OR IMPLIED, INCLUDING WITHOUT
LIMITATION THE IMPLIED WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A
PARTICULAR PURPOSE.  NEITHER THE AUTHORS, COPYRIGHT HOLDERS, NOR ANY
OTHER PARTY WHO REDISTRIBUTES THIS SOFTWARE SHALL BE LIABLE FOR DAMAGES,
HOWSOEVER CAUSED, ARISING OUT OF THE USE OF THIS SOFTWARE.  USE AT YOUR
OWN RISK.

-}

module Unlit(unlit) where

-- Part of the following code is from
-- "Report on the Programming Language Haskell",
--   version 1.2, appendix C.

import Char

data Classified = Program String | Blank | Comment
                | Include Int String | Pre String

classify :: [String] -> [Classified]
classify []                = []
classify (('\\':x):xs) | x == "begin{code}" = Blank : allProg xs
   where allProg [] = []  -- Should give an error message,
                          -- but I have no good position information.
         allProg (('\\':x):xs) |  x == "end{code}" = Blank : classify xs
	 allProg (x:xs) = Program x:allProg xs
classify (('>':x):xs)      = Program (' ':x) : classify xs
classify (('#':x):xs)      = (case words x of
                                (line:file:_) | all isDigit line
                                   -> Include (read line) file
                                _  -> Pre x
                             ) : classify xs
classify (x:xs) | all isSpace x = Blank:classify xs
classify (x:xs)                 = Comment:classify xs

unclassify :: Classified -> String
unclassify (Program s) = s
unclassify (Pre s)     = '#':s
unclassify (Include i f) = '#':' ':show i ++ ' ':f
unclassify Blank       = ""
unclassify Comment     = ""

unlit :: String -> String -> String
unlit file lhs = (unlines
                 . map unclassify
                 . adjecent file (0::Int) Blank
                 . classify) (inlines lhs)

adjecent :: String -> Int -> Classified -> [Classified] -> [Classified]
adjecent file 0 _             (x              :xs) = x : adjecent file 1 x xs -- force evaluation of line number
adjecent file n y@(Program _) (x@Comment      :xs) = error (message file n "program" "comment")
adjecent file n y@(Program _) (x@(Include i f):xs) = x: adjecent f    i     y xs
adjecent file n y@(Program _) (x@(Pre _)      :xs) = x: adjecent file (n+1) y xs
adjecent file n y@Comment     (x@(Program _)  :xs) = error (message file n "comment" "program")
adjecent file n y@Comment     (x@(Include i f):xs) = x: adjecent f    i     y xs
adjecent file n y@Comment     (x@(Pre _)      :xs) = x: adjecent file (n+1) y xs
adjecent file n y@Blank       (x@(Include i f):xs) = x: adjecent f    i     y xs
adjecent file n y@Blank       (x@(Pre _)      :xs) = x: adjecent file (n+1) y xs
adjecent file n _             (x@next         :xs) = x: adjecent file (n+1) x xs
adjecent file n _             []                    = []

message "\"\"" n p c = "Line "++show n++": "++p++ " line before "++c++" line.\n"
message []     n p c = "Line "++show n++": "++p++ " line before "++c++" line.\n"
message file   n p c = "In file " ++ file ++ " at line "++show n++": "++p++ " line before "++c++" line.\n"


-- Re-implementation of 'lines', for better efficiency (but decreased laziness).
-- Also, importantly, accepts non-standard DOS and Mac line ending characters.
inlines s = lines' s id
  where
  lines' []             acc = [acc []]
  lines' ('\^M':'\n':s) acc = acc [] : lines' s id	-- DOS
  lines' ('\^M':s)      acc = acc [] : lines' s id	-- MacOS
  lines' ('\n':s)       acc = acc [] : lines' s id	-- Unix
  lines' (c:s)          acc = lines' s (acc . (c:))

