{-------------------------------------------------------------------------------

        Copyright:              Bernie Pope 2003

        Module:                 Utils

        Description:            Generic utilities that don't have a good home 
                                anywhere else.

        Primary Authors:        Bernie Pope

-------------------------------------------------------------------------------}
{-
    This file is part of buddha.

    buddha is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    buddha is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with buddha; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
-}

module Utils 
   ( fst3
   , snd3
   , trd3
   , (.||.)
   , (.&&.)
   , isSubset
   , rJustify
   , lJustify
   , notMembers
   ) where

--------------------------------------------------------------------------------

-- selection operations for triples
fst3 :: (a,b,c) -> a
fst3 (a,_,_) = a
snd3 :: (a,b,c) -> b
snd3 (_,b,_) = b
trd3 :: (a,b,c) -> c
trd3 (_,_,c) = c

-- composing boolean functions
infixr 2 .||.
(.||.) :: (a -> Bool) -> (a -> Bool) -> a -> Bool
(p .||. q) x = p x || q x

infixr 3 .&&.
(.&&.) :: (a -> Bool) -> (a -> Bool) -> a -> Bool
(p .&&. q) x = p x && q x

-- text justification within a fixed space
rJustify :: Int -> String -> String
rJustify n s = replicate (n - length s) ' ' ++ s

lJustify :: Int -> String -> String
lJustify n s = take n $ s ++ repeat ' ' 

-- returns all the items that are in the first list but not the second
notMembers :: Eq a => [a] -> [a] -> [a]
notMembers [] _ = []
notMembers (x:xs) ys
   | x `elem` ys = notMembers xs ys
   | otherwise = x : notMembers xs ys

-- is one list a subset of another
isSubset :: Eq a => [a] -> [a] -> Bool
isSubset s1 s2 = all (`elem` s2) s1


