//===========================================================================
//  @(#) $Name: cflowd-2-1-b1 $
//  @(#) $Id: CfdcollectConfig.cc,v 1.3 1999/02/07 19:17:29 dwm Exp $
//===========================================================================
//  CAIDA Copyright Notice
//
//  By accessing this software, cflowd, you are duly informed
//  of and agree to be bound by the conditions described below in this
//  notice:
//
//  This software product, cflowd, is developed by Daniel W. McRobb, and
//  copyrighted(C) 1998 by the University of California, San Diego
//  (UCSD), with all rights reserved.  UCSD administers the CAIDA grant,
//  NCR-9711092, under which part of this code was developed.
//
//  There is no charge for cflowd software. You can redistribute it
//  and/or modify it under the terms of the GNU General Public License,
//  v.  2 dated June 1991 which is incorporated by reference herein.
//  cflowd is distributed WITHOUT ANY WARRANTY, IMPLIED OR EXPRESS, OF
//  MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE or that the use
//  of it will not infringe on any third party's intellectual property
//  rights.
//
//  You should have received a copy of the GNU GPL along with cflowd.
//  Copies can also be obtained from:
//
//    http://www.gnu.org/copyleft/gpl.html
//
//  or by writing to:
//
//    University of California, San Diego
//
//    SDSC/CAIDA
//    9500 Gilman Dr., MS-0505
//    La Jolla, CA 92093 - 0505  USA
//
//  Or contact:
//
//    info@caida.org
//===========================================================================

extern "C" {
#include <syslog.h>
}

#include <string>

#include "CfdcollectConfig.hh"

static const string rcsid = "@(#) $Name: cflowd-2-1-b1 $ $Id: CfdcollectConfig.cc,v 1.3 1999/02/07 19:17:29 dwm Exp $";

//-------------------------------------------------------------------------
//                   CfdcollectConfig::CfdcollectConfig()                  
//.........................................................................
//  
//-------------------------------------------------------------------------
CfdcollectConfig::CfdcollectConfig()
{
  this->_logFacility = 0;
}

//-------------------------------------------------------------------------
//                  CfdcollectConfig::~CfdcollectConfig()                  
//.........................................................................
//  
//-------------------------------------------------------------------------
CfdcollectConfig::~CfdcollectConfig()
{
}

//-------------------------------------------------------------------------
//                int CfdcollectConfig::LogFacility() const                
//.........................................................................
//  
//-------------------------------------------------------------------------
int CfdcollectConfig::LogFacility() const
{
  return(this->_logFacility);
}

//-------------------------------------------------------------------------
//            int CfdcollectConfig::LogFacility(int logFacility)           
//.........................................................................
//  
//-------------------------------------------------------------------------
int CfdcollectConfig::LogFacility(int logFacility)
{
  this->_logFacility = logFacility;
  return(this->_logFacility);
}

//-------------------------------------------------------------------------
//             const string & CfdcollectConfig::PidFile() const            
//.........................................................................
//  
//-------------------------------------------------------------------------
const string & CfdcollectConfig::PidFile() const
{
  return(this->_pidFile);
}

//-------------------------------------------------------------------------
//     const string & CfdcollectConfig::PidFile(const string & pidFile)    
//.........................................................................
//  
//-------------------------------------------------------------------------
const string & CfdcollectConfig::PidFile(const string & pidFile)
{
  this->_pidFile = pidFile;
  return(this->_pidFile);
}

//-------------------------------------------------------------------------
//             const string & CfdcollectConfig::DataDir() const            
//.........................................................................
//  
//-------------------------------------------------------------------------
const string & CfdcollectConfig::DataDir() const
{
  return(this->_dataDir);
}

//-------------------------------------------------------------------------
//     const string & CfdcollectConfig::DataDir(const string & dataDir)    
//.........................................................................
//  
//-------------------------------------------------------------------------
const string & CfdcollectConfig::DataDir(const string & dataDir)
{
  this->_dataDir = dataDir;
  return(this->_dataDir);
}

//-------------------------------------------------------------------------
//           const string & CfdcollectConfig::FilePrefix() const           
//.........................................................................
//  
//-------------------------------------------------------------------------
const string & CfdcollectConfig::FilePrefix() const
{
  return(this->_filePrefix);
}

//-------------------------------------------------------------------------
//  const string & CfdcollectConfig::FilePrefix(const string & filePrefix) 
//.........................................................................
//  
//-------------------------------------------------------------------------
const string & CfdcollectConfig::FilePrefix(const string & filePrefix)
{
  this->_filePrefix = filePrefix;
  return(this->_filePrefix);
}

//-------------------------------------------------------------------------
//         vector<CflowdServer> & CfdcollectConfig::CflowdServers()          
//.........................................................................
//  
//-------------------------------------------------------------------------
vector<CflowdServer> & CfdcollectConfig::CflowdServers()
{
  return(this->_cflowdServers);
}

//-------------------------------------------------------------------------
//                      void CfdcollectConfig::Clear()                     
//.........................................................................
//  
//-------------------------------------------------------------------------
void CfdcollectConfig::Clear()
{
  closelog();
  this->_logFacility = 0;
  unlink(this->_pidFile.c_str());
  this->_pidFile = string("");
  this->_dataDir = string("");
  this->_cflowdServers.erase(this->_cflowdServers.begin(),
                             this->_cflowdServers.end());

  return;
}
