//===========================================================================
//  @(#) $Name: cflowd-2-1-b1 $
//  @(#) $Id: CfdcollectConfig.hh,v 1.3 1999/02/07 19:19:11 dwm Exp $
//===========================================================================
//  CAIDA Copyright Notice
//
//  By accessing this software, cflowd, you are duly informed
//  of and agree to be bound by the conditions described below in this
//  notice:
//
//  This software product, cflowd, is developed by Daniel W. McRobb, and
//  copyrighted(C) 1998 by the University of California, San Diego
//  (UCSD), with all rights reserved.  UCSD administers the CAIDA grant,
//  NCR-9711092, under which part of this code was developed.
//
//  There is no charge for cflowd software. You can redistribute it
//  and/or modify it under the terms of the GNU General Public License,
//  v.  2 dated June 1991 which is incorporated by reference herein.
//  cflowd is distributed WITHOUT ANY WARRANTY, IMPLIED OR EXPRESS, OF
//  MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE or that the use
//  of it will not infringe on any third party's intellectual property
//  rights.
//
//  You should have received a copy of the GNU GPL along with cflowd.
//  Copies can also be obtained from:
//
//    http://www.gnu.org/copyleft/gpl.html
//
//  or by writing to:
//
//    University of California, San Diego
//
//    SDSC/CAIDA
//    9500 Gilman Dr., MS-0505
//    La Jolla, CA 92093 - 0505  USA
//
//  Or contact:
//
//    info@caida.org
//===========================================================================

#ifndef _CFDCOLLECTCONFIG_HH_
#define _CFDCOLLECTCONFIG_HH_

#include <vector>
#include <string>

#include "CflowdServer.hh"

//---------------------------------------------------------------------------
//  class CfdcollectConfig
//---------------------------------------------------------------------------
//  This class is used to contain the cfdcollect configuration,
//  including a vector of CflowdServer objects (each of which abstracts
//  a single instance of a cflowd server).
//---------------------------------------------------------------------------
class CfdcollectConfig
{
public:
  //-------------------------------------------------------------------------
  //                           CfdcollectConfig()
  //.........................................................................
  //  constructor
  //-------------------------------------------------------------------------
  CfdcollectConfig();
  
  //-------------------------------------------------------------------------
  //                           ~CfdcollectConfig()
  //.........................................................................
  //  destructor
  //-------------------------------------------------------------------------
  ~CfdcollectConfig();
  
  //-------------------------------------------------------------------------
  //                         int LogFacility() const
  //.........................................................................
  //  Returns the syslog facility we'll use for logging.
  //-------------------------------------------------------------------------
  int LogFacility() const;
  
  //-------------------------------------------------------------------------
  //                    int LogFacility(int logFacility)
  //.........................................................................
  //  Sets and reutrns the syslog facility we'll use for logging.
  //-------------------------------------------------------------------------
  int LogFacility(int logFacility);
  
  //-------------------------------------------------------------------------
  //                     const string & PidFile() const
  //.........................................................................
  //  Returns the filename in which we'll store our process ID.
  //-------------------------------------------------------------------------
  const string & PidFile() const;
  
  //-------------------------------------------------------------------------
  //             const string & PidFile(const string & pidFile)
  //.........................................................................
  //  Sets and returns the filename in which we'll store our process ID.
  //-------------------------------------------------------------------------
  const string & PidFile(const string & pidFile);
  
  //-------------------------------------------------------------------------
  //                     const string & DataDir() const
  //.........................................................................
  //  Returns the data directory in which we'll create subdirectories
  //  for each router to hold ARTS files for each router.
  //-------------------------------------------------------------------------
  const string & DataDir() const;
  
  //-------------------------------------------------------------------------
  //             const string & DataDir(const string & dataDir)
  //.........................................................................
  //  Sets and returns the data directory in which we'll create
  //  subdirectories for each router to hold ARTS files for each router.
  //-------------------------------------------------------------------------
  const string & DataDir(const string & dataDir);
  
  //-------------------------------------------------------------------------
  //                    const string & FilePrefix() const
  //.........................................................................
  //  returns the file prefix used to name ARTS output files.
  //-------------------------------------------------------------------------
  const string & FilePrefix()const;
  
  //-------------------------------------------------------------------------
  //            const string & FilePrefix(const string & filePrefix)
  //.........................................................................
  //  Sets and returns the FilePrefix used to name ARTS output files.
  //-------------------------------------------------------------------------
  const string & FilePrefix(const string & filePrefix);
  
  //-------------------------------------------------------------------------
  //                  vector<CflowdServer> & CflowdServers()
  //.........................................................................
  //  Returs a reference to the vector of CflowdServer objects contained
  //  in the CfdcollectConfig.
  //-------------------------------------------------------------------------
  vector<CflowdServer> & CflowdServers();

  //-------------------------------------------------------------------------
  //                              void Clear()
  //.........................................................................
  //  Clears the configuration.
  //-------------------------------------------------------------------------
  void Clear();
  
private:
  int                   _logFacility;
  string                _pidFile;
  string                _dataDir;
  string                _filePrefix;
  vector<CflowdServer>  _cflowdServers;
};

#endif  // _CFDCOLLECTCONFIG_HH_
