//===========================================================================
//  @(#) $Name: cflowd-2-1-b1 $
//  @(#) $Id: CflowdServer.hh,v 1.5 1999/04/30 20:02:12 dwm Exp $
//===========================================================================
//  CAIDA Copyright Notice
//
//  By accessing this software, cflowd, you are duly informed
//  of and agree to be bound by the conditions described below in this
//  notice:
//
//  This software product, cflowd, is developed by Daniel W. McRobb, and
//  copyrighted(C) 1998 by the University of California, San Diego
//  (UCSD), with all rights reserved.  UCSD administers the CAIDA grant,
//  NCR-9711092, under which part of this code was developed.
//
//  There is no charge for cflowd software. You can redistribute it
//  and/or modify it under the terms of the GNU General Public License,
//  v.  2 dated June 1991 which is incorporated by reference herein.
//  cflowd is distributed WITHOUT ANY WARRANTY, IMPLIED OR EXPRESS, OF
//  MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE or that the use
//  of it will not infringe on any third party's intellectual property
//  rights.
//
//  You should have received a copy of the GNU GPL along with cflowd.
//  Copies can also be obtained from:
//
//    http://www.gnu.org/copyleft/gpl.html
//
//  or by writing to:
//
//    University of California, San Diego
//
//    SDSC/CAIDA
//    9500 Gilman Dr., MS-0505
//    La Jolla, CA 92093 - 0505  USA
//
//  Or contact:
//
//    info@caida.org
//===========================================================================
extern "C" {
#include <sys/types.h>
#include <sys/socket.h>
#include <time.h>
#include <netinet/in.h>
#include <stdio.h>
}

#include <string>

#include "Arts.hh"
#include "ArtsInterfaceMatrix.hh"
#include "ArtsNextHopTable.hh"
#include "ArtsPortTable.hh"
#include "ArtsPortMatrix.hh"
#include "ArtsProtocolTable.hh"
#include "ArtsAsMatrix.hh"
#include "ArtsNetMatrix.hh"
#include "ArtsTosTable.hh"
#include "Signal.hh"

//---------------------------------------------------------------------------
//  class CflowdServer
//---------------------------------------------------------------------------
//  This class abstracts a remote cflowd server.  
//---------------------------------------------------------------------------
class CflowdServer 
{
public:
  //-------------------------------------------------------------------------
  //                             CflowdServer()
  //.........................................................................
  //  constructor
  //-------------------------------------------------------------------------
  CflowdServer();

  //-------------------------------------------------------------------------
  //                             ~CflowdServer()
  //.........................................................................
  //  destructor
  //-------------------------------------------------------------------------
  ~CflowdServer();
  
  //-------------------------------------------------------------------------
  //                             bool Connect()
  //.........................................................................
  //  Connect to the remote cflowd server.  Returns true if successful,
  //  else returns false.
  //-------------------------------------------------------------------------
  bool Connect();
  
  //-------------------------------------------------------------------------
  //     bool GetData(const string & dirname, const string & fileprefix,
  //                  Signal sigAlrm)
  //.........................................................................
  //  Retrieves the data from the remote cflowd server, writing the
  //  data into files named 'fileprefix.YYYYMMDD' in subdirectories of
  //  dirname.  The subdirectories are just the IP addresses of each
  //  router in the data; each router gets its own subdirectory.
  //  The caller is expected to have a timer set for this operation,
  //  so we don't get stuck in a blocked read for a really long time.
  //  Hence the caller should pass in a Signal(SIGALRM) object; we'll
  //  leave it unblocked while we're trying to read data, then block it
  //  while writing data, then unlcok it again before we return.
  //  Returns true if successful, false on error.
  //-------------------------------------------------------------------------
  bool GetData(const string & dirname, const string & fileprefix,
               Signal & sigAlrm);
  
  //-------------------------------------------------------------------------
  //                            void Disconnect()
  //.........................................................................
  //  Close the connection to the remote cflowd server.
  //-------------------------------------------------------------------------
  void Disconnect();
  
  //-------------------------------------------------------------------------
  //                     const string & HostName() const
  //.........................................................................
  //  Returns the hostname associated with the remote cflowd server.
  //-------------------------------------------------------------------------
  const string & HostName() const;
  
  //-------------------------------------------------------------------------
  //            const string & HostName(const string & hostname)
  //.........................................................................
  //  Sets and returns the hostname associated with the remote cflowd
  //  server.
  //-------------------------------------------------------------------------
  const string & HostName(const string & hostname);
  
  //-------------------------------------------------------------------------
  //                       unsigned short Port() const
  //.........................................................................
  //  Returns the port number associated with the remote cflowd server.
  //  This is the port number on which cflowd is listening for TCP
  //  client connections.
  //-------------------------------------------------------------------------
  unsigned short Port() const;
  
  //-------------------------------------------------------------------------
  //                unsigned short Port(unsigned short port)
  //.........................................................................
  //  Sets and returns the port number associated with the remote cflowd
  //  server.  This is the port number on which cflowd is listening for
  //  TCP client connections.
  //-------------------------------------------------------------------------
  unsigned short Port(unsigned short port);
  
  //-------------------------------------------------------------------------
  //                       time_t NextPollTime() const
  //.........................................................................
  //  Returns the next time at which we should query the remote cflowd
  //  server for data.
  //-------------------------------------------------------------------------
  time_t NextPollTime() const;
  
  //-------------------------------------------------------------------------
  //                time_t NextPollTime(time_t pollInterval)
  //.........................................................................
  //  Sets and returns the next time at which we should query the remote
  //  cflowd server for data.
  //-------------------------------------------------------------------------
  time_t NextPollTime(time_t pollInterval);
  
  //-------------------------------------------------------------------------
  //                       time_t PollInterval() const
  //.........................................................................
  //  Returns the interval (in seconds) between polls for the remote
  //  cflowd server.  This determines how often we'll collect data from
  //  the remote cflowd server.
  //-------------------------------------------------------------------------
  time_t PollInterval() const;
  
  //-------------------------------------------------------------------------
  //                time_t PollInterval(time_t pollInterval)
  //.........................................................................
  //  Sets and returns the interval (in seconds) between polls for the
  //  remote cflowd server.  This determines how often we'll collect
  //  data from the remote cflowd server.
  //-------------------------------------------------------------------------
  time_t PollInterval(time_t pollInterval);
  
private:
  string               _hostName;
  struct sockaddr_in   _sockAddr;
  int                  _sockFd;
  time_t               _nextPollTime;
  time_t               _pollInterval;

  int ReadProtosIntoProtoObject(FILE *sockfp,
                                ArtsProtocolTable & protoTable);
  int ReadPortsIntoPortObject(FILE *sockfp, ArtsPortTable & portTable);
  int ReadNetsIntoNetObject(FILE *sockfp, ArtsNetMatrix & netMatrix);
  int ReadASesIntoASObject(FILE *sockfp, ArtsAsMatrix & asMatrix);
  int ReadTosesIntoTosObject(FILE *sockfp,
                             ArtsTosTable & tosTable);
  
};

