%{
//===========================================================================
//  @(#) $Name: cflowd-2-1-b1 $
//  @(#) $Id: config.lex,v 1.4 1999/02/04 22:00:08 dwm Exp $
//===========================================================================
//  CAIDA Copyright Notice
//
//  By accessing this software, cflowd, you are duly informed
//  of and agree to be bound by the conditions described below in this
//  notice:
//
//  This software product, cflowd, is developed by Daniel W. McRobb, and
//  copyrighted(C) 1998 by the University of California, San Diego
//  (UCSD), with all rights reserved.  UCSD administers the CAIDA grant,
//  NCR-9711092, under which part of this code was developed.
//
//  There is no charge for cflowd software. You can redistribute it
//  and/or modify it under the terms of the GNU General Public License,
//  v.  2 dated June 1991 which is incorporated by reference herein.
//  cflowd is distributed WITHOUT ANY WARRANTY, IMPLIED OR EXPRESS, OF
//  MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE or that the use
//  of it will not infringe on any third party's intellectual property
//  rights.
//
//  You should have received a copy of the GNU GPL along with cflowd.
//  Copies can also be obtained from:
//
//    http://www.gnu.org/copyleft/gpl.html
//
//  or by writing to:
//
//    University of California, San Diego
//
//    SDSC/CAIDA
//    9500 Gilman Dr., MS-0505
//    La Jolla, CA 92093 - 0505  USA
//
//  Or contact:
//
//    info@caida.org
//===========================================================================
extern "C" {
#include <syslog.h>
}

#include <fstream.h>
#include <string>
#include <deque>

#include "aclocal.h"
#include "CfdcollectConfig.hh"

static const string rcsid = "@(#) $Name: cflowd-2-1-b1 $ $Id: config.lex,v 1.4 1999/02/04 22:00:08 dwm Exp $";
%}

pathName     [/][a-zA-z\-\.\/\@0-9\:\_\+]+
facilities   (local.)|(daemon)
hostName     [^&*()!~`'";?|{}\[\]$\n\t ]+

%x SYSCONFIG
%x LOGFACILITY
%x PIDFILE
%x DATADIR
%x FILEPREFIX
%x CFLOWD
%x CFDHOST
%x CFDPORT
%x CFDPOLLINTERVAL

%option noyywrap

%%

<INITIAL>#.*\n
<INITIAL>^system[ \t]*[{]		{ BEGIN(SYSCONFIG); }
<INITIAL>^cflowd[ \t]*[{]		{ BEGIN(CFLOWD); }
<INITIAL>[ \n\t]+
<INITIAL>.

<SYSCONFIG>#.*\n
<SYSCONFIG>^[ \t]*logFacility\:[ \t]*   { BEGIN(LOGFACILITY); }
<SYSCONFIG>^[ \t]*pidFile\:[ \t]*       { BEGIN(PIDFILE); }
<SYSCONFIG>^[ \t]*filePrefix\:[ \t]*    { BEGIN(FILEPREFIX); }
<SYSCONFIG>^[ \t]*dataDirectory\:[ \t]* { BEGIN(DATADIR); }
<SYSCONFIG>[}]                          { BEGIN(INITIAL); }
<SYSCONFIG>[\n]
<SYSCONFIG>[ \t]+

<LOGFACILITY>#.*\n
<LOGFACILITY>{facilities}               { BEGIN(SYSCONFIG); 
                                          return(LOGFACILITY);
                                        }
<LOGFACILITY>[\n]                       { BEGIN(SYSCONFIG); }
<LOGFACILITY>[ \t]+

<PIDFILE>#.*\n
<PIDFILE>{pathName}                     { BEGIN(SYSCONFIG); return(PIDFILE); }
<PIDFILE>[\n]                           { BEGIN(SYSCONFIG); }
<PIDFILE>[ \t]+

<FILEPREFIX>#.*\n
<FILEPREFIX>[^&*()!~`'";?|{}\[\]$\n\t ]+ { BEGIN(SYSCONFIG);
                                           return(FILEPREFIX); }
<FILEPREFIX>[\n]                        { BEGIN(SYSCONFIG); }
<FILEPREFIX>[ \t]+


<DATADIR>#.*\n
<DATADIR>{pathName}                     { BEGIN(SYSCONFIG); return(DATADIR); }
<DATADIR>[\n]                           { BEGIN(SYSCONFIG); }
<DATADIR>[ \t]+

<CFLOWD>#.*\n
<CFLOWD>^[ \t]*host\:[ \t]*            { BEGIN(CFDHOST); }
<CFLOWD>^[ \t]*tcpCollectPort\:[ \t]*  { BEGIN(CFDPORT); }
<CFLOWD>^[ \t]*minPollInterval\:[ \t]* { BEGIN(CFDPOLLINTERVAL); }
<CFLOWD>[}]                            { BEGIN(INITIAL); return(CFLOWD); }
<CFLOWD>[ \t]+
<CFLOWD>[\n]

<CFDHOST>#.*\n
<CFDHOST>{hostName}                    { BEGIN(CFLOWD); return(CFDHOST); }
<CFDHOST>[\n]                          { BEGIN(CFLOWD); }
<CFDHOST>[ \t]+

<CFDPORT>#.*\n
<CFDPORT>[0-9]+                          { BEGIN(CFLOWD); return(CFDPORT); }
<CFDPORT>[\n]                            { BEGIN(CFLOWD); }
<CFDPORT>[ \t]+

<CFDPOLLINTERVAL>#.*\n
<CFDPOLLINTERVAL>[0-9]+                  { BEGIN(CFLOWD);
                                           return(CFDPOLLINTERVAL); }
<CFDPOLLINTERVAL>[\n]                    { BEGIN(CFLOWD); }
<CFDPOLLINTERVAL>[ \t]+

%%

#ifndef HAVE_STRCASECMP

//  Our O/S doesn't have strcasecmp() in libc, so use our own (and
//  also define strncasecmp()).

static char charmap[] = {
  '\000', '\001', '\002', '\003', '\004', '\005', '\006', '\007',
  '\010', '\011', '\012', '\013', '\014', '\015', '\016', '\017',
  '\020', '\021', '\022', '\023', '\024', '\025', '\026', '\027',
  '\030', '\031', '\032', '\033', '\034', '\035', '\036', '\037',
  '\040', '\041', '\042', '\043', '\044', '\045', '\046', '\047',
  '\050', '\051', '\052', '\053', '\054', '\055', '\056', '\057',
  '\060', '\061', '\062', '\063', '\064', '\065', '\066', '\067',
  '\070', '\071', '\072', '\073', '\074', '\075', '\076', '\077',
  '\100', '\141', '\142', '\143', '\144', '\145', '\146', '\147',
  '\150', '\151', '\152', '\153', '\154', '\155', '\156', '\157',
  '\160', '\161', '\162', '\163', '\164', '\165', '\166', '\167',
  '\170', '\171', '\172', '\133', '\134', '\135', '\136', '\137',
  '\140', '\141', '\142', '\143', '\144', '\145', '\146', '\147',
  '\150', '\151', '\152', '\153', '\154', '\155', '\156', '\157',
  '\160', '\161', '\162', '\163', '\164', '\165', '\166', '\167',
  '\170', '\171', '\172', '\173', '\174', '\175', '\176', '\177',
  '\200', '\201', '\202', '\203', '\204', '\205', '\206', '\207',
  '\210', '\211', '\212', '\213', '\214', '\215', '\216', '\217',
  '\220', '\221', '\222', '\223', '\224', '\225', '\226', '\227',
  '\230', '\231', '\232', '\233', '\234', '\235', '\236', '\237',
  '\240', '\241', '\242', '\243', '\244', '\245', '\246', '\247',
  '\250', '\251', '\252', '\253', '\254', '\255', '\256', '\257',
  '\260', '\261', '\262', '\263', '\264', '\265', '\266', '\267',
  '\270', '\271', '\272', '\273', '\274', '\275', '\276', '\277',
  '\300', '\341', '\342', '\343', '\344', '\345', '\346', '\347',
  '\350', '\351', '\352', '\353', '\354', '\355', '\356', '\357',
  '\360', '\361', '\362', '\363', '\364', '\365', '\366', '\367',
  '\370', '\371', '\372', '\333', '\334', '\335', '\336', '\337',
  '\340', '\341', '\342', '\343', '\344', '\345', '\346', '\347',
  '\350', '\351', '\352', '\353', '\354', '\355', '\356', '\357',
  '\360', '\361', '\362', '\363', '\364', '\365', '\366', '\367',
  '\370', '\371', '\372', '\373', '\374', '\375', '\376', '\377',
};

//---------------------------------------------------------------------------
//           int strcasecmp(register char *s1, register char *s2)
//...........................................................................
//  Case-insensitive string comparison.  Works like strcmp()
//---------------------------------------------------------------------------
int strcasecmp(register const char *s1, register const char *s2)
{
  register char *cm = charmap;

  while (cm[*s1] == cm[*s2++])
    if (*s1++ == '\0')
      return(0);
  
  return(cm[*s1] - cm[*--s2]);
}

//---------------------------------------------------------------------------
//     int strncasecmp(register char *s1, register char *s2, size_t n)
//...........................................................................
//  Case-insensitive string comparison.  Works like strncmp()
//---------------------------------------------------------------------------
int strncasecmp(register const char *s1, register const char *s2, size_t n)
{
  register char *cm = charmap;

  while (--n >= 0 && cm[*s1] == cm[*s2++])
    if (*s1++ == '\0')
      return(0);

  return(n < 0 ? 0 : cm[*s1] - cm[*--s2]);
}
#endif

//-------------------------------------------------------------------------
//           static int SyslogFacility(const char *facilityname)
//.........................................................................
//
//-------------------------------------------------------------------------
static int SyslogFacility(const char *facilityname)
{
  if (!strcasecmp(facilityname,"daemon"))
    return(LOG_DAEMON);
  if (!strcasecmp(facilityname,"local0"))
    return(LOG_LOCAL0);
  if (!strcasecmp(facilityname,"local1"))
    return(LOG_LOCAL1);
  if (!strcasecmp(facilityname,"local2"))
    return(LOG_LOCAL2);
  if (!strcasecmp(facilityname,"local3"))
    return(LOG_LOCAL3);
  if (!strcasecmp(facilityname,"local4"))
    return(LOG_LOCAL4);
  if (!strcasecmp(facilityname,"local5"))
    return(LOG_LOCAL5);
  if (!strcasecmp(facilityname,"local6"))
    return(LOG_LOCAL6);
  if (!strcasecmp(facilityname,"local7"))
    return(LOG_LOCAL7);

  return(LOG_LOCAL6);
}

//-------------------------------------------------------------------------
//         int LoadCfdcollectConfigFile(const char *configFileName,
//                                      CfdcollectConfig & config)
//.........................................................................
//
//-------------------------------------------------------------------------
int LoadCfdcollectConfigFile(const char *configFileName,
                             CfdcollectConfig & config)
{
  int                  rc;
  yyConfigFlexLexer   *lexer;
  ifstream            *configStream;
  CflowdServer         newServer;

  assert(configFileName != NULL);

  configStream = new ifstream(configFileName);
  if (!configStream || !(*configStream))
    return(-1);
  
  lexer = new yyConfigFlexLexer(configStream,0);
  if (lexer == (yyConfigFlexLexer *)0) {
    delete(configStream);
    return(-1);
  }
  
  while ((rc = lexer->yylex()) != 0) {
    switch (rc) {
      case LOGFACILITY:
        config.LogFacility(SyslogFacility(lexer->YYText()));
        break;
      case PIDFILE:
        config.PidFile(lexer->YYText());
        break;
      case DATADIR:
        config.DataDir(lexer->YYText());
        break;
      case FILEPREFIX:
        config.FilePrefix(lexer->YYText());
        break;
      case CFDHOST:
        newServer.HostName(lexer->YYText());
        break;
      case CFDPORT:
        newServer.Port(atoi(lexer->YYText()));
        break;
      case CFDPOLLINTERVAL:
        newServer.PollInterval(atoi(lexer->YYText()));
        break;
      case CFLOWD:
        newServer.NextPollTime(time((time_t *)NULL));
        config.CflowdServers().push_back(newServer);
        break;
      default:
        break;
    }
  }

  delete(lexer);
  delete(configStream);

  return(0);
}

