//===========================================================================
//  $Name: cflowd-2-1-b1 $
//  $Id: CflowdRawFlowClientList.hh,v 1.2 1998/09/14 18:10:23 dwm Exp $
//===========================================================================
//  CAIDA Copyright Notice
//
//  By accessing this software, cflowd++, you are duly informed
//  of and agree to be bound by the conditions described below in this
//  notice:
//
//  This software product, cflowd++, is developed by Daniel W. McRobb, and
//  copyrighted(C) 1998 by the University of California, San Diego
//  (UCSD), with all rights reserved.  UCSD administers the CAIDA grant,
//  NCR-9711092, under which part of this code was developed.
//
//  There is no charge for cflowd++ software. You can redistribute it
//  and/or modify it under the terms of the GNU General Public License,
//  v.  2 dated June 1991 which is incorporated by reference herein.
//  cflowd++ is distributed WITHOUT ANY WARRANTY, IMPLIED OR EXPRESS, OF
//  MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE or that the use
//  of it will not infringe on any third party's intellectual property
//  rights.
//
//  You should have received a copy of the GNU GPL along with cflowd++.
//  Copies can also be obtained from:
//
//    http://www.gnu.org/copyleft/gpl.html
//
//  or by writing to:
//
//    University of California, San Diego
//
//    SDSC/CAIDA
//    9500 Gilman Dr., MS-0505
//    La Jolla, CA 92093 - 0505  USA
//
//  Or contact:
//
//    info@caida.org
//===========================================================================

extern "C" {
#include <sys/types.h>
#include <sys/time.h>
#include <sys/socket.h>
#include <sys/un.h>
#include <unistd.h>
#include <errno.h>
#include <syslog.h>
  
#include "caida_t.h"
}

#include <list>

//---------------------------------------------------------------------------
//  class CflowdRawFlowClient
//---------------------------------------------------------------------------
//
//---------------------------------------------------------------------------
class CflowdRawFlowClient
{
public:
  int         fd;       //  fd I'm using to talk to the client
};

typedef list<CflowdRawFlowClient> _CflowdRawFlowClientList_t;

//---------------------------------------------------------------------------
//  class CflowdRawFlowClientList : public _CflowdRawFlowClientList_t
//---------------------------------------------------------------------------
//
//---------------------------------------------------------------------------
class CflowdRawFlowClientList : public _CflowdRawFlowClientList_t
{
public:
  typedef _CflowdRawFlowClientList_t::iterator        iterator;
  typedef _CflowdRawFlowClientList_t::const_iterator  const_iterator;
  
  CflowdRawFlowClientList();
  ~CflowdRawFlowClientList();
  
  void CloseAll();
  void Close(iterator & client);
  int Accept(int fd);
  void Clear();
  fd_set & FdSet();
  int MaxFd() const;
  
private:
  fd_set  _fdSet;
  int     _maxFd;
};

