#ifndef _DNSRECEIVER_HH_
#define _DNSRECEIVER_HH_

extern "C" {
  #include "caida_t.h"
}

#include "CflowdRawFlow.hh"

//----------------------------------------------------------------------------
//     class DnsReceiver 
//----------------------------------------------------------------------------
//  
//----------------------------------------------------------------------------
class DnsReceiver
{
public:
  //--------------------------------------------------------------------------
  //       inline DnsReceiver() 
  //..........................................................................
  //  
  //--------------------------------------------------------------------------
  inline DnsReceiver()
  {
    this->_numFlows = 0;
    this->_numPackets = 0;
    this->_numBytes = 0;
  }

  //--------------------------------------------------------------------------
  //       inline DnsReceiver(const DnsReceiver & dnsReceiver) 
  //..........................................................................
  //  
  //--------------------------------------------------------------------------
  inline DnsReceiver(const DnsReceiver & dnsReceiver)
  {
    this->_numFlows = dnsReceiver._numFlows;
    this->_numPackets = dnsReceiver._numPackets;
    this->_numBytes = dnsReceiver._numBytes;
  }
  
  //--------------------------------------------------------------------------
  //       inline uint64_t NumFlows() const 
  //..........................................................................
  //  
  //--------------------------------------------------------------------------
  inline uint64_t NumFlows() const
  {
    return(this->_numFlows);
  }

  //--------------------------------------------------------------------------
  //       inline uint64_t NumFlows(const uint64_t & numFlows) 
  //..........................................................................
  //  
  //--------------------------------------------------------------------------
  inline uint64_t NumFlows(const uint64_t & numFlows)
  {
    this->_numFlows = numFlows;
    return(this->_numFlows);
  }
  
  //--------------------------------------------------------------------------
  //       inline uint64_t NumPackets() const 
  //..........................................................................
  //  
  //--------------------------------------------------------------------------
  inline uint64_t NumPackets() const
  {
    return(this->_numPackets);
  }

  //--------------------------------------------------------------------------
  //       inline uint64_t NumPackets(const uint64_t & numPackets) 
  //..........................................................................
  //  
  //--------------------------------------------------------------------------
  inline uint64_t NumPackets(const uint64_t & numPackets)
  {
    this->_numPackets = numPackets;
    return(this->_numPackets);
  }

  //--------------------------------------------------------------------------
  //       inline uint64_t NumBytes() const 
  //..........................................................................
  //  
  //--------------------------------------------------------------------------
  inline uint64_t NumBytes() const
  {
    return(this->_numBytes);
  }

  //--------------------------------------------------------------------------
  //       inline uint64_t NumBytes(const uint64_t & numBytes) 
  //..........................................................................
  //  
  //--------------------------------------------------------------------------
  inline uint64_t NumBytes(const uint64_t & numBytes)
  {
    this->_numBytes = numBytes;
    return(this->_numBytes);
  }
  
  //--------------------------------------------------------------------------
  //       inline void AddFlow(const CflowdRawFlow & flow) 
  //..........................................................................
  //  
  //--------------------------------------------------------------------------
  inline void AddFlow(const CflowdRawFlow & flow)
  {
    this->_numFlows++;
    this->_numPackets += flow.Pkts();
    this->_numBytes += flow.Bytes();
    return;
  }
  
private:
  uint64_t   _numFlows;
  uint64_t   _numPackets;
  uint64_t   _numBytes;
};

#endif  // _DNSRECEIVER_HH_
