//===========================================================================
//  $Name: cflowd-2-1-b1 $
//  $Id: CflowdCiscoFlowEngineMap.hh,v 1.3 1998/09/21 17:03:45 dwm Exp $
//===========================================================================
//  CAIDA Copyright Notice
//
//  By accessing this software, cflowd++, you are duly informed
//  of and agree to be bound by the conditions described below in this
//  notice:
//
//  This software product, cflowd++, is developed by Daniel W. McRobb, and
//  copyrighted(C) 1998 by the University of California, San Diego
//  (UCSD), with all rights reserved.  UCSD administers the CAIDA grant,
//  NCR-9711092, under which part of this code was developed.
//
//  There is no charge for cflowd++ software. You can redistribute it
//  and/or modify it under the terms of the GNU General Public License,
//  v.  2 dated June 1991 which is incorporated by reference herein.
//  cflowd++ is distributed WITHOUT ANY WARRANTY, IMPLIED OR EXPRESS, OF
//  MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE or that the use
//  of it will not infringe on any third party's intellectual property
//  rights.
//
//  You should have received a copy of the GNU GPL along with cflowd++.
//  Copies can also be obtained from:
//
//    http://www.gnu.org/copyleft/gpl.html
//
//  or by writing to:
//
//    University of California, San Diego
//
//    SDSC/CAIDA
//    9500 Gilman Dr., MS-0505
//    La Jolla, CA 92093 - 0505  USA
//
//  Or contact:
//
//    info@caida.org
//===========================================================================

#ifndef _CFLOWDCISCOFLOWENGINEMAP_HH_
#define _CFLOWDCISCOFLOWENGINEMAP_HH_

extern "C" {
#include <sys/types.h>

#include "caida_t.h"
}

#include <map>

#include "CflowdCiscoFlowEngine.hh"

typedef map<uint8_t,CflowdCiscoFlowEngine,less<uint8_t> > _CflowdCiscoFlowEngineMap_t;

//---------------------------------------------------------------------------
//  class CflowdCiscoFlowEngineMap
//---------------------------------------------------------------------------
//  This class is used to hold CflowdCiscoFlowEngine objects so we
//  can track flow-export sequence numbers on a per-flow-engine basis
//  (VIP adapters can send flows with their own sequnce numbers).
//
//  This class is just inherited from an instantation of an STL map
//  of CflowdCiscoFlowEngine keyed by a uint8_t (the flow engine
//  identifier).
//---------------------------------------------------------------------------
class CflowdCiscoFlowEngineMap : public _CflowdCiscoFlowEngineMap_t
{
public:
private:
};

#endif  // _CFLOWDCISCOFLOWENGINEMAP_HH_
