//===========================================================================
//  $Name: cflowd-2-1-b1 $
//  $Id: CflowdCiscoMap.hh,v 1.4 1999/05/25 10:27:06 dwm Exp $
//===========================================================================
//  CAIDA Copyright Notice
//
//  By accessing this software, cflowd++, you are duly informed
//  of and agree to be bound by the conditions described below in this
//  notice:
//
//  This software product, cflowd++, is developed by Daniel W. McRobb, and
//  copyrighted(C) 1998 by the University of California, San Diego
//  (UCSD), with all rights reserved.  UCSD administers the CAIDA grant,
//  NCR-9711092, under which part of this code was developed.
//
//  There is no charge for cflowd++ software. You can redistribute it
//  and/or modify it under the terms of the GNU General Public License,
//  v.  2 dated June 1991 which is incorporated by reference herein.
//  cflowd++ is distributed WITHOUT ANY WARRANTY, IMPLIED OR EXPRESS, OF
//  MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE or that the use
//  of it will not infringe on any third party's intellectual property
//  rights.
//
//  You should have received a copy of the GNU GPL along with cflowd++.
//  Copies can also be obtained from:
//
//    http://www.gnu.org/copyleft/gpl.html
//
//  or by writing to:
//
//    University of California, San Diego
//
//    SDSC/CAIDA
//    9500 Gilman Dr., MS-0505
//    La Jolla, CA 92093 - 0505  USA
//
//  Or contact:
//
//    info@caida.org
//===========================================================================

#ifndef _CFLOWDCISCOMAP_HH_
#define _CFLOWDCISCOMAP_HH_
extern "C" {
#include <sys/types.h>

#include "caida_t.h"
}

#include <map>

#include "CflowdCisco.hh"

typedef map<ipv4addr_t,CflowdCisco *,less<ipv4addr_t> > _CflowdCiscoMap_t;

//---------------------------------------------------------------------------
//  class CflowdCiscoMap : public _CflowdCiscoMap_t             
//---------------------------------------------------------------------------
//  This class is used to contain all of our CflowdCisco objects in
//  cflowd.  We just inherit from an STL map of CflowdCisco pointers
//  keyed by IP address.  We use pointers here because we only have
//  N 'true' CflowdCisco objects (corresponding to N routers), but
//  may have M entries in the map where M > N.  This allows us to
//  have multiple keys for the same CflowdCisco object so we can
//  find a CflowdCisco in the map using one of its interface IP
//  addresses (assuming we put corresponding entries in the map).
//---------------------------------------------------------------------------
class CflowdCiscoMap : public _CflowdCiscoMap_t
{
public:
  typedef _CflowdCiscoMap_t::iterator        iterator;
  typedef _CflowdCiscoMap_t::const_iterator  const_iterator;
  
  //-------------------------------------------------------------------------
  //                              void Clear()
  //.........................................................................
  //  Clears the map.
  //-------------------------------------------------------------------------
  void Clear();
  
  //-------------------------------------------------------------------------
  //                   ostream & Write(ostream & os) const
  //.........................................................................
  //  Writes the contents of the map to an ostream.  Returns the
  //  ostream.
  //-------------------------------------------------------------------------
  ostream & Write(ostream & os) const;
  
  //-------------------------------------------------------------------------
  //                         int Write(int fd) const
  //.........................................................................
  //  Writes the contents of the map to a file descriptor.  Returns
  //  the number of bytes written on success, -1 on failure.
  //-------------------------------------------------------------------------
  int Write(int fd) const;
  
  //--------------------------------------------------------------------------
  //                         int GetInterfaceInfo() 
  //..........................................................................
  //  
  //--------------------------------------------------------------------------
  int GetInterfaceInfo();
  
};

#endif  // _CFLOWDCISCOMAP_HH_
