//===========================================================================
//  $Name: cflowd-2-1-b1 $
//  $Id: CflowdCollector.hh,v 1.2 1998/09/21 17:38:44 dwm Exp $
//===========================================================================
//  CAIDA Copyright Notice
//
//  By accessing this software, cflowd++, you are duly informed
//  of and agree to be bound by the conditions described below in this
//  notice:
//
//  This software product, cflowd++, is developed by Daniel W. McRobb, and
//  copyrighted(C) 1998 by the University of California, San Diego
//  (UCSD), with all rights reserved.  UCSD administers the CAIDA grant,
//  NCR-9711092, under which part of this code was developed.
//
//  There is no charge for cflowd++ software. You can redistribute it
//  and/or modify it under the terms of the GNU General Public License,
//  v.  2 dated June 1991 which is incorporated by reference herein.
//  cflowd++ is distributed WITHOUT ANY WARRANTY, IMPLIED OR EXPRESS, OF
//  MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE or that the use
//  of it will not infringe on any third party's intellectual property
//  rights.
//
//  You should have received a copy of the GNU GPL along with cflowd++.
//  Copies can also be obtained from:
//
//    http://www.gnu.org/copyleft/gpl.html
//
//  or by writing to:
//
//    University of California, San Diego
//
//    SDSC/CAIDA
//    9500 Gilman Dr., MS-0505
//    La Jolla, CA 92093 - 0505  USA
//
//  Or contact:
//
//    info@caida.org
//===========================================================================

#ifndef _CFLOWDCOLLECTOR_HH_
#define _CFLOWDCOLLECTOR_HH_

extern "C" {
#include <sys/types.h>

#include "caida_t.h"
}

//---------------------------------------------------------------------------
//  class CflowdCollector
//---------------------------------------------------------------------------
//  This class abstracts a central collector for cflowd (corresponding
//  to a COLLECTOR stanza in cflowd.conf).
//---------------------------------------------------------------------------
class CflowdCollector
{
public:
  //-------------------------------------------------------------------------
  //                            CflowdCollector()
  //.........................................................................
  //  constructor
  //-------------------------------------------------------------------------
  CflowdCollector();
  
  //-------------------------------------------------------------------------
  //                           ~CflowdCollector()
  //.........................................................................
  //  destructor
  //-------------------------------------------------------------------------
  ~CflowdCollector();
  
  //-------------------------------------------------------------------------
  //                      ipv4addr_t IpAddress() const
  //.........................................................................
  //  Returns the IP address of the collector (corresponding to the
  //  HOST setting in the COLLECTOR stanza in cflowd.conf).
  //-------------------------------------------------------------------------
  ipv4addr_t IpAddress() const;
  
  //-------------------------------------------------------------------------
  //                 ipv4addr_t IpAddress(ipv4addr_t ipAddr)
  //.........................................................................
  //  Sets and returns the IP address of the collector.
  //-------------------------------------------------------------------------
  ipv4addr_t IpAddress(ipv4addr_t ipAddr);
  
  //-------------------------------------------------------------------------
  //                        uint8_t AuthType() const
  //.........................................................................
  //  Returns the authorization type we'll use for the collector.
  //  Currently this is unused.
  //-------------------------------------------------------------------------
  uint8_t AuthType() const;
  
  //-------------------------------------------------------------------------
  //                   uint8_t AuthType(uint8_t authType)
  //.........................................................................
  //  Sets and returns the authorization type we'll use for the
  //  collector.  Currently this is unused.
  //-------------------------------------------------------------------------
  uint8_t AuthType(uint8_t authType);
  
private:
  ipv4addr_t   _ipAddr;
  uint8_t      _authType;
};

#endif  // _CFLOWDCOLLECTOR_HH_
