//===========================================================================
//  @(#) $Name: cflowd-2-1-b1 $
//  @(#) $Id: CflowdFlowPortList.hh,v 1.4 1998/10/19 22:40:50 dwm Exp $
//===========================================================================
//  CAIDA Copyright Notice
//
//  By accessing this software, cflowd++, you are duly informed
//  of and agree to be bound by the conditions described below in this
//  notice:
//
//  This software product, cflowd++, is developed by Daniel W. McRobb, and
//  copyrighted(C) 1998 by the University of California, San Diego
//  (UCSD), with all rights reserved.  UCSD administers the CAIDA grant,
//  NCR-9711092, under which part of this code was developed.
//
//  There is no charge for cflowd++ software. You can redistribute it
//  and/or modify it under the terms of the GNU General Public License,
//  v.  2 dated June 1991 which is incorporated by reference herein.
//  cflowd++ is distributed WITHOUT ANY WARRANTY, IMPLIED OR EXPRESS, OF
//  MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE or that the use
//  of it will not infringe on any third party's intellectual property
//  rights.
//
//  You should have received a copy of the GNU GPL along with cflowd++.
//  Copies can also be obtained from:
//
//    http://www.gnu.org/copyleft/gpl.html
//
//  or by writing to:
//
//    University of California, San Diego
//
//    SDSC/CAIDA
//    9500 Gilman Dr., MS-0505
//    La Jolla, CA 92093 - 0505  USA
//
//  Or contact:
//
//    info@caida.org
//===========================================================================

#ifndef _CFLOWDFLOWPORTLIST_HH_
#define _CFLOWDFLOWPORTLIST_HH_

extern "C" {
#include <sys/types.h>

#include "caida_t.h"
}

#include <list>

//---------------------------------------------------------------------------
//  class CflowdFlowPort
//---------------------------------------------------------------------------
//  This class is used to hold the port number and socket descriptor
//  for a UDP port on which cflowdmux is listening for flow-export
//  packets.
//---------------------------------------------------------------------------
class CflowdFlowPort
{
public:
  //-------------------------------------------------------------------------
  //                            CflowdFlowPort()
  //.........................................................................
  //  constructor
  //-------------------------------------------------------------------------
  CflowdFlowPort();
  
  //-------------------------------------------------------------------------
  //                            ~CflowdFlowPort()
  //.........................................................................
  //  destructor
  //-------------------------------------------------------------------------
  ~CflowdFlowPort();

  //-------------------------------------------------------------------------
  //                              void Close()
  //.........................................................................
  //  Closes the flow port.
  //-------------------------------------------------------------------------
  void Close();
  
  //-------------------------------------------------------------------------
  //                               int  Open()
  //.........................................................................
  //  Opens the flow port.  Returns 0 on success, -1 on failure.
  //-------------------------------------------------------------------------
  int Open();

  //-------------------------------------------------------------------------
  //      CflowdFlowPort & operator = (const CflowdFlowPort & flowPort)
  //.........................................................................
  //  Overloaded '=' operator.
  //-------------------------------------------------------------------------
  CflowdFlowPort & operator = (const CflowdFlowPort & flowPort);
  
  int         fd;       //  fd I'm using to get data from the port
  uint16_t    portnum;  //  the port number I'm listening on
  
};

typedef list<CflowdFlowPort> _CflowdFlowPortList_t;

//---------------------------------------------------------------------------
//  class CflowdFlowPortList : public _CflowdFlowPortList_t
//---------------------------------------------------------------------------
//  This class is used to hold all of the CflowdFlowPort objects
//  in cflowdmux.  We just inherit from an STL list of CflowdFlowPort
//  objects and add a few things.
//---------------------------------------------------------------------------
class CflowdFlowPortList : public _CflowdFlowPortList_t
{
public:
  typedef _CflowdFlowPortList_t::iterator         iterator;
  typedef _CflowdFlowPortList_t::const_iterator   const_iterator;
  
  //-------------------------------------------------------------------------
  //                             void CloseAll()
  //.........................................................................
  //  Closes all of the sockets in the port list.
  //-------------------------------------------------------------------------
  void CloseAll();
  
  //-------------------------------------------------------------------------
  //                              int OpenAll()
  //.........................................................................
  //  Opens all of the sockets in the port list.  Returns -1 on any
  //  error, the total number of ports on success.
  //-------------------------------------------------------------------------
  int OpenAll();
  
  //-------------------------------------------------------------------------
  //                              void Clear()
  //.........................................................................
  //  Closes all the sockets in the port list and clears the port
  //  list.
  //-------------------------------------------------------------------------
  void Clear();
  
  //-------------------------------------------------------------------------
  //                            fd_set & FdSet()
  //.........................................................................
  //  Returs a reference to the fd_set for the port list.  The fd_set
  //  will have the bit set for each open socket descriptor we have
  //  in our list.
  //-------------------------------------------------------------------------
  fd_set & FdSet();
  
  //-------------------------------------------------------------------------
  //                            int MaxFd() const
  //.........................................................................
  //  Returns the max descriptor number we have open in the port list.
  //  This is generally used as an aid to setting the first argument
  //  to select().
  //-------------------------------------------------------------------------
  int MaxFd() const;
  
private:
  fd_set  _fdSet;
  int     _maxFd;
};

#endif  // _CFLOWDFLOWPORTLIST_HH_
